----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
tracking_fol = 'tracking/'
scheme_kind = 'bgk'
bc_inlet = 'spc_inlet_ubb'
bc_inlet = 'spc_inlet_eq'
bc_inlet = 'spc_molefrac'

bc_outlet = 'spc_outlet_expol'
bc_outlet = 'spc_outlet_eq'
bc_outlet = 'spc_outlet_vel'
bc_outlet = 'spc_vel_bb'

bc_mem = 'wall'
bc_mem = 'spc_blackbox_mem_ion'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
control_routine = 'fast'
-- Simulation name
simulation_name = 'spacer'
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}
logging = { level = 5 }

-- Time step settings
interval = tmax_p/10
tmax_int = 100
interval_int = tmax_int/10
sim_control = {
  time_control = {
    max = {sim=tmax_p,clock=60*60*4-5*60}, 
    interval = interval 
  } --time_control end

--time_control = {
--  max = {iter=tmax_int}, 
--  interval = {iter=interval_int}
--}
}   ---sim_control end 

restart = {
      read = 'restart/spacer_lastHeader.lua',
      write = 'restart/',
      time_control = { min = 0, max = tmax_p, interval = tmax_p/8},
}

physics = { dt = dt, 
            molWeight0 = m_min, 
            moleDens0 = moleDens0 }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      --relaxation = 'bgk', 
      relaxation = scheme_kind, 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  external_force = { electric_fieldX = 0.0,
                     electric_fieldY = 1e-8,
                     electric_fieldZ = 0.0},
---mixture table --
  mixture = { rho0 = rho0_p, moleDens0 = moleDens0,
              omega_diff = omega_diff,
              kine_shear_viscosity = nu_phy,
              --omega_kine = omega_kine,
              theta_eq = 1.0,
              omega_hom = 0.0001,
              --bulk_viscosity = 1e-7,
              temp = 293.15,
              -- just to check for lattice electric field
              electricField = { 0.0, 1e-8, 0.0},
              gravityField = { 0.0, 0.0, 0.0},
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl},
                charge_nr = charge_nr_H2O}
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_H2O,
      velocityX = 0.0,--IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet_dilute',
       kind = bc_inlet,
       molefraction = BC_H2O,
     },
     {
       label = 'inlet_concentrate',
       kind = bc_inlet,
       molefraction = BC_H2O,
     },
     {
       label = 'outlet_dilute',
       kind = bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },
     {
       label = 'outlet_concentrate',
       kind = bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },

     { label = 'cem', kind = 'wall'},
     { label = 'aem_dilute', kind = 'wall'},
     { label = 'aem_concentrate', kind = 'wall'},
     { label = 'spacer', kind = 'wall'}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl },
                charge_nr = charge_nr_Na}
   ,initial_condition = {
      molefraction = IC_Na,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet_dilute',
       kind = bc_inlet,
       molefraction = BC_Na,
     },
     {
       label = 'inlet_concentrate',
       kind = bc_inlet,
       molefraction = BC_Na,
     },
     {
       label = 'outlet_dilute',
       kind =  bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },
     {
       label = 'outlet_concentrate',
       kind =  bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },
     { label = 'cem', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = 0.971 },
     { label = 'aem_dilute', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = (1.0-0.998) },
     { label = 'aem_concentrate', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = (1.0-0.998) },
     { label = 'spacer', kind = 'wall'}
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag },
                charge_nr = charge_nr_Cl}
   ,initial_condition = {
      molefraction = IC_Cl,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet_dilute',    ---inlet
       kind = bc_inlet,
       molefraction = BC_Cl,
     },
     {
       label = 'inlet_concentrate',    ---inlet
       kind = bc_inlet,
       molefraction = BC_Cl,
     },
     {
       label = 'outlet_dilute',    ---outlet
       kind =  bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },
     {
       label = 'outlet_concentrate',    ---outlet
       kind =  bc_outlet,
       velocityX = velocityX,
       velocityY = 0.0,
       velocityZ = 0.0,
     },
     { label = 'cem',     ---north
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = (1.0-0.971) },
     { label = 'aem_dilute', 
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = 0.998 },
     { label = 'aem_concentrate', 
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = 0.998 },
     { label = 'spacer', kind = 'wall'}
    }
  } -- cl
  } -- field
}


