simulation_name = 'dynamic_LB'
mesh            = 'mesh/'
tmax            = 512
scaling         = 'acoustic'
-------------------------------------------------------------------------------
sim_control = {
  time_control = {
    min = { iter = 0    },
    max = { iter = tmax },
    interval = { iter = tmax / 10 },
  }
  -- time_control = { 
  --   min = 0.0,
  --   max = 7.2,
  --   interval = 1.8
  -- }
}
-------------------------------------------------------------------------------
--The load balancing table defines the kind of balancing we want to have as 
--well as the intervals during which we wish to have load balances. For example, 
--in the representative case below, the load balancing is performed for the first
--time at the 3rd time step and then this is performed after every 4th time step
balance = { static = false, dynamic = true, kind = 'levelwise',
  time_control = { min = {iter=tmax / 2}, interval = {iter=4}, max = {iter=tmax/2} },
  -- time_control = { min = 5.4, interval = 1.8, max = 5.4 },
  folder   = 'balance/',
}

logging = { level = 10 }

ebug = {
  debugMode = true,
  debugFiles = true,
  debugAuxLists = true,
  dumpDependencies = true,
  dumpBoundaries = false,
  logging = { level = 3, filename = 'dbg', root_only = false, },
}

-- Initial condition 
rho0   = 1.
cs2    = 1./3.
physics = {dt = 1.8, rho0 = 1.0}
initial_condition = {
  pressure = rho0*cs2,
  velocityX = 0.0, velocityY = 0.0, velocityZ = 0.0,
}

-- Boundary conditions
boundary_condition = {
  { label = 'inlet', kind = 'inlet_ubb', velocity = { 0.06, 0, 0, }, },
  { label = 'wall', kind = 'wall'},
  { label = 'outlet', kind = 'outlet_expol', pressure = rho0*cs2, },
}

fluid = { omega = 1.8, rho0 = 1.0 }
identify   = {
  label  = simulation_name,
  kind   = 'lbm', 
  layout = 'd3q19',
  relaxation='bgk'
}

NOtracking = {
{ label = 'velocityProfile',
  variable = {'velocity'},
  shape= { kind = 'canoND', object={origin ={  0., -20., 0.}, vec = {  0.,40.,0.},
                                    segments = 4} },
  time_control = { min = {iter=tmax}}, -- dump at last timestep
  folder = 'tracking/',
  output={format = 'asciiSpatial'}
  },
{ label = 'pressureDrop',
  variable = {'density'}, 
  shape= { kind = 'canoND', object={origin ={-75., 0., 0.}, vec = {150.,0.,0.}, 
                                    segments=100} },
  time_control = { min = {iter=tmax}},
  folder = 'tracking/',
  output={format = 'asciiSpatial'}
  },
}
-- Restart settings
estart= {
  ead = 'restart/dynamic_LB_lastHeader.lua',
  write = 'restart/', -- the folder the restart files are written to
  time_control = { min = 1.8, interval = 1.8, max = 7.2 },
}
