----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true
scaling = 'diffusive'

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'multispecies'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

ebug = {debugMode = true, debugFiles = true}

-- Time step settings
tmax           =  1000     -- total iteration number
sim_control = {
  time_control = {
    max = {iter=tmax}, 
    interval = {iter=tmax/10} 
  }  
}  

identify = {
    kind = 'multi-species_gas', 
--      relaxation = 'bgk', 
-- scheme layout
    layout = 'd3q19'
}
mixture = { rho0 = 1.0, mega_diff = 2.0, mega_kine = 2.0, 
            initial_condition = {pressure = 0.0} }
-- field which defines fluid or specie
-- Single fluid simulation
field = {{
    label = 'H2'
-- species properties
   ,species = { molweight = m1, diff_coeff = diff_coeff1 }
-- Initial condition
   ,initial_condition = { 
            pressure = species1Per,
--              pressure = species1Noflux,
--              pressure = 1.0,
            velocityX = 0.0,
            velocityY = 0.0,
            velocityZ = 0.0}
   }
 ,{
   label = 'N2'
  ,species = { molweight = m2, diff_coeff = diff_coeff2 }
  ,initial_condition = {
       pressure = species2Per,
--         pressure = species2Noflux,
--         pressure = 1.0,
       velocityX = 0.0,
       velocityY = 0.0,
       velocityZ = 0.0}
  }
 ,{
   label = 'CO2'
  ,species = { molweight = m3, diff_coeff = diff_coeff3 }
  ,initial_condition = {
       pressure = species3Per,
--         pressure = species3Noflux,
--         pressure = 1.0,
       velocityX = 0.0,
       velocityY = 0.0,
       velocityZ = 0.0}
  }
}
 
tracking = {
  {
   label = 'line', 
   variable = {
     'H2_mole_fraction','N2_mole_fraction','CO2_mole_fraction','mole_fraction'
   },
   folder = './',
   shape = {kind = 'canoND', object= {origin={0.0,length/2.0,length/2.0},
                                      vec={length,0.0,0.0},
                                      segments = 1000 }
           },
   output={format = 'asciiSpatial'},
   time_control = {min = {iter=tmax}, interval={iter=tmax}}, 
  }
}
