----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- Musubi configuration file. 

require "common"
tracking_fol = 'tracking/'
restart_fol = 'restart/'

-- This is a LUA script.
--dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
--dt = getdtFromVel( {dx = dx, u_p = u_in_phy, u_l = u_in_L } )
--omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

-- Simulation name
simulation_name = 'Poisson'
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
scaling = 'acoustic'
control_routine = 'fast'
io_buffer_size = 10 -- default is 80 MB

-- Time step settigs
tmax = 10000
interval = tmax/100
sim_control = {
  time_control = { 
    max = {iter=tmax},
    interval = {iter=interval}
  } -- time control
 ,abort_criteria = {
    steady_state = true,
    convergence = {
      variable = {'potential_phy'}, 
      shape = { kind='all'
      },
      time_control = {min = {iter=10000}, max = {iter=tmax}, interval = {iter=10}},
      reduction = 'average',
      norm='average', nvals = 100, absolute = true,
      condition = { threshold = 1.e-10, operator = '<=' }
    }
  }
} -- simulation control

-- restart 
NOrestart = {
      NOread = restart_fol..'FlowAroundCyl_lastHeader.lua',
      write = restart_fol,
 }

logging = {level=10}

-- needed to dump variable in physical unit
physics = { dt = dx, rho0=1000.0, temp0=273.0 }

poisson_boltzmann = {   
  omega = 1.0,
  temp = 273.0 , 
  c_infinity = 0.1,
  height = dx,       
  zeta_potential= -10e-3,
  permittivity= 6.95e-10,
  valence= 1.0,
  alpha= 1.0/2.0
}
interpolation_method = 'linear'

-- Initial condition 
initial_condition = { potential = 0.0 }

identify = {layout='d2q9',
            kind='poisson_boltzmann',
            relaxation = 'bgk'}

lambda = 2.0
nu = math.sqrt( lambda^2 + math.pi^2)
function sinh(x)
  return (math.exp(x)-math.exp(-x))*0.5
end
function analy_pot(x,y,z,t)
  return math.cos(math.pi*x)*sinh(nu*(1.0-y))/sinh(nu)
end
-- Boundary conditions
boundary_condition = {  
{ label = 'left', 
  kind = 'potential_dirichlet',
  potential = analy_pot
},
{ label = 'right',
   kind = 'potential_dirichlet',
   potential = analy_pot }, 
{ label = 'top', 
   kind = 'potential_dirichlet',
   potential =  analy_pot }, 
{ label = 'bottom', 
   kind = 'potential_dirichlet' ,
   potential = analy_pot }, 
 }

variable = {
  {
    name = 'analy_pot',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = analy_pot
  },
  {
    name = 'error',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'potential_phy','analy_pot'}
    }
  }
}

-- Tracking
tracking = {
--  {
--    label = 'probe_potential', 
--    folder = tracking_fol,
--    variable = {'potential_phy'}, 
--    shape = {
--            {kind = 'canoND', object = {origin ={length*0.5,length*0.5, zpos} }},
--            },
--    time_control = {min = 0, max = tmax, interval = {iter=10}},
--    output={format = 'ascii'}
--  },
  {
   label = 'plane', 
   folder = tracking_fol,
   variable = {'potential_phy','analy_pot','error'}, 
   shape = {kind = 'canoND', 
     object = {origin = {-dx,-dx,zpos},
     vec = {{ length+2*dx, 0.0,0.0},
            {0.0,length+2*dx,0.0}},
     segments = {202,202}
     }
   },
   time_control = {min = tmax, max = tmax, interval = tmax},
   output={format = 'asciiSpatial'}      
  },
  {
   label = 'l2error', 
   folder = tracking_fol,
   variable = {'error'}, 
   shape = {kind = 'canoND', 
     object = {origin = {-dx,-dx,zpos},
     vec = {{ length+2*dx, 0.0,0.0},
            {0.0,length+2*dx,0.0}},
     segments = {202,202}
     }
   },
   reduction = 'l2norm',
   time_control = {min = tmax, max = tmax, interval = tmax},
   output={format = 'ascii', use_get_point = true}      
  },
  {
   label = 'line', 
   folder = tracking_fol,
   variable = {'potential_phy','analy_pot'}, 
   shape = {kind = 'canoND', 
     object = {origin = {0.0,dx/2.,zpos},
     vec = { length+dx, 0.0,0.0},
     segments = {102}
     }
   },
   time_control = {min = tmax, max = tmax, interval = tmax},
   output={format = 'asciiSpatial'}      
  }

}

