-- Musubi configuration file. 
require 'seeder'

--flow parameters
nu_phy = 1e-3 --m^2/s
rho0_p = 1.0
rho0_L = 1.0
cs2 = 1.0/3.0

Re = 5.0
u_mean_phy = Re*nu_phy/height

ref_press = 1.0

function u_analy(x,y,z) 
  return u_mean_phy*((math.exp(Re*(y/height))-1.0)/(math.exp(Re)-1.0))
  --return (0.5/(rho0_p*nu_phy))*press_grad*(height*0.5-y)*(height*0.5+y)
end

scaling = 'acoustic'

omega = 1.6
nu_L = (1.0/omega-0.5)/3.0
dt = nu_L*dx^2/nu_phy
u_mean_L = u_mean_phy*dt/dx

bc_kind = 'vel_dirichlet'

-- Simulation name
simulation_name = 'channel'
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
control_routine = 'fast'
NOdebug = {logging = {level=1, filename='dbg', root_only=false}}
logging = {level=3}
-- Time step settigs
tmax_p = 10000 --s
tmax =  tmax_p/dt    -- total iteration number
interval_p = 1 -- s
interval = interval_p/dt
sim_control = {
  time_control = { 
    max = {sim=tmax_p}, 
    interval = {sim=interval_p}
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true,
    convergence = {
     variable = {'vel_mag_phy'}, 
     shape = {kind = 'all'},
     time_control = {min = 1, max = tmax_p, interval = 10*dt},
     reduction = {'average'},
     norm='average', nvals = 50, absolute = true,
     condition = {
       { threshold = 1.e-10, operator = '<=' }}
    },
  }
}

NOrestart = {
      ead = 'restart/channel2D_lastHeader.lua',
      write = 'restart/',
}

fluid = { 
           omega = omega,
           rho0 = rho0_p }

interpolation_method = 'linear'                     

-- Initial condition 
initial_condition = { 
  pressure = ref_press, 
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0 
}

identify = {
  label='2D',
  layout='d2q9', 
  relaxation='mrt',
  kind = 'lbm_incomp'
}

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- Boundary conditions
boundary_condition = {  
  {   
    label = 'north', 
    kind = bc_kind,
    velocity = {u_mean_phy, u_mean_phy,0.0},
    curved = false,
  },
  {
    label = 'south', 
    kind = bc_kind,
    velocity = {0.0, u_mean_phy,0.0},
    curved = false,
  },
}

variable = {
  { name='vel_an', 
    ncomponents=1, 
    vartype = 'st_fun', 
    st_fun=u_analy 
  },
  { name='diff_vel', 
    ncomponents=1, 
    vartype = 'operation', 
    operation = {
      kind='difference', 
      input_varname={'vel_mag_phy','vel_an'} 
    }
  },
}

-- Tracking              
tracking = {
--  {
--    label = 'probe', 
--    folder = 'tracking/',
--    variable = {'pressure_phy','velocity_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,height*0.5,zpos} 
--      } 
--    },
--    time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
--    output = {format = 'ascii'}
--  },
  {
    label = 'vtk', 
    folder = 'vtkfiles/',
    variable = {'pressure_phy','velocity_phy','vel_an'}, 
    shape = {kind = 'all'},
    time_control = {min= 0, max = tmax_p, interval = tmax_p/100},
    output = {format = 'vtk'}
  },
--  {
--    label = 'pressInlet', 
--    folder = 'tracking/',
--    variable = {'pressure_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={dx/2.0,0.0,zpos},
--        vec = {0.0,height,0.0},
--        segments = nHeight+2
--      } 
--    },
--    time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--    output = {format = 'asciiSpatial'}
--  },
--  {
--    label = 'pressOutlet', 
--    folder = 'tracking/',
--    variable = {'pressure_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length-dx/2.0,0.0,zpos},
--        vec = {0.0,height,0.0},
--        segments = nHeight+2
--      } 
--    },
--    time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--    output = {format = 'asciiSpatial'}
--  },
--  {
--    label = 'press_line', 
--    folder = 'tracking/',
--    variable = {'pressure_phy','press_an','diff_press'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={0.0,height*0.5,zpos},
--        vec = {length,0.0,0.0},
--        segments = nLength+2
--      } 
--    },
--    time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--    output = {format = 'asciiSpatial'}
--  },
--  { label = 'press_l2norm',
--    variable = {'diff_press', 'press_an'},
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={0.0,height*0.5,zpos},
--        vec = {length,0.0,0.0},
--        segments = nLength+2
--      }
--    },
--    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--    reduction = {'l2norm', 'l2norm'},
--    folder = './tracking/',
--    output = {format = 'asciiSpatial'}
--  },
--  {
--    label = 'vel_centerLine', 
--    folder = 'tracking/',
--    variable = {'velocity_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={0.0,height*0.5,zpos},
--        vec = {length,0.0,0.0},
--        segments = nLength+2
--      } 
--    },
--    time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--    output = {format = 'asciiSpatial'}
--  },
--  { label = 'vel_spatial',
--    variable = {'velocity_phy','vel_mag_phy','vel_an', 'diff_vel'},
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,0.0,zpos},
--        vec = { 0.0, height, 0.0},
--        segments = nHeight+2
--      }
--    },
--    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--    folder = './tracking/',
--    output = {format = 'asciiSpatial'}
--  },
--  { label = 'vel_l2norm',
--    variable = {'diff_vel','vel_an'},
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,0.0,zpos},
--        vec = { 0.0, height, 0.0},
--        segments = {nHeight+2} 
--      }
--    },
--    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--    reduction = {'l2norm', 'l2norm'},
--    folder = './tracking/',
--    output = {format = 'asciiSpatial'}
--  },
--  { label = 'wss_spatial',
--    variable = { 'wss_phy', 'wss_an', 'diff_wss'},
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,0.0,zpos},
--        vec = { 0.0, height, 0.0},
--        segments = {nHeight+2} 
--      }
--    },
--    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--    folder = './tracking/',
--    output = {format = 'asciiSpatial'}
--    },
--  
--  { label = 'wss_l2norm',
--    variable = {'diff_wss','wss_an'},
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,0.0,zpos},
--        vec = { 0.0, height, 0.0},
--        segments = {nHeight+2} 
--      }
--    },
--    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--    reduction = {'l2norm', 'l2norm'},
--    folder = './tracking/',
--    output = {format = 'asciiSpatial'}
--  },
}
