#!/bin/bash
#
# This script runs the gaussian 1d pulse test case including and without
# refinement.
# It generates a reference solution on a fine level and fits the 
# two gaussian pulses to a reference function.
# This function is later used in runs as a reference to compare 
# against and to extract a l2norm
#
#
#SBATCH --time=24:00:00
#SBATCH --mail-type=END
#SBATCH --mail-user=m.hasert@grs-sim.de
#SBATCH -N 2
#SBATCH -p quelea


echo "Starting run.sh test run for the channel pressure drop test case"
maxLevel=9  # up to which level?
minLevel=6 # minimum level
run=1      # actually perform runs?
run_reference=0 # run the reference run
run_comparison=1 # run the reference run
checkSchemes='singleLevel eqneq quadraticCompact'
simname=channel

export OBSTACLE=0
nprocs=16

seeder=$SEEDER
musubi="mpirun -np $nprocs $MUSUBI"

tmpfile='tmp.res'
rm $tmpfile

if [ $run -eq 1 ]; then
  # first clean up
  echo '################## cleaning tracking folder'
  rm tracking/*
  mkdir tracking
  rm output/*

  if [ $run_reference -eq 1 ]; then
    # first set level to highest
    refinement=0
    export REFINEMENT=$refinement
    level=$maxLevel
    export LEVEL=$level
    echo '################## setting level to' $level
    # run seeder to generate the finest mesh
    $seeder
    # run musubi to get reference results 
    echo '################## running musubi  '
    $musubi

    # Get the reference file
    resFile=`ls tracking/*reference*pressCutX*.res`
    echo '################## getting reference file' $resFile
    echo '################## copying ' $resFile ' to refData.res'
    # Merge all results (of multiple processes) into one file
    cat $resFile > refData.res
    # and remove the commentary lines
    sed -i '/#/d' refData.res 

    # Fit the values from the reference run to a polynomial
    echo '################## Fit values '
    res="$(python ref/fitPoly.py)"
    echo '################## Result    ' $res
  fi
fi

if [ $run_comparison -eq 1 ]; then
  count=0
  for scheme in $checkSchemes; do
    count=$(($count+1))
    export INTERPOLATION_METHOD=$scheme
    echo '################## Setting interpolation method to' $scheme
    echo `echo $INTERPOLATION_METHOD`
    if [ $run -eq 1 ]; then
      # and now run the comparison runs with single Level
      echo '##################   ' 
      echo '################## Now do comparison runs for ' $scheme
      if [ "$scheme" = "singleLevel" ]; then
        refinement=0
      else 
        refinement=1
      fi
      export REFINEMENT=$refinement
      echo '################## Setting refinement globally to' $refinement
      echo `echo $REFINEMENT`

      level=$minLevel
      while [ $level -le $maxLevel ]
        do
          export LEVEL=$level
          echo '################## Running comparison runs with level' $level 'and scheme' $scheme
          echo `echo $LEVEL`
          $seeder
          $musubi
          level=$(($level+1))
        done
    fi
  done

    for analysis in press vel; do
      if [ "$analysis" = "press" ]; then
        string='pressCutX'
        pos=1
      elif [ "$analysis" = "vel" ]; then
        string='velX'
        pos=2
      fi
      level=$minLevel
      while [ $level -le $maxLevel ]
        do
         for scheme in $checkSchemes; do

          export LEVEL=$level
          echo ' Analyzing ' $level
          rm tracking/merge_${scheme}_${string}_l${level}.res
          mergefiles=`ls tracking/*${scheme}*${string}*_l${level}_*.res`
          echo 'all mergefiles' $mergefiles
          cat $mergefiles  
          for mergefile in $mergefiles; do
            echo " trying to merge" $mergefile
            cat ${mergefile}  | grep -v "#" >> tracking/merge_${scheme}_${string}_l${level}.res | sort -g
          done
      gnuplotfile="plot_${analysis}_${level}.gpl"
      echo '##################                 '
      echo '################## Spatial analysis                  '
      ############## Spatial analysis
      # Merge files from different processes
      CMD="ls tracking/merge_*${scheme}*${string}*${level}*.res"
      physString=$(tail -n 1 params_l${level})
      IFS=" "
      set $physString
      cnt=1
      for physVar in $physString
        do
          if [ $cnt -eq 1 ]; then
            dxPhys=$physVar
          elif [ $cnt -eq 2 ]; then
            dtPhys=$physVar
          fi
          cnt=$(($cnt+1))
      done
      echo dxPhys $dxPhys dtPhys $dtPhys
      # assemble ls command
      echo command is $CMD
      # execute ls command and store into files
      files=$($CMD)
      echo Files $files
      echo 'set title "refinement study"' > $gnuplotfile
      echo "dxPhys=$dxPhys" >>$gnuplotfile
      echo "dtPhys=$dtPhys" >>$gnuplotfile
      echo 'plot \' >>$gnuplotfile

      nFiles=$($CMD | wc -l)
      echo '################## On files ' $nFiles
      iFile=0
      # Create GNUplot files
      for file in $files; do
        iFile=$((iFile+1))

        echo '################## current file ' $file
#        level=`echo $file | awk 'gsub(/.*_l|.res/,"")' `
        label=`echo $file | awk "gsub(/.*${simname}_|_${string}.*/,\"\")" `

        echo Found FILE and $file LEVEL $level
        if [ $iFile -eq $nFiles ]; then
          suffix=''
        else
          suffix=', \'
        fi
      if [ "$analysis" = "press" ]; then
        echo "\"$file\" u $pos:(\$4*dxPhys**2/dtPhys**2)  w lp t \"$scheme L$level \"${suffix}" >> $gnuplotfile
      elif [ "$analysis" = "vel" ]; then
        echo "\"$file\" u $pos:(\$4*dxPhys/dtPhys)  w lp t \"$scheme L$level \"${suffix}" >> $gnuplotfile
      fi
      done
      
      echo 'pause -1' >>$gnuplotfile
      done
      level=$(($level+1))
    done
        done

fi # run comparison

echo '################## FINISHED                        '
