if os.getenv("LEVEL") == nil then
  level = 5
  print (" LEVEL: Taking local definition     "..level )
else
  level = tonumber(os.getenv("LEVEL"))
  print (" LEVEL: Taking environment variable "..level )
end

if os.getenv("REFINEMENT") == nil then
  refinementLevel = 1
  print (" REFINEMENT: Taking local definition     "..refinementLevel )
else
  refinementLevel = tonumber(os.getenv("REFINEMENT"))
  print (" REFINEMENT: Taking environment variable "..refinementLevel )
end

if os.getenv("INTERPOLATION_METHOD") == nil then
  --interpolation_method = 'average'
  interpolation_method = 'quadraticCompact'
  --interpolation_method = 'linear'
  print (" METHOD: Taking local definition     "..interpolation_method )
else
--  if os.getenv("INTERPOLATION_METHOD") == "singleLevel" then
--    interpolation_method = 'linear'
--  else
    interpolation_method = os.getenv("INTERPOLATION_METHOD")
--  end
  print (" METHOD: Taking environment variable "..interpolation_method )
end

gaussPulse_halfwidth = 0.01
refSolutionLevel = 9
refOmega = 1.95
refLevel = 5
length = 1.0
heightElem_refLevel = 6
refDx = length/(2^refLevel)
refHeight = heightElem_refLevel*refDx
m = 2^(refLevel - level)
omega = 1./(1/m*(1/refOmega -0.5)+0.5)
maxLevel = level+refinementLevel
height = refHeight
dx     = length/(2^level)
dxDash = 0.001*dx
nElemsMax = 2^maxLevel
if refinementLevel == 0 and level == refSolutionLevel then
  label = 'reference'
  referenceRun = true
  print (" ============================================== " )
  print (" ===        Reference RUN                   === " )
  print (" ============================================== " )
else
  if refinementLevel == 0 then
    label = 'singleLevel'
  else
    label = 'RM_'..interpolation_method
  end
  referenceRun = false
end



nIters = nElemsMax*17/16

print ("Reference Level   " .. refLevel)
print ("Coarsening Factor " .. m)
print ("Current level     " .. level)
print ("Current omega     " .. omega)
print ("Channel height    " .. refHeight)
--if level < refLevel then
--  error(' level is smaller than reference level'..refLevel )
--end



