require 'common'
-- directory to write mesh
folder = 'mesh/'

-- How detailed should the output be?
-- The higher the level, the more output you'll get from seeder.
logging = { level = 6 }

NOdebug = {debugMode = true, debugFiles=true}

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

-- A minimum level, by which all parts in the computational domain should at
-- least be resolved with. Default is 0.
minlevel = level

-- *********************** Table of spatial objects *********************** --
-- Each spatial object is defined by an attribute and some geometric entity
-- attached to this attribute. Attributes might be defined multiple times.
-- Attributes are described by a kind (boundary, seed or refinement), a level
-- and maybe further kind specific values, like a label for the boundary.
-- Geometric objects might by right now:
-- - canoND (point, line, plane or box)
-- - STL
-- - Sphere
-- - Cylinder
--
-- Periodic boundaries are special, spatial objects of this kind can only make
-- use of geometric objects of the kind 'periodic'.
spatial_object = {
-- Seed point
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { length/2.0+dx_eps, height/4.0+dx_eps, zpos },
        --vec = {length-dx, 0.0,0.0}
        } --- object
    }
  },


  {
    attribute = {
      kind = 'boundary',  ---kind in attribute is seed/boundary/refinement/periodic
      calc_dist = false,
      label = 'north',     -- for north
    },
    geometry = {
      kind = 'canoND',    -- kind in geometry is canoND/sphere/stl 
      object = {
        origin = { -dx_eps,height+dx_eps,-dx_eps },
        vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,0.0,width+2.*dx_eps}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      calc_dist = false,
      label = 'south',   --- for south
      level = level_wall,
      distance_refine = {
        {
          level_offset = 0,
          radius = 3*dx
        },
        {
          level_offset = -1,
          radius = 6*dx
        },
        {
          level_offset = -2,
          radius = 8*dx
        }
      }
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx_eps,-dx_eps},
        vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,0.0,width+2.*dx_eps}}
        }
    }
  },

  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1={
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,0.0,width+2*dx_eps},
                 {0.0,height+2*dx_eps,0.0}}
        },       
        plane2 = {
          origin = {length+dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {0.0,0.0,width+2.*dx_eps}}
        }
      }  
    }
  },



  {
    attribute = {
      kind = 'periodic', --kind is periodic
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx_eps, -dx_eps, width+dx_eps},
          vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,height+2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {length+2*dx_eps,0.0,0.0}}
        } --- plane2        
      }  
    }
  },
}


