-- Musubi configuration file. 
-- This is a LUA script.
originX = 00.0
originY = 00.0
originZ = 00.0
halfwidth = 3.0
amplitude = 0.1
background = 1.0

function ic_1Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-math.log(2.)/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-math.log(2.)/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end
-- Initial condition 
initial_condition = { --density = {predefined='gausspulse', center={0.0,0.0,0.0}, halfwidth=0.3, amplitude=0.20, background=1.000},
                      density = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
-- Simulation name
simulation_name = 'PeriodicInter_vali'
mesh = 'mesh/'-- Mesh information
--mesh = { predefined='cube',    -- use the predefined full cube
--         origin = {-1.,-1.,-1.},  -- origin of the cube
--         length = 2.,         -- length of the cube
--         refinementLevel = 5 } -- refinement level to resolve the cube

fluid = { omega = 1.98, rho0 = 1.0 }


-- Local refinement settings
interpolation_method = 'compact'
                     
-- Time step settigs
tmax           =  20    -- total iteration number
time = {min = 0, max = tmax, interval = tmax}

-- Output settings
utput = { active = true, -- VTK output activated?
  folder = 'output/',     -- Output location
  vtk = true,             -- VTK output activated?
  time = {min = 0, max = tmax, interval = tmax/20}} 

-- Tracking              
racking = {
{ label = 'probe_press', 
  variable = {'density'}, 
  shape = {kind='canoND',object = {origin ={0.,0.,0.}}},
  time = {min = 0, max = tmax, interval = 1}, 
  format='ascii', folder='tracking/'
  }
  }

-- Restart settings
restart = { ead = 'restart/PeriodicInter_vali_header_00000000.000E+00.lua',
            write = 'restart/',
            time = { min = -1, max = tmax, interval = 1}}
