# Run Musubi with different number of processes and check the restart file, 
# if it is identical by using the checksum (md5sum)
# We run the code for a set of defined processes (procs)
# and check the md5sum of the restart files
# by default this script checks last restart write and read files 
# i.e files written at tmax in config file

#------------------------------------------------------------------------#
#  This file is used for recheck. Please make sure that the modifications
#  you make to use it locally, does not get pushed to the repository
#------------------------------------------------------------------------#



# add path to exec if runninng locally. For recheck leave it to "EXEC".
#executable=EXEC
executable='../../../build/musubi'


error_flag=0

restart_folder='restart/'
restart_Readfolder='restart_read/'

# delete existing restart folders
rm -rf  ${restart_folder} ${restart_Readfolder}

string=''
counter=0

#procs='1 2 3 4 5 6 7 8 9 10 11 12 33 35 36 66 67'
procs='1 2 3 4'

# execute for all procs
for nprocs in $procs;
do
  # generate restart WRITE md5 sums
  counter=$((counter+1))
  mkdir -p ${restart_folder}
  
  mpirun -np ${nprocs} ${executable} musubi_write.lua
  if [ $? -ne 0 ]; 
    then 
      echo Return status: $?
      error_exit "Error during simulation"
  fi
  #file name to store md5sum output from restart write
  sumname=write_${nprocs}.md5

  echo 'Storing restart write md5sum to ' $sumname
  md5sum ${restart_folder}/*.lsb > ${sumname}
  #md5sum ${restart_folder}/*.lsb | awk '{print $1}' | tail -1 > ${sumname}
  #mv fort.66 write_${nprocs}.out
  

  if [ $counter -eq 1 ]; then
    echo 'setting restart write reference MD5sum'
    firstwritesum=$sumname
    tail -1 $sumname | awk '{print $1}' > ref_lastLine
  fi
  
  # generate restart READ md5 sums
  mkdir -p  ${restart_Readfolder}
  mpirun -np ${nprocs} ${executable} musubi_read.lua
  if [ $? -ne 0 ]; 
    then 
      echo Return status: $?
      error_exit "Error during simulation"
  fi
  #file name to store md5sum output from restart read
  sumname=read_${nprocs}.md5

  echo 'Storing restart read md5sum to '$sumname
  md5sum ${restart_Readfolder}/*.lsb > ${sumname}
  #mv fort.66 read_${nprocs}.out

  # Delete folders
  #rm -rf ${restart_Readfolder}
  #rm -rf ${restart_folder}
  if [ $counter -eq 1 ]; then
    echo 'setting restart read reference MD5sum'
    firstreadsum=$sumname
  fi
done

echo 'testing the difference between the restart write from one proc with more proc'
counter=0
for nprocs in $procs;
do
  counter=$((counter+1))
  string="${firstwritesum} and write_${nprocs}.md5"
  
  tail -1 write_${nprocs}.md5 | awk '{print $1}' > lastLine 

  if [ $counter -eq 1 ]; then
    echo 'restart write from one proc is set as a reference md5sum:' ${firstwritesum}
  else
    echo  "Now testing difference in the last line between $string (WRITE 1Proc vs. WRITE ${nprocs}) :"
    difference=`diff ref_lastLine lastLine`
    if [ "X$difference" = "X" ]; then
      echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
    else
      echo "$(tput setaf 1)Error$(tput sgr0): Difference found between ${nprocs} and 1 proc:"
           # md5sum error
           error_flag=99
      echo ${difference}
    fi
  fi
done
echo
echo
echo 'testing the difference between the restart write from one proc with restart read-write with one and more proc'
counter=0
for nprocs in $procs;
do
  counter=$((counter+1))

  string="${firstwritesum} and read_${nprocs}.md5"

  tail -1 read_${nprocs}.md5 | awk '{print $1}' > lastLine 
#  if [ $counter -eq 1 ]; then
#    echo 'reference md5sum'
#  else
  echo  "Now testing difference in the last line between ${string} (READ {$nprocs} vs. WRITE 1proc) :"
  difference=`diff ref_lastLine lastLine`
  if [ "X$difference" = "X" ]; then
    echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
  else
    echo "$(tput setaf 1)Error$(tput sgr0): Difference found:"
    error_flag=99
    echo ${difference}
  fi
#  fi
done
echo 
echo 
echo "Done. "



function error_exit
{
	echo "$1" 1>&2
	exit 1
}




if [ $error_flag -eq 99 ] ; then
  error_exit "md5sum error"
fi

rm ref_lastLine lastLine
