----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                              
--------------------------------------------------------------------!!!   


comment = 'cube refined'
folder = 'mesh/'
if os.getenv('refine') == nil  then
  refinement = 1
else
  refinement = tonumber(os.getenv('refine'))
end
-- print ('Refinement '..refinement)
level = 3
minlevel = level

usePeriodic = false
walls = false
if os.getenv('simcase') == 'periodic' then
  usePeriodic = true
  print 'PERIODIC'
end
ebug = {debugMode = true}
length = 2.*math.pi
dx= length/2^level
dxDash = dx*0.01
shift = dx-dxDash
origin = {-length*0.5, -length*0.5, -length*0.5 }
size = {length, length, length }
bounding_cube = {origin = origin, 
               length = size[1]}
-- refinebox: three entries: origin, length and refinementlevel
box2 = { 
                 origin = {origin[1]+1.54*dx, origin[2]+dx, origin[3]},
                   vec = {
                     {length/2.-dx-dxDash, 0., 0. },
                     {0., length/1.-dxDash, 0. },
                     {0., 0., length/1.-dxDash }}
               }

box1 = { 
                 origin = origin, 
                   vec = {
                     {length/2.-dx-dxDash, 0., 0. },
                     {0., length/4.-dxDash, 0. },
                     {0., 0., length/4.-dxDash }}
               }
if usePeriodic then
  box = box2
else
  box = box1
end

spatial_object = {
  {
    -- Defining a domain boundary
    attribute = { kind = 'refinement', 
                  label = 'refine', 
                  level = minlevel + refinement
    },
    geometry = { -- Example for a sphere definition
      kind = 'canoND',
      object = box
    }},
    {
    -- Defining a seed to identify the part of the computational domain in
    -- the universe cube.
    attribute = { kind = 'seed' },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = { origin = {origin[1]+length*0.5, origin[2]+length*0.5, origin[3]+2.5*dx} }
               }
  }
}
if walls then
table.insert( spatial_object, 
  { -- Channel Walls
    attribute = { kind = 'boundary',
                  label = 'walls', 
                },
    geometry =  {
      kind = 'canoND',
      object = {
      {  -- x-
         origin = {origin[1]+shift, origin[2], origin[3]},
         vec = {{ 0., length,0.0},
              {0.0,0., size[3]}}
      },
      {  -- x+
         origin = {origin[1]+size[1]-shift, origin[2], origin[3]},
         vec = {{ 0., length,0.0},
              {0.0,0., size[3]}}
      },
      {  -- y-
         origin = {origin[1], origin[2]+shift, origin[3]},
         vec = {{ length,0.,0.0},
              {0.0,0., size[3]}}
      },
      {  -- y+
         origin = {origin[1], origin[2]+size[2]-shift, origin[3]},
         vec = {{ length,0.,0.0},
              {0.0,0., size[3]}}
      },
      {  -- z-
         origin = {origin[1], origin[2], origin[3]+shift},
         vec = {{ length,0.,0.0},
              {0.0,size[2],0. }}
      },
      {  -- z+
         origin = {origin[1], origin[2], origin[3]+size[3]-shift},
         vec = {{ length,0.,0.0},
              {0.0, size[2],0.}}
      },
    }
  }})

end

if usePeriodic == true then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { origin[1], origin[2], origin[3]+4.*dx-shift},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { origin[1], origin[2], origin[3]+dx+ shift},
          vec = { { 0., length, 0.0, 0.0},
                  { length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  })
end
