require "common"
simulation_name = 'nonNewtonian'

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax/10 }
  },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = false
  }
}   -- sim_control

logging = {
  level = 10,
  --filename = simulation_name..'.log',
  root_only = false,
  real_form = 'EN5.3',
  int_form = 'I6',
} -- logging

estart = {
  --read = 'restart/nonNewtonian_header_51.398E+03.lua',
  write = 'restart/',
  time_control = {
    min = { iter = tmax },
    max = { iter = tmax },
    interval = { iter = 1 },
  },
}

ebug = { 
  debugMode = true,  -- activate global debug modus
  debugFiles = true, -- open the debugFiles for each process dbgOut0000**.out
  --dumpDependencies = true, -- write the dependencies between levels to disk
  dumpAuxLists = true,
  logging = {
    level = 11, 
    filename = 'dbg', 
    root_only = false 
  },
}

physics = {
  dt = dt,
  rho0 = densityPhy,
} -- physics table

scheme = {
  identify = {
    label = 'level_'..level,
    kind = 'lbm_nNwtn',
    relaxation = 'bgk_pl',
    layout = 'd3q19',
  }, -- identify table

  -- add variables for analytical solutions
  variable = {
    { name='velPL', 
      ncomponents=1, 
      vartype = 'st_fun',
      st_fun = velPL },
    { name='strainPL', 
      ncomponents=1, 
      vartype = 'st_fun',
      st_fun = strainPL },
    { name='wssPL', 
      ncomponents=1, 
      vartype = 'st_fun',
      st_fun = wssPL },
     { name = 'diff_vel', 
       ncomponents = 1,
       vartype = 'operation',
       operation = {
         kind = 'difference',
         input_varname = {'velMag_phy','velPL'}, 
       }
     },
  },

  racking = {
    {
      label = 'global',
      variable = {
        'pdf','omegas','strainRate'
      },
      shape = { kind = 'global', },
      time_control = { 
        min = { iter = 0 }, 
        max = { iter = tmax },
        interval = { iter = 1 }, },
      folder = './tracking/',
      format = 'harvester',
    },
  },
  tracking = {
    { -- spatial profile
      label = 'spatial',
      variable = {
        'velMag_phy','velPL', 'diff_vel',
        'strainRate_phy','strainPL',
        'wss_phy','wssPL',
      },
      shape = {
        kind = 'canoND',
        object = {
          origin = { 0.0, -height/2, dx/2},
          vec = { 0.0, height, 0.0},
          segments = {200},
        }
      }, -- shape
      time_control = {
        min = { iter = tmax },
        max = { iter = tmax },
        interval = { iter = 1},
      },
      folder = './tracking/',
      format = 'asciiSpatial',
    },
    { -- velocity L2 norm
      label = 'vel_l2norm',
      variable = {
        'diff_vel', 'velPL',
      },
      shape = {
        kind = 'canoND',
        object = {
          origin = { 0.0, -height/2, dx/2},
          vec = { 0.0, height, 0.0},
          segments = {100} 
        }
      },
      time_control = {
        min = { iter = tmax },
        max = { iter = tmax },
        interval = { iter = 1 },
      },
      reduction = {'l2norm', 'l2norm'},
      folder = './tracking/',
      format = 'asciiSpatial',
    },
  }, -- tracking

  fluid = {
    omega = omega,
    rho0 = densityPhy,
    -- nonNewtonian table
    nonNewtonian = {
      model = 'power_law',
      n = n_PL,
      k = viscPhy,
    },
  }, -- fluid table


  initial_condition = {
    pressure = p0Phy,
    velocityX = velA, velocityY = 0.0, velocityZ = 0.0,
    Sxx = 0, Syy = 0, Szz = 0, Sxy = strainInit, Syz = 0, Sxz = 0,
  },

  boundary_condition = {
    { label = 'outlet',kind = 'outlet_expol', pressure = p0Phy, }, -- outlet
    --{ label = 'inlet', kind = 'outlet_expol', pressure = p0Phy+dp, }, -- inlet
    { label = 'top_wall', kind = 'wall'},
    { label = 'bottom_wall', kind = 'wall'},
    {
      label = 'inlet',
      kind = 'inlet_ubb',
      velocityX = {
        predefined = 'combined',
        temporal= {
          predefined = 'smooth',
          min_factor = velMaxPhy,
          max_factor = velMaxPhy,
          from_time  = 0,
          to_time    = tmaxPhy/4,
        },
        spatial = {
          predefined = 'parabol',
          shape = {
            kind = 'canoND',
            object = {
              origin = { -length/2+dx, -R, dx/2},
              vec = { 0.0, 2*R, 0.0 }
            }
          } -- shape table
        } -- spatial table
      }, -- velX table
      velocityY = 0.0,
      velocityZ = 0.0,
    } -- inlet table
  } -- boundary table
} -- scheme table
