#!/bin/bash
# Evaluate the current test case

echo ---------------------------------------
echo Evaluating the Plain Channel nonNewtonian Power Law Test case.
echo Author: Jiaixng Qi
echo Have fun!
echo ---------------------------------------

# check necessary environment variables
#if [ -z "$level" ]; then
#  echo "Please input mesh refine level ( from 6 to 10 ):"
#  read level_input
#  export level=$level_input
#fi
#if [ -z "$Re" ]; then
#  echo "Please input Reynolds number:"
#  read Re_input
#  export Re=$Re_input
#fi
if [ -z "$email" ]; then
  echo "Please input your email address:"
  read email_input
  export email=$email_input
fi

# create folders and delete old results files
echo "Create directory mesh and tracking"
mkdir mesh
mkdir tracking
mkdir pictures
rm tracking/*.lua
rm tracking/*.res
rm mesh/*
rm pictures/*
rm runSeeder.log.txt
rm runMUSUBI.log.txt

export vel_l2norm='tracking/vel_l2norm.txt'
rm $vel_l2norm

levelrange='6 7 8 9'

for LEVEL in $levelrange;do
  export level=$LEVEL
  $seeder
  mpirun -n 4 $musubi
  lua param.lua
  echo "level $level"
  tail -n 1 tracking/*${level}*l2norm*.res
  tail -n 1 tracking/*${level}*l2norm*.res >> $vel_l2norm
done

cat $vel_l2norm
paste vel_l2norm_level.txt $vel_l2norm > vel_l2norm.txt
gnuplot plot_conv.gpl
python2.7 send_email.py
echo -----Testcase nonNewtonian Fluid Plain Channel finished!------

