require 'params'
require 'track'
-------------------------------------------------------------------------------
mesh               = './mesh/'  
io_buffer_size     = 16
-------------------------------------------------------------------------------
interval           = 100
sim_control        = { 
  time_control     = { 
    min      = { iter = 0        },
    max      = { iter = tmax     },
    interval = { iter = interval } 
  }
}
-------------------------------------------------------------------------------
function injection(x, y, z, t)
  if t > 1000 and  t <= tmax then
    return 1.0
  else
    return 0.0
  end 
end
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--physics   = { dt    = dt,    rho0 = rho_phy }
diff_coeff = 1.0
-------------------------------------------------------------------------------
scheme    = {
  {
    fluid     = { omega = omega, rho0 = rho_phy },
    identify  = { 
      label      = 'fluid',
      kind       = 'lbm',
      relaxation = 'mrt',
      layout     = 'd3q19'
    },

    initial_condition = { 
      pressure  = press_phy, 
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0 
    }, 
    boundary_condition = {  
      { label = 'vessel', kind = 'wall'}, 
      { label = 'inlet',
        kind  = 'inlet_ubb',
        velocityX = uc,
        velocityY = 0.0,
        velocityZ = 0.0,
      },
      { label     = 'outlet', 
        kind      = 'outlet_expol',
        pressure  = press_phy, 
      },
    }
  },
  --second scheme
  {
    identify  = {label = 'species', kind = 'passive_scalar', 
                 relaxation='bgk', layout='flekkoy' },
    depend    = { variable={'velocity', 3 }, usescheme='fluid'},
    source    = {
      { name      = 'injection', ncomponents = 1, 
        injection = {
          shape = {kind = 'all' },
          kind  = 'lua_fun', 
          fun   = injection 
        }
      }
    },
    tracking  = { 
      { label     = 'spc1',
        variable  = {'spc1_density'},
        shape     = {kind   = 'all'},
        folder    = 'tracking/',
        output    = {format = 'harvester'},  
        time_control     = { 
          min = { iter = tmax }, max = { iter = tmax }, interval = { iter = tmax } }
      }
    },
    field     = { label   = 'spc1',
                  species = {diff_coeff = {diff_coeff} },
                  initial_condition = { pressure  = press_phy,
                                        velocityX = 0.5,
                                        velocityY = 0.0,
                                        velocityZ = 0.0 
                                      },
                  boundary_condition = { { label = 'vessel', kind = 'wall'},
                                         { label = 'inlet',
                                           kind  = 'flekkoy_inlet'},
                                         { label = 'outlet',
                                           kind  = 'flekkoy_outlet' }
                                       }
      }
  }
}

-------------------------------------------------------------------------------
start    = math.ceil(period_iter + period_iter/12.0)
restart = {
  write = 'restart/',
  time_control = { 
    min      = { iter = tmax }, 
    max      = { iter = tmax }, 
    interval = { iter = tmax } 
  },
}
