-- Musubi configuration file. 
-- This is a LUA script.

----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository

--------------------------------------------------------------------!!!

folderRead = 'restart_read/'
folderWrite = 'restart/'

-- Local refinement settings
interpolation_method = 'copyFirst'
                     
logging = {level = 6}
ebug = {debugMode = false, debugFiles = true}
comm_reduced = true

-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information
-- Time step settigs
tmax           = 10
sim_control = { 
  time_control = { max = {iter=tmax}, interval = {iter=tmax} } 
}

io_buffer_size = 1

rho0 = 1
cs2 = 1./3.
originX =  -1.3
originY =  0.8
originZ =  0.1
halfwidth = 0.50
amplitude = 0.01
background = rho0*cs2

function ic_1Dgauss_pulse(x, y, z ,t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end
scheme = {
{
-- Initial condition 
initial_condition = { pressure  = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 },

fluid = { omega = 1.8, rho0 = 1.0 },
  identify = {
      label = 'debug_restart',
      kind = 'lbm', 
      layout = 'd3q19'
},


-- Boundary conditions
boundary_condition = {  
--{ label = 'east',
--  kind = 'wall', density = 1.0, order = 2 }
--  kind = 'outlet_nrbc', density = 1.0, sigma = 0.1, kappa = 1.2, L = 100. }
--{ label = 'right',
--   kind = 'outlet_extrapolation', density = 1.0, order = 3 }
--,{ label = 'west',
--   kind = 'wall', velocityX = 0.0001, velocityY = 0.0, velocityZ = 0.0, density = 1.0 }
--,{ label = 'north',
--   kind = 'wall', density = 1.0 }
--,{ label = 'south',
--   kind = 'wall', density = 1.0 }
--,
{ label = 'wall',
   kind = 'wall' }
},

} -- close the scheme
} -- close the scheme table

-- Read or write?
if os.getenv('mode') == 'read' then
  print ('   READ MODE ')
restart = { read = folderWrite..'gaussian_header_1.000E+00.lua',
            write = folderRead,
            time_control = {  min = {iter = 1}, max = {iter = tmax}, interval={iter=tmax-1} }}
elseif os.getenv('mode') == 'write' then
  print ('   WRITE MODE ')
restart = { 
            write = folderWrite,
            time_control = {  min = {iter = 1}, max = {iter = tmax}, interval={iter=tmax-1} }}
end

