! See copyright notice in the COPYRIGHT file.
! This utest program tests the compact quadratic velocity interpolation 2D
program mus_intp_compact3D_test
  use env_module,         only: rk, eps
  use tem_general_module, only: tem_start, tem_finalize, tem_general_type

  use mus_interpolate_d3q27_module, only: get_polynomial_3D

  implicit none

  logical :: error
  real(kind=rk) :: tolerance

  type( tem_general_type ) :: general
  integer :: iVal
  real(kind=rk) :: u(3,4), s(6,4)

  call tem_start( 'Compact Intp 3D test', 'utest', general )
  error = .false.
  tolerance = eps * 2500._rk
  write(*,*) 'tolerance = ', tolerance

  !-----------------------------------------------------------------------------
  ! Test: u = 0, s = 0
  u = 0.0_rk
  s = 0.0_rk
  call test_poly( u, s )
  !-----------------------------------------------------------------------------

  !-----------------------------------------------------------------------------
  ! Test: u = 1, s = 0
  u = 1.0_rk
  s = 0.0_rk
  call test_poly( u, s )
  !-----------------------------------------------------------------------------

  !-----------------------------------------------------------------------------
  ! Test: u = -2, s = 0
  u = -2.0_rk
  s = 0.0_rk
  call test_poly( u, s )
  !-----------------------------------------------------------------------------

  !-----------------------------------------------------------------------------
  ! Test: u = -2, s = 0
  u = -2.0_rk
  s(1,:) =  [ 1.0, 2.0, 3.0, 4.0 ]
  s(2,:) =  [ 1.0, 2.0, 3.0, 4.0 ]
  s(3,:) =  [ 1.0, 2.0, 3.0, 4.0 ]
  call test_poly( u, s )
  !-----------------------------------------------------------------------------

  call tem_finalize(general)
  write(*,'(A)') 'PASSED'

contains

  !-----------------------------------------------------------------------------
  subroutine test_poly( u, s )
    real(kind=rk) :: u(3,4), s(6,4)
    real(kind=rk) :: a(10), b(10), c(10)

    write(*,"(3A10)") 'Ux', 'Uy', 'Uz'
    do iVal = 1, 4
      write(*,"(3F10.5)") u(1:3,iVal)
    end do
    write(*,"(6A10)") 'Sxx', 'Syy', 'Szz', 'Sxy', 'Syz', 'Sxz'
    do iVal = 1, 4
      write(*,"(6F10.5)") s(1:6,iVal)
    end do
    call get_polynomial_3D( u, s, a, b, c )
    write(*,"(A,10A6)")   '   ', '0', 'x', 'y', 'z', 'xx', 'yy', 'zz', 'xy', 'yz', 'xz'
    write(*,"(A,10F6.2)") 'a: ', a
    write(*,"(A,10F6.2)") 'b: ', b
    write(*,"(A,10F6.2)") 'c: ', c
    write(*,"(A)") ''

  end subroutine test_poly
  !-----------------------------------------------------------------------------

end program mus_intp_compact3D_test
!******************************************************************************
