title: Tutorials
copy_subdir: images

## Tutorials ## {#howto}

The tutorials show you how to install, configure and set up *Musubi*.
You are guided through all required steps from generating meshes, configuring
the solver and post-processing the results.
You can choose a special topic or you can go through the tutorials step by step.

If not stated otherwise, we use the generic channel case for the tutorials. The
test case can be found under
`examples/tutorials/tutorial_cases/tutorial_channelGeneric`.


## Overview ## {#tut_overview}

- [Tutorial 00 - Prerequisites](tut_00_prerequisites.html)
    What do you need before you can start using *Musubi*?

- [Tutorial 01 - Configuration](tut_01_mus_config.html)
    Basic configuration of *Musubi* simulations.

- [Tutorial 02 - Toolchain](tut_02_mus_toolchain.html)
    Using the complete APES simulation tool-chain. Generation of meshes, running the solver and post-processing the results.

- [Tutorial 03 - Tracking](tut_03_tracking.html)
    Tracking flow quantities during the simulation.

- [Tutorial 04 - Boundary Conditions](tut_04_boundaries.html)
    Setting boundary conditions.

- [Tutorial 05 - Restart](tut_05_restart.html)
    Restarting simulations.

- [Tutorial 06 - Initial Conditions](tut_06_initial.html)
    Setting initial conditions.

- [Tutorial 07 - Abort Criteria](tut_07_convergence.html)
    Conditions for convergence and stopping the code in general.

- [Tutorial 08 - Source terms](tut_08_source.html)
    Using source terms in *Musubi*.

- [Tutorial 09 - Multi-Level Simulations](tut_09_mus_multilevel.html)
    Using multi-level simulations.

- [Tutorial 10 - Changes in *Musubi2.0*](tut_10_Musubi2.html)
    Changes that need to be done when upgrading from *Musubi1.0* to *Musubi2.0*.

## Required Knowledge ## {#requ_know}

We assume that you know how to install programs on your computer
and how to use a console.
Also, we assume that you have some basic idea of the Lattice Boltzmann
 Method (see [here](http://www.scholarpedia.org/article/Lattice_Boltzmann_Method)
or [here](http://en.wikipedia.org/wiki/Lattice_Boltzmann_methods)
for a brief description of it).
