! Copyright (c) 2015 Jiaxing Qi <jiaxing.qi@uni-siegen.de>
! Copyright (c) 2016 Tobias Schneider <tobias1.schneider@student.uni-siegen.de>
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!
! 1. Redistributions of source code must retain the above copyright notice,
! this list of conditions and the following disclaimer.
!
! 2. Redistributions in binary form must reproduce the above copyright notice,
! this list of conditions and the following disclaimer in the documentation
! and/or other materials provided with the distribution.
!
! THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY OF SIEGEN “AS IS” AND ANY EXPRESS
! OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
! OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
! IN NO EVENT SHALL UNIVERSITY OF SIEGEN OR CONTRIBUTORS BE LIABLE FOR ANY
! DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
! (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
! LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
! ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
! (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
! SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
?? text :: var27( f )
  real(kind=rk) :: ?f?000
  real(kind=rk) :: ?f?N00
  real(kind=rk) :: ?f?0N0
  real(kind=rk) :: ?f?00N
  real(kind=rk) :: ?f?100
  real(kind=rk) :: ?f?010
  real(kind=rk) :: ?f?001
  real(kind=rk) :: ?f?0NN
  real(kind=rk) :: ?f?0N1
  real(kind=rk) :: ?f?01N
  real(kind=rk) :: ?f?011
  real(kind=rk) :: ?f?N0N
  real(kind=rk) :: ?f?10N
  real(kind=rk) :: ?f?N01
  real(kind=rk) :: ?f?101
  real(kind=rk) :: ?f?NN0
  real(kind=rk) :: ?f?N10
  real(kind=rk) :: ?f?1N0
  real(kind=rk) :: ?f?110
  real(kind=rk) :: ?f?NNN
  real(kind=rk) :: ?f?NN1
  real(kind=rk) :: ?f?N1N
  real(kind=rk) :: ?f?N11
  real(kind=rk) :: ?f?1NN
  real(kind=rk) :: ?f?1N1
  real(kind=rk) :: ?f?11N
  real(kind=rk) :: ?f?111
?? end text var27
??!
?? text :: q27
  integer,parameter :: qN00 = 1
  integer,parameter :: q0N0 = 2
  integer,parameter :: q00N = 3
  integer,parameter :: q100 = 4
  integer,parameter :: q010 = 5
  integer,parameter :: q001 = 6
  integer,parameter :: q0NN = 7
  integer,parameter :: q0N1 = 8
  integer,parameter :: q01N = 9
  integer,parameter :: q011 = 10
  integer,parameter :: qN0N = 11
  integer,parameter :: q10N = 12
  integer,parameter :: qN01 = 13
  integer,parameter :: q101 = 14
  integer,parameter :: qNN0 = 15
  integer,parameter :: qN10 = 16
  integer,parameter :: q1N0 = 17
  integer,parameter :: q110 = 18
  integer,parameter :: qNNN = 19
  integer,parameter :: qNN1 = 20
  integer,parameter :: qN1N = 21
  integer,parameter :: qN11 = 22
  integer,parameter :: q1NN = 23
  integer,parameter :: q1N1 = 24
  integer,parameter :: q11N = 25
  integer,parameter :: q111 = 26
  integer,parameter :: q000 = 27
?? end text q27
??!
?? text :: vel_d3q27( u_x, u_y, u_z, f, inv_rho )
    ?u_x? =   ?f?(18) + ?f?(17) + ?f?( 4) &
      &     + ?f?(14) + ?f?(12)           &
      &     + ?f?(23) + ?f?(24)           &
      &     + ?f?(25) + ?f?(26)           &
      &     - ?f?(16) - ?f?( 1) - ?f?(15) &
      &     - ?f?(13) - ?f?(11)              &
      &     - ?f?(19) - ?f?(20)             &
      &     - ?f?(21) - ?f?(22)   

    ?u_y? =   ?f?(18) + ?f?( 5) + ?f?(16) &
      &     + ?f?(10) + ?f?( 9)           &
      &     + ?f?(21) + ?f?(22)           &
      &     + ?f?(25) + ?f?(26)           &
      &     - ?f?(15) - ?f?( 2) - ?f?(17) &
      &     - ?f?( 8) - ?f?( 7)               &
      &     - ?f?(19) - ?f?(20)             &
      &     - ?f?(23) - ?f?(24)           

    ?u_z? =   ?f?( 6) + ?f?(14) + ?f?(10) &
      &     + ?f?(13) + ?f?( 8)           &
      &     + ?f?(20) + ?f?(22)           &
      &     + ?f?(24) + ?f?(26)           &
      &     - ?f?( 3) - ?f?(12) - ?f?( 9) &
      &     - ?f?(11) - ?f?( 7)               &
      &     - ?f?(19) - ?f?(21)             &
      &     - ?f?(23) - ?f?(25)

    ?u_x? = ?u_x? * ?inv_rho?
    ?u_y? = ?u_y? * ?inv_rho?
    ?u_z? = ?u_z? * ?inv_rho?
?? end text vel_d3q27
??!
?? text :: rho_d3q27( rho, f )
    ?rho? = ?f?(1)  + ?f?(2)  + ?f?(3)  + ?f?(4)  + ?f?(5)     &
      &   + ?f?(6)  + ?f?(7)  + ?f?(8)  + ?f?(9)  + ?f?(10)      &
      &   + ?f?(11) + ?f?(12) + ?f?(13) + ?f?(14) + ?f?(15)  &
      &   + ?f?(16) + ?f?(17) + ?f?(18) + ?f?(19) + ?f?(20)  &
      &   + ?f?(21) + ?f?(22) + ?f?(23) + ?f?(24) + ?f?(25)  &
      &   + ?f?(26) + ?f?(27)
?? end text rho_d3q27
??!
