.intel_syntax noprefix
.code32
.section .multiboot

#define MULTIBOOT_HEADER_MAGIC 0x1BADB002
#define MULTIBOOT_HEADER_FLAG_ALIGN_MODULES_4KB 1
#define MULTIBOOT_HEADER_FLAG_GET_MEMORY_INFO (1<<1)
#define MULTIBOOT_HEADER_FLAG_AOUT_KLUDGE (1<<16)
#define MULTIBOOT_HEADER_FLAGS (MULTIBOOT_HEADER_FLAG_ALIGN_MODULES_4KB|MULTIBOOT_HEADER_FLAG_GET_MEMORY_INFO|MULTIBOOT_HEADER_FLAG_AOUT_KLUDGE)

multibootHeader:
	.long MULTIBOOT_HEADER_MAGIC
	.long MULTIBOOT_HEADER_FLAGS
	.long -(MULTIBOOT_HEADER_MAGIC+MULTIBOOT_HEADER_FLAGS)
	//.textの開始位置
	.long textBegin
	//multiboot ヘッダーの開始位置
	.long multibootHeader
	//データセグメントの最後
	.long loadEnd
	//BSSの終わり
	.long bssEnd
	//エントリポイント
	.long entry

.text

entry:
	//ページマップレベル4エントリを生成
	mov eax,offset _kernelPDPTR
	or eax,0b11
	mov [_kernelPML4],eax

	//ページディレクトリポインタエントリを生成
	mov eax,offset _kernelPD
	or eax,0b11
	mov [_kernelPDPTR],eax

	//ページディレクトリを生成
	//先頭1GBをストレートマッピング
	mov edi,offset _kernelPD
	mov ebx,0b10000011
	mov ecx,4096>>3
	cld
writePageDirectoryEntry:
	mov eax,ebx
	stosd
	xor eax,eax
	stosd
	add ebx,2*1024*1024

	loop writePageDirectoryEntry

	//PAE,PGEを有効にする
	or eax,0b10100000
	mov cr4,eax

	//PML4を設定
	mov edx,offset _kernelPML4
	mov cr3,edx

	//longモードを有効にする
	mov ecx,0xC0000080
	rdmsr
	or eax,1<<8
	wrmsr

	//ページングを有効化
	mov eax,cr0
	or eax,1<<31
	mov cr0,eax

	//64bitモードに入る
	lgdt gdtr
	jmp 0x0008:entry64

.code64
entry64:
	mov ax,0x0010
	mov ds,ax
	mov es,ax
	mov fs,ax
	mov gs,ax

	call init

	hlt

.data
//GDT
gdt:
	//null descriptor
	.quad 0
	//long mode, present, DPL=0なcode segment descriptor
	.quad 0b0000000000100000100110000000000000000000000000000000000000000000
	//present なdata segment descriptor
	.quad 0b0000000000000000100100000000000000000000000000000000000000000000
gdt_end:

gdtr:
	.word gdt_end - gdt -1
	.quad gdt


