/****************************************************************************
    BSch3V and Utility common file.
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfNX̎
****************************************************************************/
#include <stdio.h>
//#include <qnamespace.h>
#include "xbschobj.h"


//RXgN^
SXBSchObj::SXBSchObj()
{
	m_PlaceNum = 0;					//zuԍ̏
	m_pRefObj = NULL;	//QƃIuWFNgւ̃|C^
	m_Layer = 0;					//zuC[
	m_Selection = NOT_SELECTED;		//I
	m_p1.setX(-1);
	m_p1.setY(-1);
}

//ʒu𓮂
void SXBSchObj::move(int offsetx,int offsety)
{
	SPoint p(offsetx,offsety);
	switch(m_Selection & SELECT_ALL){
	case NOT_SELECTED:
	case SELECT_ALL:
		m_p1 += p;
		m_p2 += p;
		break;
	case SELECT_P1:
		m_p1 += p;
		break;
	case SELECT_P2:
		m_p2 += p;
		break;
	}
}	
	
//XWw肵čE]s
void SXBSchObj::mirrorH(int x)
{
	m_p1.setX(x*2 -m_p1.x());
	m_p2.setX(x*2 -m_p2.x());
}

//E]s
void SXBSchObj::mirrorH()
{
	int x= (m_p1.x() + m_p2.x())/2;
	mirrorH(x);
}
	
//XYSWw肵āA]s
void SXBSchObj::rotate(const SPoint& p)
{
	int newX,newY;
	newY = p.y() + (m_p1.x() - p.x()) ;
	newX = p.x() - (m_p1.y() - p.y()) ;
	m_p1.setY( newY );
	m_p1.setX( newX );

	newY = p.y() + (m_p2.x() - p.x()) ;
	newX = p.x() - (m_p2.y() - p.y()) ;
	m_p2.setY( newY );
	m_p2.setX( newX );
}

//]s
void SXBSchObj::rotate()
{
	SPoint p;
	p.setX((m_p1.x()+m_p2.x())/2);
	p.setY((m_p1.y()+m_p2.y())/2);
	rotate(p);
}

//ItOZbg
void  SXBSchObj::setSelection(unsigned sel)
{
	m_Selection = sel;
}

//ItOZbg
void  SXBSchObj::resetSelection()
{
	m_Selection = 0;
}



//prcArea̓OR[hԂ
unsigned SXBSchObj::SetOutCode(const SPoint& p,const SRect& rcArea)
{
	unsigned outcode=0;											//  UL  | U | UR
	if		(p.x() < rcArea.l() )	outcode |= OUTCODE_LEFT;	//  ----+---+----
	else if (p.x() > rcArea.r() )	outcode |= OUTCODE_RIGHT;	//   L  | 0 |  R
	if		(p.y() < rcArea.t() )	outcode |= OUTCODE_UPPER;	//  ----+---+----
	else if	(p.y() > rcArea.b() )	outcode |= OUTCODE_LOWER;	//  LL  | L | LR
	return outcode;
}

//_Ƌ`̏dȂAdݏtŕԂ
int SXBSchObj::PointAndRectMag(const SPoint& p,const SRect& rcArea)
{
	int lp,rp,tp,bp,xp,yp;								//   left						  right
	if(( lp = p.x() - rcArea.l()  )<=0) return 0;	// ---+----------P------------------+----
	if(( rp = rcArea.r() - p.x() )<=0) return 0;	//         lp              rp
	if(( tp = p.y() - rcArea.t()   )<=0) return 0;
	if(( bp = rcArea.b()- p.y() )<=0) return 0;

	if(lp<rp) xp=lp; else xp=rp;						//̐luGbW痣ĂlvƂĎg
	if(tp<bp) yp=tp; else yp=bp;
	xp=(xp*16)/(lp+rp);				//ől͂W
	yp=(yp*16)/(tp+bp);				//ől͂W
	return (xp*yp)+1;				//ől͂UT
}

