/****************************************************************************
    NL3W netlist utility for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "stdafx.h"
#include "nlist.h"
#include "nlistDlg.h"
#include "netlist.h"
#include ".\nlistdlg.h"
#include "SetAddIn.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎgĂ CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard ͉z֐̃I[o[Ch𐶐܂
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// bZ[W nh܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNlistDlg _CAO

CNlistDlg::CNlistDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNlistDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNlistDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_noMessageBox=FALSE;
}

void CNlistDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNlistDlg)
	DDX_Control(pDX, IDC_LIST_SRC, m_listsrc);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNlistDlg, CDialog)
	//{{AFX_MSG_MAP(CNlistDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_REFSRC, OnRefsrc)
	ON_BN_CLICKED(IDC_CLR, OnClr)
	ON_LBN_SELCHANGE(IDC_LIST_SRC, OnSelchangeListSrc)
	ON_BN_CLICKED(IDC_REFDST, OnRefdst)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_REFRPT, OnBnClickedRefrpt)
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BUTTON_SETADDIN, &CNlistDlg::OnBnClickedButtonSetaddin)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNlistDlg bZ[W nh

BOOL CNlistDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[ڂVXe j[֒ǉ܂B

	// IDM_ABOUTBOX ̓R}h j[͈̔͂łȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	HICON hIcon=AfxGetApp()->LoadIcon(IDI_SMALL);
	SetIcon(hIcon, FALSE);		// ACRݒ
//	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	CSrcLB* pLB=(CSrcLB*)GetDlgItem(IDC_LIST_SRC);
	const CStringList& strListSrcFiles=((CNlistApp*)AfxGetApp())->m_cmdInfo.m_strListSrcFiles;
	POSITION pos = strListSrcFiles.GetHeadPosition();
	while(pos){
		CString fileName = strListSrcFiles.GetNext(pos);
		pLB->AddString(fileName);
	}
	SetDstFileName();
	CString name;

	name= ((CNlistApp*)AfxGetApp())->m_cmdInfo.m_strNetList;
	if(!name.IsEmpty()){
		SetDlgItemText(IDC_EDIT_DST,name);
	}

	name= ((CNlistApp*)AfxGetApp())->m_cmdInfo.m_strReportFile;
	if(!name.IsEmpty()){
		SetDlgItemText(IDC_EDIT_RPT,name);
	}




	int listType = ((CNlistApp*)AfxGetApp())->m_cmdInfo.m_listType;
	if(listType == 0){
		listType = AfxGetApp()->GetProfileInt("OPTION","ListFormat",1);
	}

	//AhC̐ݒINIt@CǂݍŃCuݒ肷B
	g_addinFiles.update();


	SetListTypeComboBox(listType-1);
	//CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_NETTYPE);
	//pCombo->AddString("Telesis");
	//pCombo->AddString("Protel");
	

	//int listTypeCount = pCombo->GetCount();
	//int selIndex = listType-1;
	//if(selIndex<0)selIndex = 0;
	//else if(selIndex>=listTypeCount)selIndex=listTypeCount-1;

	//pCombo->SetCurSel(selIndex);
	

	//if(listType == 1){
	//	((CButton*)GetDlgItem(IDC_RADIO_TELESIS))->SetCheck(BST_CHECKED);
	//}else{
	//	((CButton*)GetDlgItem(IDC_RADIO_PROTEL))->SetCheck(BST_CHECKED);
	//}



	int check;
	int flag3sRemoveNOCONNECTION = ((CNlistApp*)AfxGetApp())->m_cmdInfo.m_flag3sRemoveNOCONNECTION;
	if(flag3sRemoveNOCONNECTION!=0){
		check = (flag3sRemoveNOCONNECTION>0 ? 1 : 0);
	}else{
		check = AfxGetApp()->GetProfileInt("OPTION","ExcludeNoConnectionPin",1);
	}
	CButton* pButton=(CButton*)GetDlgItem(IDC_CHECK_NC);
	pButton->SetCheck(check);
	
	if(((CNlistApp*)AfxGetApp())->m_cmdInfo.m_forceExecute){
		m_noMessageBox=TRUE;
		OnOK();
		////EndDialog(IDOK);
	}

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CNlistDlg::SetListTypeComboBox(int selIndex)
{
	CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_NETTYPE);

	if(selIndex<0){
		selIndex = pCombo->GetCurSel();
	}

	pCombo->ResetContent();
	pCombo->AddString("Telesis");
	pCombo->AddString("Protel");


	int addinCount = g_addinFiles.m_nAddinCount;
	for(int i=0;i<addinCount;i++){
		void( __stdcall *typeName)(char*,int);
		typeName = (void(__stdcall*)(char*,int)) ::GetProcAddress( g_addinFiles.m_hAddin[i],"typeName"); 
		char buff[64];
		typeName(buff,64);
		pCombo->AddString(buff);
	}

	int listTypeCount = pCombo->GetCount();
	if(selIndex<0)selIndex = 0;
	else if(selIndex>=listTypeCount)selIndex=listTypeCount-1;

	pCombo->SetCurSel(selIndex);
}


void CNlistDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CNlistDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CNlistDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CNlistDlg::OnRefsrc() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nResult;
	//char szFileNameBuffer[FILE_NAME_BUFFER_SIZE];
	strcpy(m_szFileNameBuffer,"*.CE3");

	CFileDialog dlg(TRUE,				//I[v_CAO
					NULL,				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT,
					"BSch3 data(*.ce3)|*.CE3||",	//tB^
					this);				//eEChE
	
	dlg.m_ofn.lpstrFile = m_szFileNameBuffer;	//t@Ci[obt@ݒ肷B
	dlg.m_ofn.nMaxFile = FILE_NAME_BUFFER_SIZE;		//t@Ci[obt@̃TCYݒ肷B
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){		//IȂc
		CSrcLB* pLB=(CSrcLB*)GetDlgItem(IDC_LIST_SRC);	//Xg{bNX擾āc
		//pLB->ResetContent();
		CString strPath;
		POSITION pos = dlg.GetStartPosition();
		while(pos){
			strPath = dlg.GetNextPathName(pos);				
			pLB->AddString(strPath);	//Xg{bNXւ̃Zbg
		}
		pLB->SetListboxWidth();
		SetDstFileName();
	}

}

void CNlistDlg::OnClr() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CSrcLB* pLB=(CSrcLB*)GetDlgItem(IDC_LIST_SRC);
	pLB->ResetContent();
	SetDstFileName();

}

void CNlistDlg::OnSelchangeListSrc() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	TRACE("CNlistDlg::OnSelchangeListSrc()\n");
	SetDstFileName();
}

void CNlistDlg::SetDstFileName()
{
//	CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_DST);
	CButton* pBtn=(CButton*)GetDlgItem(IDOK);
	CSrcLB* pLB=(CSrcLB*)GetDlgItem(IDC_LIST_SRC);
	int n = pLB->GetCount();
	if(n>0){
		CString strSrc;
		int index = pLB->GetCurSel();
		if(index == LB_ERR){
			index = 0;
		}
		pLB->GetText(index,strSrc);
		char szPath[_MAX_PATH];
		char szDrive[_MAX_DRIVE];
		char szDir[_MAX_DIR];
		char szName[_MAX_FNAME];
		_splitpath(strSrc,szDrive,szDir,szName,NULL);
		_makepath_s(szPath,_MAX_PATH,szDrive,szDir,szName,".net");
		SetDlgItemText(IDC_EDIT_DST,szPath);
		_makepath_s(szPath,_MAX_PATH,szDrive,szDir,szName,".rpt");
		SetDlgItemText(IDC_EDIT_RPT,szPath);
		//pEdit->SetWindowText(szPath);
		pBtn->EnableWindow(TRUE);
	}else{
		SetDlgItemText(IDC_EDIT_DST,"");
		SetDlgItemText(IDC_EDIT_RPT,"");
		//pEdit->SetWindowText("");
		pBtn->EnableWindow(FALSE);
	}
}
 
void CNlistDlg::OnRefdst() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nResult;
//	char szFileNameBuffer[_MAX_PATH];
//	strcpy(szFileNameBuffer,"*.CE3");

	CFileDialog dlg(FALSE,				//I[v_CAO
					NULL,				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST,
					"Netlist(*.net)|*.NET||",	//tB^
					this);				//eEChE
	
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){				//IȂc
		CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_DST);
		CString strPath = dlg.GetPathName();
		pEdit->SetWindowText(strPath);
	}	
}

void CNlistDlg::OnBnClickedRefrpt()
{
	int nResult;
	CFileDialog dlg(FALSE,				
					NULL,				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST,
					"Report(*.rpt)|*.RPT||",	//tB^
					this);				//eEChE
	
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){				//IȂc
		CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_RPT);
		CString strPath = dlg.GetPathName();
		pEdit->SetWindowText(strPath);
	}	
}

void CNlistDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	CButton* pButton=(CButton*)GetDlgItem(IDC_CHECK_NC);
	int nExcludeNC=pButton->GetCheck();
	
	AfxGetApp()->WriteProfileInt("OPTION","ExcludeNoConnectionPin",(nExcludeNC!=0 ? 1 : 0));


	CSrcLB* pLB=(CSrcLB*)GetDlgItem(IDC_LIST_SRC);
	int nCount = pLB->GetCount();
	if(nCount==0){
		return;
	}else{
		if(nCount>64)nCount=64;
	}

	
	const char* filelist[64];

	char* top = m_szFileNameBuffer;
	for(int n=0;n<nCount;n++){
		int charCount = pLB->GetText(n,top);
		if(charCount == LB_ERR || charCount == 0){
			nCount = n;
			break;
		}
		filelist[n]=top;
		top+=(charCount+1);
	}

	CString strDstNetPath;
	GetDlgItemText(IDC_EDIT_DST,strDstNetPath);
	//FILE* fp =fopen(strDstPath,"wt");
	//if(!fp){
	//	if(!m_noMessageBox)	AfxMessageBox(IDS_DSTOPENERR);
	//	return;
	//}

	CString strDstRptPath;
	GetDlgItemText(IDC_EDIT_RPT,strDstRptPath);
	FILE* fprpt =fopen(strDstRptPath,"wt");


	CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_COMBO_NETTYPE);
	int listFormat = pCombo->GetCurSel()+1;
	if(listFormat<1)listFormat=1;


	//int listFormat = ( ((CButton*)GetDlgItem(IDC_RADIO_TELESIS))->GetCheck()==BST_CHECKED ? 1 : 2);
	AfxGetApp()->WriteProfileInt("OPTION","ListFormat",listFormat);


	//lbgXg쐬B
	SNetlistOption option;
	option.pszDstPath = strDstNetPath;
	//option.fpDst=fp;
	option.fpRpt=fprpt;
	option.bPlistMode=false;
	option.listType=listFormat;
	option.bExcludeNC = (nExcludeNC!=0);

	int res = netlist(nCount,filelist,option);
	//fclose(fp);
	if(fprpt) fclose(fprpt);

	
	switch(res){
	case -1:
		if(!m_noMessageBox)	AfxMessageBox(IDS_DSTOPENERR);
		break;
	case -2:
		if(!m_noMessageBox)	AfxMessageBox(IDS_NO_NETINFO);
		break;
	case -3:
		if(!m_noMessageBox)	AfxMessageBox(IDS_SRCOPENERR);
		break;
	case -4:
		if(!m_noMessageBox)	AfxMessageBox(IDS_ADDIN_INDEX_ERROR);
		break;
	case 0:
		if(!m_noMessageBox)	AfxMessageBox(IDS_FINISHED);
		break;
	default:
		if(!m_noMessageBox){
			CString strMsg;
			strMsg.Format("Add-in error: %d",res);
			AfxMessageBox(strMsg);
		}		
	}

	//CDialog::OnOK();
}



void CNlistDlg::OnBnClickedCancel()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	OnCancel();
}

void CNlistDlg::OnBnClickedButtonSetaddin()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CSetAddIn dlg;
	if(dlg.DoModal() == IDOK){
		g_addinFiles.update();
		SetListTypeComboBox(-1);
	}
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CString msg;
	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	msg = "NL3W Version ";
	msg += strVersion;
	SetDlgItemText(IDC_STATIC_VERSION,msg);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}
