/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// MainFrm.cpp : CMainFrame NX̓̒`s܂B
//

#include "stdafx.h"
#include "BSch.h"

#include "MainFrm.h"
#include "Splash.h"
#include ".\mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define COPYDATA_CHECKOPENFILE 1







/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateViewStatusBar)
	ON_COMMAND(ID_VIEW_STATUS_BAR, OnViewStatusBar)
	ON_COMMAND(ID_VIEW_TOOLBAR, OnViewToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateViewToolbar)
	//}}AFX_MSG_MAP
	ON_WM_DESTROY()
	ON_WM_COPYDATA()
	ON_COMMAND(ID_VIEW_LAYERBOX, OnViewLayerbox)
	ON_UPDATE_COMMAND_UI(ID_VIEW_LAYERBOX, OnUpdateViewLayerbox)
	ON_WM_SIZE()
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // 0 Xe[^X C CWP[^
//	ID_INDICATOR_KANA,		// 폜
	ID_INDICATOR_CAPS,		// 1
	ID_INDICATOR_NUM,		// 2
//	ID_INDICATOR_SCRL,
    ID_SEPARATOR,			// 3   XŴ߂̒ǉ
    ID_SEPARATOR,			// 4   YŴ߂̒ǉ
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	// TODO: ̈ʒuɃȍR[hǉĂB
	m_extensionMenuCount=0;
}

CMainFrame::~CMainFrame()
{
}


struct EnumWindowsProcCheckOpenedParam{
	const char* pcszPathName;
	HWND hMyWnd;
    HWND hFindWnd;
};


BOOL CALLBACK CMainFrame::EnumWindowsProcCheckOpened(HWND hwnd, LPARAM lParam)
{
	EnumWindowsProcCheckOpenedParam* pParam = (EnumWindowsProcCheckOpenedParam*)lParam;

	//EBhEgȂ牽Ȃ
	if(pParam->hMyWnd == hwnd) return TRUE;

	//EBhEBSch3VłȂΉȂB
	if(!::GetProp(hwnd, "BSch3V-Suigyodo")) return TRUE;


	COPYDATASTRUCT cd;
	cd.dwData = COPYDATA_CHECKOPENFILE;
	cd.lpData = (PVOID)pParam->pcszPathName;
	cd.cbData = strlen(pParam->pcszPathName)+1; 

	if (::SendMessage(hwnd, WM_COPYDATA, NULL, (LPARAM)&cd)){
		//YEBhEAEBhEnhۑė񋓂𒆒f
		pParam->hFindWnd = hwnd;
		return FALSE;
	}
    return TRUE;
}


CWnd* CMainFrame::CheckOpened(const char* pcszPathName)
{
	EnumWindowsProcCheckOpenedParam coParam;
	coParam.pcszPathName = pcszPathName;
	coParam.hMyWnd = GetSafeHwnd();
	coParam.hFindWnd = NULL;
	EnumWindows(EnumWindowsProcCheckOpened,(LPARAM)&coParam);
    return CWnd::FromHandle(coParam.hFindWnd);
}


BOOL CMainFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if(pCopyDataStruct->dwData == COPYDATA_CHECKOPENFILE)
	{
		CDocument* pDoc=((CMainFrame*)AfxGetMainWnd())->GetActiveDocument();
		if (!pDoc)return FALSE;
		CString strPathName = pDoc->GetPathName();
		return (strPathName==(LPCTSTR)pCopyDataStruct->lpData);
	}
	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}




void CMainFrame::OnDestroy()
{
	
	WINDOWPLACEMENT wp;
	this->GetWindowPlacement(&wp);
	int cx = wp.rcNormalPosition.right - wp.rcNormalPosition.left;
	int cy = wp.rcNormalPosition.bottom- wp.rcNormalPosition.top;
	IniWriteWindowPosition(wp.showCmd,cx,cy);


	CFrameWnd::OnDestroy();
	// TODO : ɃbZ[W nh R[hǉ܂B
	RemoveProp(GetSafeHwnd(), "BSch3V-Suigyodo");
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;



	SetProp(GetSafeHwnd(), "BSch3V-Suigyodo", (HANDLE)1);
	AfxGetApp()->m_pMainWnd = this;


	DWORD dwVisible;

	BOOL bVisible;
	//C[_CAOo[̕\E\̏WXg瓾 2007/03/27
	if(AfxGetApp()->GetProfileInt("Option","DisplayLayerDlgBar",FALSE)){
		bVisible=TRUE;//WS_VISIBLE;
	}else{
		bVisible=FALSE;
	}
	if(!m_dbarLayer.Create(	this,IDD_DBAR_LAYER,
							WS_CHILD|CBRS_RIGHT,IDD_DBAR_LAYER))
	{
		TRACE0("Failed to create layer dialogbar\n");
		return -1;      // 쐬Ɏs
	}
	m_dbarLayer.EnableDocking(CBRS_ALIGN_LEFT|CBRS_ALIGN_RIGHT);
	CString strTitle;
	strTitle.LoadString(IDS_LAYER_DBAR_TITLE);
	m_dbarLayer.SetWindowText(strTitle);
	ShowControlBar(&m_dbarLayer,bVisible,FALSE);

	HBITMAP hBmp;
	CStatic *pStatic;
	hBmp=(HBITMAP)::LoadImage(AfxGetApp()->m_hInstance,MAKEINTRESOURCE (IDB_EDIT),IMAGE_BITMAP,0,0,LR_LOADTRANSPARENT|LR_LOADMAP3DCOLORS);
	pStatic = (CStatic*)m_dbarLayer.GetDlgItem(IDC_STATIC_EDIT);
	pStatic->SetBitmap(hBmp);

	hBmp=(HBITMAP)::LoadImage(AfxGetApp()->m_hInstance,MAKEINTRESOURCE (IDB_VIEW),IMAGE_BITMAP,0,0,LR_LOADTRANSPARENT|LR_LOADMAP3DCOLORS);
	pStatic = (CStatic*)m_dbarLayer.GetDlgItem(IDC_STATIC_VIEW);
	pStatic->SetBitmap(hBmp);


	//c[o[̕\E\̏WXg瓾 1997/01/25
	if(AfxGetApp()->GetProfileInt("Option","DisplayToolBar",TRUE)){
		dwVisible=WS_VISIBLE;
	}else{
		dwVisible=0;
	}

	if (!m_wndToolBar.CreateEx(this,TBSTYLE_FLAT, WS_CHILD | dwVisible | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))


	//if (!m_wndToolBar.Create(this,WS_CHILD|dwVisible|CBRS_TOP) ||
	//	!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // 쐬Ɏs
	}

	//Xe[^Xo[̕\E\̏WXg瓾 1997/01/25
	if(AfxGetApp()->GetProfileInt("Option","DisplayStatusBar",TRUE)) dwVisible=WS_VISIBLE;
	else dwVisible=0;
	if (!m_wndStatusBar.Create(	this,
								WS_CHILD|dwVisible|CBRS_BOTTOM,
								ID_BSCH_STATUS_BAR) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // 쐬Ɏs
	}

	//Xe[^Xo[̍W\g̊m
	int nStusBarWidth;	//Xe[^Xo[ɍW\邽߂̕
	TEXTMETRIC tm;	//eLXggbN
	CDC* pDC=m_wndStatusBar.GetDC();
	pDC->GetTextMetrics(&tm);
	m_wndStatusBar.ReleaseDC(pDC);
	nStusBarWidth=tm.tmAveCharWidth*(4+1);	//͂S{}[W1
	m_wndStatusBar.SetPaneInfo(3,ID_SEPARATOR,SBPS_NORMAL,nStusBarWidth);
	m_wndStatusBar.SetPaneInfo(4,ID_SEPARATOR,SBPS_NORMAL,nStusBarWidth);


	// TODO: c[ `bvXKvȂꍇA폜ĂB
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: c[ o[hbLO\ɂȂꍇ͈ȉ̂Rs폜
	//       ĂB
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_dbarLayer);
	DockControlBar(&m_wndToolBar);


	addExtensionMenu();

	// CG: ̍śuXvbV XN[vR|[lgɂǉĂ܂B
	CSplashWnd::ShowSplashScreen(this);
	return 0;
}

void CMainFrame::addExtensionMenu()
{
	char szKey[32];
	CString menuTitle;
	CString option;
	CString cmd;
	int n;
	
	CMenu menuPopup;
	menuPopup.CreatePopupMenu();
	n=0;
	while(n<10){
		sprintf(szKey,"Menu%d",n);
		CString strMenuInfo=AfxGetApp()->GetProfileString("ExtensionMenu",szKey);
		if(strMenuInfo.IsEmpty()) break;
		int top,end;
		top=end=0;
		end++;
		while(strMenuInfo[end]!=',' && strMenuInfo[end]) end++;
		if(!strMenuInfo[end])break;
		menuTitle=strMenuInfo.Mid(top,end-top);
		
		top=end+1;
		end=top;
		if(!strMenuInfo[top])break;
		while(strMenuInfo[end]!=',' && strMenuInfo[end]) end++;
		if(!strMenuInfo[end])break;
		option=strMenuInfo.Mid(top,end-top);

		top=end+1;
		if(!strMenuInfo[top])break;
		cmd=strMenuInfo.Mid(top);

		m_aryExtensionMenu[n].setOption(option);
		m_aryExtensionMenu[n].m_cmd=cmd;
		menuPopup.AppendMenu(MF_STRING, IDM_EXTMENU_0+n,menuTitle);
		n++;
	}
	m_extensionMenuCount=n;
	if(n>0){
		CString str;
		str.LoadString(IDS_EXTMENU_TITLE);
		CMenu* pMenu=GetMenu();
		pMenu->InsertMenu(6,MF_POPUP|MF_BYPOSITION,(UINT)menuPopup.Detach(),str);
	}

}



BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	// TODO: ̈ʒu CREATESTRUCT cs CāAWindow NXX^C
	//       CĂB
	/////////////////////////////////////////////////////////////////////////////
	if(cs.lpszClass==NULL){
		LPCSTR lpszClassName=AfxRegisterWndClass(	//EBhENX̐VK쐬
			CS_DBLCLKS, 
			AfxGetApp()->LoadStandardCursor(IDC_ARROW),										//J[\NULL
			(HBRUSH)GetStockObject(WHITE_BRUSH),
			AfxGetApp()->LoadIcon(IDR_MAINFRAME));	//AvP[VWACR
		cs.lpszClass=lpszClassName;
	}
	cs.cx = m_sizeInitialWindowSize.cx;
	cs.cy = m_sizeInitialWindowSize.cy;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh



////////////////////////////////////////////////////////////
// Xe[^Xo[̕\^\؂ւ
// AppWizardXe[^Xo[BSchƎID̂ɒu
// ̃nhKvɂȂB
// Ql Inside Visual C++ VERSION 4(AXL[j13
void CMainFrame::OnUpdateViewStatusBar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->SetCheck((m_wndStatusBar.GetStyle()&WS_VISIBLE)!=0);	
}

void CMainFrame::OnViewStatusBar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	//Xe[^Xo[̕\E\WXgɕۑ 1997/01/25
	BOOL bDisplay=((m_wndStatusBar.GetStyle()&WS_VISIBLE)==0);
	AfxGetApp()->WriteProfileInt("Option","DisplayStatusBar",bDisplay);
	CFrameWnd::OnBarCheck(ID_BSCH_STATUS_BAR);	//1997/04/11 ǉ
	//m_wndStatusBar.ShowWindow(bDisplay);		//1997/04/11 폜
	//RecalcLayout();							//1997/04/11 폜
}

//ppoint̒lXe[^Xo[ɕ\
void CMainFrame::SetStatusBarXY(const POINT* ppoint)
{
	char str[32];
	wsprintf(str,"%5d",ppoint->x);
	m_wndStatusBar.SetPaneText(3,str);
	wsprintf(str,"%5d",ppoint->y);
	m_wndStatusBar.SetPaneText(4,str);
}



void CMainFrame::OnViewToolbar() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	BOOL bDisplay=((m_wndToolBar.GetStyle()&WS_VISIBLE)==0);
	AfxGetApp()->WriteProfileInt("Option","DisplayToolBar",bDisplay);
	OnBarCheck(AFX_IDW_TOOLBAR);	//1997/04/11 ǉ
//	CFrameWnd::OnBarCheck(AFX_IDW_TOOLBAR);	//1997/04/11 ǉ
	//m_wndToolBar.ShowWindow(bDisplay);	//1997/04/11 폜
	//RecalcLayout();						//1997/04/11 폜
}

void CMainFrame::OnUpdateViewToolbar(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	pCmdUI->SetCheck((m_wndToolBar.GetStyle()&WS_VISIBLE)!=0);	
}


void CMainFrame::OnViewLayerbox()
{
	// TODO : ɃR}h nh R[hǉ܂B
	BOOL bDisplay=((m_dbarLayer.GetStyle()&WS_VISIBLE)==0);
	AfxGetApp()->WriteProfileInt("Option","DisplayLayerDlgBar",bDisplay);
	OnBarCheck(IDD_DBAR_LAYER);
}

void CMainFrame::OnUpdateViewLayerbox(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck((m_dbarLayer.GetStyle()&WS_VISIBLE)!=0);	
}

void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO : ɃbZ[W nh R[hǉ܂B
	WINDOWPLACEMENT wp;
	this->GetWindowPlacement(&wp);
	int wpcx = wp.rcNormalPosition.right - wp.rcNormalPosition.left;
	int wpcy = wp.rcNormalPosition.bottom- wp.rcNormalPosition.top;
	TRACE("CMainFrame::OnSize()  %d,%d\n",wpcx,wpcy);
	if(400<=wpcx && 300<=wpcy){
		IniWriteWindowPosition(wp.showCmd,wpcx,wpcy);
	}
	

}

CSize CMainFrame::m_sizeInitialWindowSize = CSize(CW_USEDEFAULT,CW_USEDEFAULT);

void CMainFrame::SetInitialWindowSize(int cx,int cy)
{
	if(cx!=CW_USEDEFAULT && cx<400) cx = 400;
	if(cy!=CW_USEDEFAULT && cy<300) cy = 300;
	m_sizeInitialWindowSize = CSize(cx,cy);
}


#define WINDOW_POS_SECTION "WindowPosition"
void CMainFrame::IniWriteWindowPosition(int cmdShow,int cx,int cy)
{
	TRACE("CMainFrame::IniWriteWindowPosition()  %d,%d,%d\n",cmdShow,cx,cy);
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"cmdShow",cmdShow);
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"Width",cx);
	AfxGetApp()->WriteProfileInt(WINDOW_POS_SECTION,"Height",cy);
}
void CMainFrame::IniReadWindowPosition(int& cmdShow,int& cx,int& cy)
{
	cmdShow = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"cmdShow",SW_NORMAL);
	cx = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"Width",CW_USEDEFAULT);
	cy = AfxGetApp()->GetProfileInt(WINDOW_POS_SECTION,"Height",CW_USEDEFAULT);
}



