/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2007 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef XBSCHDOC_H
#define XBSCHDOC_H


#include <list>
#include <stack>
using namespace std;

#include "SelectOption.h"
#include "ObjFilter.h"

#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschimageobj.h"
#include "ce3io.h"


//typedef list<string> stringList;
//typedef list<string>::iterator stringListIterator;

typedef list<SXBSchObj*> XBSchObjList;
typedef list<SXBSchObj*>::iterator XBSchObjListIterator;
typedef list<SXBSchObj*>::reverse_iterator XBSchObjListRevIterator;




typedef list<SPoint> SPointList;
typedef list<SPoint>::iterator SPointListIterator;

class SXBSchSheetInfo;
class SXBSchWire;

enum FIND_TARGET_FLAGS
{
	FINDTGT_TAG			=1,
	FINDTGT_LABEL		=2,
	FINDTGT_COMMENT		=4,
	FINDTGT_NAME		=8,
	FINDTGT_NAMELIB		=16,
	FINDTGT_NUM			=32
};




class SRedoInfo
{
public:
	SXBSchObj* m_pObj;
	int m_undoCount;

	SRedoInfo(){
		m_pObj = NULL;
		m_undoCount = -1;
	}
};

typedef stack<SRedoInfo> SRedoInfoStack;


class SPointEmum
{
public:
	SPointEmum();
	virtual ~SPointEmum();
	bool addSPoint(SPoint point);

	SPointList m_list;
};

class SXBSchDoc
{
public:
	SXBSchDoc();
	virtual ~SXBSchDoc();
	bool m_bDoTidyUp;


protected:


	bool m_bDirty;			//hLgɑ΂ĕύXƂtrueɂȂB
	bool m_bTempDirty;		//ꎞf[^ɑ΂ĕύXƂtrueɂȂB
	bool m_bTempNewPlace;	//ꎞf[^VKzûy[Xgf[^̂Ƃtrue

	SSize m_sizeSheet;	//V[g̃TCYۑ
	int m_nOpCount;				//ԍ
	int m_nOldestOpCount;		//ƂÂԍ

	int m_nRedoActive;			// RedoLȂƂAUndon܂ƂopCountێB

	SRect m_rcTempArea;			//	
	SRect m_rcRotateRect;		//]┽]ŒSʒu߂邽߂̃GA
	SPoint m_ptTempSnapPoint;	//ꎞIuWFNgXibvꍇ͂̓_Obhɏ悤ɂ
	bool m_bSelectForDrag;
	unsigned m_visibleLayer;
	int m_editLayer;

	unsigned m_selectedTypeFlag;
	void updateSelectedTypeFlag();
	enum SELECTED_TYPE_FLAGS
	{
		SELECTED_TYPE_TAG			=1,
		SELECTED_TYPE_LABEL			=2,
		SELECTED_TYPE_COMMENT		=4,
		SELECTED_TYPE_COMPONENT		=8,
		SELECTED_TYPE_MARKER		=16,
	};



protected:
	//Ỉ bDel  true ̂Ƃ́A폜s
	//public  resetSelect()  del() Ă΂B
	//hLgɕύXƂtrueԂ
	bool resetSelect_1(bool bDel=false);

	void pickupJunction(const SRect& rc);//ׂĂ̐ڍ_ m_listWorkJunc ɒoB
	void selectForDragJunction(int scanMax,const SRect& rc);	//͈͓̐ڍ_̑IBׂĂ̐ڍ_m_listWorkJunc ɒoB
	int divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire);
	void selectForDragWire(int scanMax,const SRect& rc);		//hbÔ߂̃C[IB
	void selectForDragExceptJuncWire(int scanMax,const SRect& rc);//hbÔ߂̐ڍ_C[ȊȎIB
	void selectForDragPinConnection(int scanMax,const SRect& rc,bool bCutOffPinWire);//hbÔ߂̃sI
	bool selectForDragPin(int scanMax,const SPoint pt);//w肵_Ƀs[C[zu

	void selectForDragReCheckSelectedLine(const SRect& rc);//̑IɁAVȔ͈͂ǉIꂽ^OAĩsɐڑꂽI[_Ȃ`FbN

	

public:  //Xg[I/O֘A
	bool writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly);
	bool writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin);
	bool readCe3(	SReadCE3& rce3,
					XBSchObjList* pList,
					const SPoint* pptOrigin,
					SXBSchSheetInfo* pSheetInfo);

public:
	XBSchObjList m_listMain;
	XBSchObjList m_listTemp;
protected:
	XBSchObjList m_listWorkJunc;			//ꎞƗp̃[NGA hbOIŎgp
	XBSchObjList m_listWorkWire;			//ꎞƗp̃[NGA hbOIŎgp
	XBSchObjList m_listWorkTagComponent;	//ꎞƗp̃[NGA hbOIŎgp

protected:
	SRedoInfoStack m_stackRedoInfo;

//----- find -----
protected:
	virtual bool findStringCompare(const char* szTarget,const char* sz,bool bMatchWhole);
public:
	bool findStart(const char* sz,bool bMatchWhole,unsigned int targetFlags);
	bool find(bool bStart=false);
	//ǔv\?
	bool canFindNext(){return m_bFindCommandActive;}
protected:
	bool m_bFindCommandActive;
	string	m_strFind;
	bool	m_bFindMatchWhole;
	unsigned int m_nTargetFlags;
	XBSchObjListRevIterator m_reviteFind;
//----- find -----


public:
	void setDirty(bool flag = true){m_bDirty = flag;}
	void setTempDirty(bool flag = true){m_bTempDirty = flag;}

	bool isDirty(){return (m_bDirty || m_bTempDirty || m_bTempNewPlace);}	//Ō̕ۑ̂ƂɕύXǂԂ
	bool isEmpty();	//}ʃIuWFNgłfalseԂ
	void SetSheetSize(const SSize& size);
	SSize SheetSize(){return m_sizeSheet;}



public:
//20060603	//}ʗvf̒ǉ ԍԂ
//20060603	int add(SXBSchObj* pObj);
	
	//}ʗvfCXgpush_backB
	void pushBackToMainList(SXBSchObj* pObj,bool doTidyUp);

	//WNV̏d`FbNs
	//bool checkRedundancyJunction(SXBSchJunc* pObj);

	//WNVAGg[̏d`FbNs
	bool checkRedundancy(SXBSchObj* pObj);



	//C[,oX̌
	void tidyUpWireBus(SXBSchLine* pObj);

	//C[,WNV̓ Xebv1
	void tidyUpWireJunction_1(int opCount);
	//C[,WNV̓ Xebv2
	void tidyUpWireJunction_2(int opCount);
	//C[,WNV̓ Xebv3
	void tidyUpWireJunction_3(int opCount);


	//IԂŒǉ}ʗvf̒ǉ ԍԂ
	int addSelect(SXBSchObj* pObj);
	//_w肵Ă̑I
	int select(const SPoint& pt,SelectOption& refSelOption);
	//͈͂w肵Ă̑I
	int select(const SRect& rc,SelectOption& refSelOption);
	int selectForDrag(const SRect& rc,bool bCutOffPinWire);
	bool isSelectedForDtag(){return this->m_bSelectForDrag;}


	void setNcPinFlag();


	//m_rcTempArea  m_ptTempSnapPoint ꎞIuWFNg̃Xgݒ肷B
	void setupRcTempArea();
	void setupRotateRect();

	
	
	//Ỉ
	//hLgɕύXƂtrueԂ
	bool resetSelect();
	//ꎞIuWFNg͈̔͂擾
	SRect tempArea(){return m_rcTempArea;}
	//ꎞIuWFNg̃Xibv|Cg擾
	SPoint tempSnapPoint(){return m_ptTempSnapPoint;}
	//
	void init();
	//t@C̓ǂݍ
	int readFile(const char* fname);
	int readFile(FILE* fp);
	//t@Cւ̏
	int writeFile(const char* fname);
	int writeFile(FILE* fp);




	//***** ҏW *****

	//Rs[
	//Rs[sꂽƂtrueԂ
	virtual bool copy(){return false;}
	//\t
	//hLgɕύXƂtrueԂ
	virtual bool paste(const SPoint&){return false;}
	//\t\H
	virtual bool canPaste(){return false;}

	//폜
	//hLgɕύXƂtrueԂ
	bool del();

	//؂
	//hLgɕύXƂtrueԂ
	bool cut();


	//Undo
	//hLgɕύXƂtrueԂ
	bool undo();

	bool redo();
protected:
	void discardRedo();

	bool isOnGrid(SPoint pt);

public:
	//Rs[\H
	bool canCopy();
	//폜\H
	bool canDel();
	//؂\H
	bool canCut();
	//Undo\H
	bool canUndo();
	//Redo\H
	bool canRedo();

	//i1PƂőIĂ邩
	const SXBSchComponent* isComponentSelectedSingly();

	//J[\ȉɂ邩ǂ
	const SXBSchComponent* isOnComponent(const SPoint& pt);

	//p[cIĂ邩
	bool isComponentSelected();
	//}[J[CIĂ邩
	bool isMarkerlineSelected();
	//^OIĂ邩
	bool isTagSelected();
	//xIĂ邩
	bool isLabelSelected();
	//RgIĂ邩
	bool isCommentSelected();




	//AttributeύX\?
	bool canAttribute();

	//Rotate
	//hLgɕύXƂtrueԂ
	bool rotate();
	//Mirror
	//hLgɕύXƂtrueԂ
	bool mirror();

	//Rotate\H
	bool canRotate();
	//Mirror\H
	bool canMirror();

	//oNAgr[g i̒u
	void bulkAttributeReplaceComponentInfo(const SCompIndex* pPartIndex);

	//oNAgr[g i̔\ݒ
	void bulkAttributeHideComponentVal(bool hide);

	//oNAgr[g iԍ̔\ݒ
	void bulkAttributeHideComponentNum(bool hide);


	//oNAgr[g RgtHg̕ύX
	void bulkAttributeCommentFont(SXBSchComment& refComment);

	//oNAgr[g }[J[C̕ύX
	void bulkAttributeMarkerLine(int width,unsigned nColor);

	//oNAgr[g ^Og̕ύX
	void bulkAttributeChangeTagFrameTo(int n);

	//x^O𐶐
	SXBSchTag* generateTagFromLabel(SXBSchLabel* pObj);
	//x^Oɕϊ
	void bulkConvertLabel2Tag();

	//xRg𐶐
	SXBSchComment* generateCommentFromLabel(SXBSchLabel* pObj);
	//xRgɕϊ
	void bulkConvertLabel2Comment();



	//^O烉x𐶐
	SXBSchLabel* generateLabelFromTag(SXBSchTag* pObj);
	//^Oxɕϊ
	void bulkConvertTag2Label();

	//^ORg𐶐
	SXBSchComment* generateCommentFromTag(SXBSchTag* pObj);
	//^ORgɕϊ
	void bulkConvertTag2Comment();



	//Rg烉x𐶐
	//SXBSchLabel* generateLabelFromComment(SXBSchComment* pObj);
	//Rgxɕϊ
	void bulkConvertComment2Label();

	//Rg^O𐶐
	//SXBSchTag* generateTagFromComment(SXBSchComment* pObj);
	//Rg^Oɕϊ
	void bulkConvertComment2Tag();





	//C[̈ړ
	bool moveToLayer(int nLayer);
	unsigned int visibleLayer(){return m_visibleLayer;}
	void setVisibleLayer(unsigned int n){m_visibleLayer=n&0xff;}
	int editLayer(){return m_editLayer;}
	void setEditLayer(int n){if(n>=0&&n<8)m_editLayer=n;}




	//ԍԂ
	int opCount(){return m_nOpCount;}
	//Âf[^̍폜
	void delOldData(int nOpCount);
	//w肵Wꎞf[^̏ォǂ
	int isOnTempData(const SPoint& pt);
	//ꎞf[^ړ
	void moveTempData(int offsetx,int offsety);
};

#endif  //#ifndef XBSCHDOC_H