/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// PartAtrb.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include "BSch.h"

//#include "PartLib.h"
#include "PartAtrb.h"
#include "complib.h"
#include "Preview.h"
#include "SelPart.h"

#include "xbschglobal.h"

#include <stdlib.h>  //_itoa()̂߂ɃCN[h
#include ".\partatrb.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPartAtrb _CAO


CPartAtrb::CPartAtrb(CWnd* pParent /*=NULL*/)
	: CDialog(CPartAtrb::IDD, pParent)
	, m_bHideNum(FALSE)
	, m_bHideVal(FALSE)
{
	//{{AFX_DATA_INIT(CPartAtrb)
	m_rPartName = _T("");
	m_rPartNum = _T("");
	m_rNote = _T("");
	//}}AFX_DATA_INIT
	m_nBlock   =1;
	m_nBlockMin=1;
	m_nBlockMax=1;
//	m_pPartIndexReplace = NULL;
	m_pPartIndex = NULL;
	m_enableEditComp = FALSE;
	m_modifiedCompInfo =FALSE;
	m_bNameVertical=FALSE;
	m_bNumVertical=FALSE;
	m_mfr = _T("");
	m_mfrpnum = _T("");
	m_package = _T("");
	m_nFocusedTo = FOCUSED_TO_BODY;
}


void CPartAtrb::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//DDX_Text(pDX, IDC_EDIT_PARTBLOCK, m_nBlock);
	//DDV_MinMaxUInt(pDX, m_nBlock, 0, 100);
	//{{AFX_DATA_MAP(CPartAtrb)
	DDX_Text(pDX, IDC_EDIT_PARTNAME, m_rPartName);
	DDX_Text(pDX, IDC_EDIT_PARTNUM, m_rPartNum);
	DDX_Text(pDX, IDC_EDIT_NOTE, m_rNote);
	//}}AFX_DATA_MAP
	DDX_Check(pDX, IDC_CHECK_NAMEVERT, m_bNameVertical);
	DDX_Check(pDX, IDC_CHECK_NUMVERT, m_bNumVertical);
	DDX_Text(pDX, IDC_EDIT_MFR, m_mfr);
	DDX_Text(pDX, IDC_EDIT_MFR_PNUM, m_mfrpnum);
	DDX_Text(pDX, IDC_EDIT_PKG, m_package);
	DDX_Check(pDX, IDC_CHECK_HIDENUM, m_bHideNum);
	DDX_Check(pDX, IDC_CHECK_HIDEVAL, m_bHideVal);
}


BEGIN_MESSAGE_MAP(CPartAtrb, CDialog)
	//{{AFX_MSG_MAP(CPartAtrb)
	ON_EN_CHANGE(IDC_EDIT_PARTBLOCK, OnChangeEditPartblock)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_REPLACE_COMPINDEX, OnBnClickedReplaceCompindex)
	ON_BN_CLICKED(IDC_EDIT_COMPINDEX, OnBnClickedEditCompindex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPartAtrb bZ[W nh

BOOL CPartAtrb::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	SetDlgItemText(IDC_ORGNAME,m_rOrgName);
	if(m_pPartIndex->m_pCompInfo){
		SetDlgItemText(IDC_EDIT_LIB_NOTE,m_pPartIndex->m_pCompInfo->m_note.c_str());
	}

	m_nBlockMax=m_pPartIndex->block();
	CSpinButtonCtrl* pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_PARTBLOCK);
	pSpin->SetRange(m_nBlockMin,m_nBlockMax);
	pSpin->SetPos(m_nBlock);
	SetBlockPins(m_nBlock);
	CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_PARTBLOCK);
	pEdit->LimitText(2);

	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];

	::GetModuleFileName(NULL,m_szLcoPath,_MAX_PATH);
	::_splitpath(m_szLcoPath,drive,dir,NULL,NULL);
	::_makepath(m_szLcoPath,drive,dir,"LCoV",".exe");

	FILE* fp;

	fp = fopen(m_szLcoPath,"r");
	m_enableEditComp = (fp != NULL);
	if(fp != NULL) fclose(fp);
	CButton* pButton = (CButton*)GetDlgItem(IDC_EDIT_COMPINDEX);
	pButton->EnableWindow(m_enableEditComp);

	CEdit* pEditFocused = NULL;
	if(m_nFocusedTo == FOCUSED_TO_VAL){
		pEditFocused = (CEdit*)GetDlgItem(IDC_EDIT_PARTNAME);
	}else{
		pEditFocused = (CEdit*)GetDlgItem(IDC_EDIT_PARTNUM);
	}
	if(pEditFocused){
		pEditFocused->SetFocus();
		pEditFocused->SetSel(0,-1);
		return FALSE;
	}else{
		return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
	}
}

void CPartAtrb::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	CString rStr;
	CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_PARTBLOCK);
	pEdit->GetWindowText(rStr);
	m_nBlock=atoi(rStr);
	if(m_nBlock<m_nBlockMin) m_nBlock=m_nBlockMin;
	else if(m_nBlock>m_nBlockMax) m_nBlock=m_nBlockMax;

	SCompInfo* pInfo = m_pPartIndex->compInfo();
	CString str;
	GetDlgItemText(IDC_EDIT_MFR,str);
	pInfo->m_mfr = str;
	GetDlgItemText(IDC_EDIT_MFR_PNUM,str);
	pInfo->m_mfrpn = str;
	GetDlgItemText(IDC_EDIT_PKG,str);
	pInfo->m_pkg = str;

	CDialog::OnOK();
}

//gpubNύXƂAsԍ\悤ɕύX 1997/01/21
//̋@\ OnVScrollGfBbgRg[ύXɕύX 1997/01/22
//void CPartAtrb::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
//{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	// ̃_CAOɂ WM_VSCROLL 𔭐ACeȂ̂
	// T{̃R[hɂȂĂBWM_VSCROLL 𔭐ACeǉ
	// Ə
//	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);

//	if(nSBCode==SB_THUMBPOSITION){
//		SetBlockPins(nPos);
//	}
//}

//IDC_PIN_NUM X^eBbNRg[ɃsԍZbg
void CPartAtrb::SetBlockPins(int nBlock)
{
	CString rString;		//̕
	//char szPinNum[32];			//ɏsԍi[ rString ɒǉ
//	char* pc;				//ꎞIɎg|C^
//	DWORD dwPinNumInfo;		//m_pPartIndex瓾鐶̃sԍ
	int n,nMaxPin;
	//WORD wNumPfix;
	const SPin* ppininfo;
	
	if(nBlock>=m_nBlockMin && nBlock<=m_nBlockMax){
		nMaxPin=m_pPartIndex->pinCount();
		if(nMaxPin>10) nMaxPin=10;	//\ĂdȂAƎv
		for(n=0;n<nMaxPin;n++){
			ppininfo = m_pPartIndex->pin(n);
			//dwPinNumInfo=m_pPartIndex->GetPinNum(n,nBlock-1);//unBlock-1vۂ̃ubNԍ
			//wNumPfix=HIWORD(dwPinNumInfo);					 //sԍ̏ʃ[h
			//pc=szPinNum;
			if(n>0) rString+=",";	//Q߈ȍ~͐擪','
			rString+=ppininfo->pinNum(nBlock-1);
		}
	}
	CStatic* pST=(CStatic*)GetDlgItem(IDC_PIN_NUM);
	if(pST!=NULL)	pST->SetWindowText(rString);
}


//gpubNύXƂAsԍ\ 1997/01/22
//    i̋@\ OnVScroll炱ɕύXj
//EXsRg[𑀍삵ꍇ
//   (1)XsRg[ŃofBIDC_EDIT_PARTBLOCKύX
//   (2)EN_CHANGE𔭐
//   (3)SetBlockPins()o[֐IDC_PIN_NUMɃsԍZbg
//E IDC_EDIT_PARTBLOCK ύXꍇ
//   (1)[U[IDC_EDIT_PARTBLOCKύX
//   (2)EN_CHANGE𔭐
//   (3)SetBlockPins()o[֐IDC_PIN_NUMɃsԍZbg
void CPartAtrb::OnChangeEditPartblock() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CString rStr;
	CEdit* pEdit=(CEdit*)GetDlgItem(IDC_EDIT_PARTBLOCK);
	pEdit->GetWindowText(rStr);
	int nBlock=atoi(rStr);
	SetBlockPins(nBlock);
}

void CPartAtrb::OnBnClickedReplaceCompindex()
{
	CSelPart dlg;
	dlg.m_bUsePreview=TRUE;		//vr[gǂ̐ݒ
	if(g_LibraryInfo(m_nLastSelectLibrary)){//NULLłȂ...
		dlg.m_nLastSelectLibrary=m_nLastSelectLibrary;
		dlg.m_nLastSelectPart=m_nLastSelectPart;
	}else{
		dlg.m_nLastSelectLibrary=0;
		dlg.m_nLastSelectPart=0;
	}
	if(dlg.DoModal()==IDCANCEL){
		return;
	}

	const SCompIndex* pPartIndex = dlg.m_pCompIndex;
	if(pPartIndex==NULL){
		CString rString;
		//bZ[W{bNXp̃bZ[W̍쐬
		AfxFormatString1(rString,IDS_NOT_FOUND_PART,dlg.m_rStrPartName); 
		AfxMessageBox(rString,MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	m_nLastSelectPart=    dlg.m_nLastSelectPart;
	m_nLastSelectLibrary= dlg.m_nLastSelectLibrary;
	m_pPartIndex = pPartIndex;
	m_rOrgName = pPartIndex->name();

	m_nBlockMax=m_pPartIndex->block();
	CSpinButtonCtrl* pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_PARTBLOCK);
	pSpin->SetRange(m_nBlockMin,m_nBlockMax);
	if(m_nBlock>m_nBlockMax){
		m_nBlock=m_nBlockMax;
		pSpin->SetPos(m_nBlock);
	}
	SetBlockPins(m_nBlock);

//	CStatic* pST=(CStatic*)GetDlgItem(IDC_ORGNAME);
//	pST->SetWindowText(m_rOrgName);
	SetDlgItemText(IDC_ORGNAME,m_rOrgName);
	if(m_pPartIndex->m_pCompInfo){
		SetDlgItemText(IDC_EDIT_LIB_NOTE,m_pPartIndex->m_pCompInfo->m_note.c_str());
		const char* pc;

		pc = m_pPartIndex->Mfr();
		if(pc!=NULL && *pc != 0){	SetDlgItemText(IDC_EDIT_MFR,pc);	}

		pc = m_pPartIndex->MfrPn();
		if(pc!=NULL && *pc != 0){	SetDlgItemText(IDC_EDIT_MFR_PNUM,pc);	}

		pc = m_pPartIndex->Pkg();
		if(pc!=NULL && *pc != 0){	SetDlgItemText(IDC_EDIT_PKG,pc);	}
	}
}

void CPartAtrb::OnBnClickedEditCompindex()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	if(!m_enableEditComp)return;
	char dir[_MAX_PATH];
	char path[_MAX_PATH];
	char cmdline[_MAX_PATH*2+10];

	::GetTempPath(_MAX_PATH,dir);
	if(::GetTempFileName(dir,"b3v",0,path)==0) return;

	FILE* fp;
	if((fp = fopen(path,"w"))==NULL) return;

	SCompInfo* pInfo = m_pPartIndex->compInfo();

	CString str;
	GetDlgItemText(IDC_EDIT_MFR,str);
	pInfo->m_mfr = str;
	GetDlgItemText(IDC_EDIT_MFR_PNUM,str);
	pInfo->m_mfrpn = str;
	GetDlgItemText(IDC_EDIT_PKG,str);
	pInfo->m_pkg = str;


	SWriteCE3 wce3;
	wce3.Attach(fp);
	wce3.WriteRecord("+BSCH3_LIB_V.1.0");
	wce3.WriteEOL();
	//SCompInfo* pInfo = m_pPartIndex->compInfo();
	pInfo->writeCe3(wce3,m_rOrgName);
	wce3.WriteRecord("-BSCH3_LIB_V.1.0");
	wce3.WriteEOL();
	fclose(fp);

	sprintf(cmdline,"%s \"%s\"",m_szLcoPath,path);

	PROCESS_INFORMATION pi;
	STARTUPINFO si;

    ZeroMemory(&pi, sizeof(pi));
	ZeroMemory(&si, sizeof(si));
    si.cb = sizeof(si);

    BOOL resProc = CreateProcess(NULL, cmdline, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
	if(!resProc) return;
	
	while(WAIT_TIMEOUT==WaitForSingleObject(pi.hProcess,1)){
		MSG msg;
		if(GetMessage(&msg,NULL,0,0)){
			if(msg.message == WM_PAINT){				//	bZ[W WM_PAINT Ȃ
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}

	TRACE("End LCoV\n");
	CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);

	m_tempLib.deleteContent();
	m_tempLib.readLibraryFile(path);
	DeleteFile(path);	
	if(m_tempLib.count()<1) return;

	SCompIndex* pPartIndex = m_tempLib.compIndex(0);
	if(pPartIndex==NULL) return;
	
	m_pPartIndex = pPartIndex;
	m_rOrgName = pPartIndex->name();

	m_nBlockMax=m_pPartIndex->block();
	CSpinButtonCtrl* pSpin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN_PARTBLOCK);
	pSpin->SetRange(m_nBlockMin,m_nBlockMax);
	if(m_nBlock>m_nBlockMax){
		m_nBlock=m_nBlockMax;
		pSpin->SetPos(m_nBlock);
	}
	SetBlockPins(m_nBlock);

//	CStatic* pST=(CStatic*)GetDlgItem(IDC_ORGNAME);
//	pST->SetWindowText(m_rOrgName);
	SetDlgItemText(IDC_ORGNAME,m_rOrgName);
	if(m_pPartIndex->m_pCompInfo){
		SetDlgItemText(IDC_EDIT_LIB_NOTE,m_pPartIndex->m_pCompInfo->m_note.c_str());

		SetDlgItemText(IDC_EDIT_MFR,m_pPartIndex->Mfr());
		SetDlgItemText(IDC_EDIT_MFR_PNUM,m_pPartIndex->MfrPn());
		SetDlgItemText(IDC_EDIT_PKG,m_pPartIndex->Pkg());
	}

	m_modifiedCompInfo = TRUE;
	
}
