/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

//XBSch̃hLg̊ǗsB
#include "stdafx.h"
//#include <qapplication.h>
//#include <qwidget.h>
//#include <qstring.h>
//#include <SSize.h>
//#include <SPoint.h>
//#include <qclipboard.h>
#include <stdio.h>
#include <assert.h>
#include <shlwapi.h>
#include <string>
#include <list>
using namespace std;
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschdoc.h"
#include "xbschdocsch.h"

//***** Qtˑ *****
//Rs[
//Rs[sꂽƂtrueԂ
bool SXBSchDocSch::copy()
{
	if(!m_listTemp.size())return false;
	SPoint ptOrigin = SPoint(m_rcTempArea.l(),m_rcTempArea.t());
	ptOrigin.setX(((ptOrigin.x()+5)/10)*10);
	ptOrigin.setY(((ptOrigin.y()+5)/10)*10);

	string str("");
	SWriteCE3 wce3;
	wce3.Attach(&str);

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");
	wce3.WriteEOL();
	writeCe3(wce3,&m_listTemp,true,&ptOrigin);
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");
	wce3.WriteEOL();


	int nLength = str.size()+1;
	//BYTE* pBuff=memfile.Detach();		//obt@t@C؂藣ăN[Y
	HGLOBAL hGMem=::GlobalAlloc(GMEM_MOVEABLE,nLength);//Nbv{[hɓn̊m
	if(hGMem==NULL){
		return false;			//蓖ĂɎs牽Ȃ
	}
	BYTE* pgBuff=(BYTE*)::GlobalLock(hGMem);	//蓖ĂO[obN
	memcpy(pgBuff,str.c_str(),nLength);		//蓖ĂO[oɃt@C̓eRs[
//	free(pBuff);						//t@C؂藣̉B
	::GlobalUnlock(hGMem);				//O[õAbN
	::OpenClipboard(AfxGetMainWnd()->m_hWnd);//Nbv{[h̃I[v
	::EmptyClipboard();					//Nbv{[hɂ
	::SetClipboardData(CF_TEXT,hGMem);	//Nbv{[hɃf[^n
	::CloseClipboard();					//Nbv{[h

//    QClipboard *cb = QApplication::clipboard();
//    cb->setText(QString::fromLocal8Bit(str.c_str()));
	
	return true;
}


//\t
//hLgɕύXƂtrueԂ
bool SXBSchDocSch::paste(const SPoint& pt)
{
	if(!canPaste()) return false;
	::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
	HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
	if(hGMem==NULL){
		::CloseClipboard();						//Close clip board.
		return false;
	}
	char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
	string cbbuff=string(pgBuff);				//Initialize string with global memory.
	::GlobalUnlock(hGMem);						//Unock global memory.
	::CloseClipboard();							//Close clip board.


	SReadCE3 rce3;
	rce3.Attach(cbbuff.c_str());

	string str("");

	rce3.ReadRecord(str);
	if(str != "+BSCH3_DATA_V.1.0") return false;

	readCe3(rce3,&m_listTemp,&pt,NULL);
	if(!m_listTemp.size()) return false;

	moveToLayer(m_editLayer);

	updateSelectedTypeFlag();
	setupRcTempArea();

	m_bTempNewPlace = true;
	m_bFindCommandActive = false;
	
	return true;
}

//Check clip board data.
//Return true if data is available.
bool SXBSchDocSch::canPaste()
{
	static const char* pcszID= "+BSCH3_DATA_V.1.0";
	int nIdLength = strlen(pcszID);
	bool retVal = false;
	if(::IsClipboardFormatAvailable(CF_TEXT)){
		::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
		HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
		if(hGMem!=NULL){
			int nLength=GlobalSize(hGMem);				//Size of clip board data.
			if(nLength>nIdLength){
				char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
				if(strncmp(pcszID,pgBuff,nIdLength)==0){
					retVal = true;
				}
				::GlobalUnlock(hGMem);				//Unock global memory.
			}
		}
		::CloseClipboard();
	}
//	QString strID("+BSCH3_DATA_V.1.0");
//	QClipboard *cb = QApplication::clipboard();
//    QString str = cb->text().left(strID.length());	
//	return (str == strID);
	return retVal;
}

bool SXBSchDocSch::findStringCompare(const char* szTarget,const char* sz,bool bMatchWhole,bool bCaseSensitive)
{
	if(szTarget==NULL || sz==NULL)return false;
	if(*szTarget=='\0' || *sz=='\0') return false;

	if(bMatchWhole){
		if(bCaseSensitive){
			return !(strcmp(szTarget,sz));
		}else{
			return !(_stricmp(szTarget,sz));
		}
	}else{
		if(bCaseSensitive){
			return (_mbsstr((const unsigned char*)szTarget,(const unsigned char*)sz)!=NULL);
		}else{
			return (StrStrI(szTarget,sz)!=NULL);
		}
	}
}

