/*
 * context class program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <string>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "builtin.h"
#include "unify.h"
#include "context.h"

Context* CXNode = NULL;

void PrintContext()
{
	Context* cx;

	printf("--\nContext que \n");
	for (cx = CXNode; cx != NULL; cx=cx->Next()) {
		printf("cx %x\n", cx);
		PrintNode("env_stack ", cx->env_stack);
		PrintNode("env ", cx->env);
		printf("-\n");
	}
	
}

void Context::Clear()
{
	Node* gdummy;
	Node* mdummy;
	Node* edummy;
	extern int PopStack(Context* cx, Node* &goals, Node* &md, Node* &env);

//PrintNode("context Clear env ", env);
	UnsetEnv(env);

	while(PopStack(this, gdummy, mdummy, edummy)) {
//PrintNode("context Clear edummy ", edummy);
		UnsetEnv(edummy);
	}

}


void Context::CutAll()
{
	for (Context* c = CXNode; c != NULL; c = c->next) {
		c->env = Nil->Cons(Nil);
		c->env_stack = Nil;
		c->misc_stack = Nil;
	}
}


void PopContext(Context* c)
{
	Context* cx;
	Context* cxnext;

	extern int DropStack(Context * cx);

	for (cx = CXNode; cx != NULL; cx = cxnext) {
		cxnext = cx->Next();
		if (cx == c) {
			break;
		}
		while(DropStack(cx))
			;
		delete cx;
	}
	CXNode = cx;
}

void ClearAllContext()
{
	Context* cx;
	Context* cxnext;

	extern int DropStack(Context* cx);

	for (cx = CXNode; cx != NULL; cx = cxnext) {
		cxnext = cx->Next();
		while(DropStack(cx))
			;
		delete cx;
	}
	CXNode = NULL;
}

