/*
 * let & rpn calculation H.Niwa copyright (C) 2009
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __LET_H
#define __LET_H


extern int int_let(Context* cx, Node* n);
extern int int_compare(Context* cx, Node* n);
extern int int_rpn(Context* cx, Node* n);
extern int int_intp(Context* cx, Node* n1);
extern int int_push(Context* cx, Node* n1);
extern int int_pushnum(Context* cx, int n);
extern int int_pop(Context* cx, Node* v);
extern int int_plus(Context* cx);
extern int int_minus(Context* cx);
extern int int_mult(Context* cx);
extern int int_div(Context* cx);
extern int int_mod(Context* cx);
extern int int_gt(Context* cx);
extern int int_ge(Context* cx);
extern int int_eq(Context* cx);
extern int int_noteq(Context* cx);
extern int int_lt(Context* cx);
extern int int_le(Context* cx);
extern int int_and(Context* cx);
extern int int_or(Context* cx);
extern int int_not(Context* cx);

extern int float_let(Context* cx, Node* n);
extern int float_compare(Context* cx, Node* n);
extern int float_rpn(Context* cx, Node* n);
extern int float_intp(Context* cx, Node* n1);
extern int float_push(Context* cx, Node* n1);
extern int float_pushnum(Context* cx, double n);
extern int float_pop(Context* cx, Node* v, Node* &env);
extern int float_plus(Context* cx);
extern int float_minus(Context* cx);
extern int float_mult(Context* cx);
extern int float_div(Context* cx);
extern int float_mod(Context* cx);
extern int float_gt(Context* cx);
extern int float_ge(Context* cx);
extern int float_eq(Context* cx);
extern int float_noteq(Context* cx);
extern int float_lt(Context* cx);
extern int float_le(Context* cx);
extern int float_and(Context* cx);
extern int float_or(Context* cx);
extern int float_not(Context* cx);



#endif

