/*
 * check reseved words program copyright (C) 2009 - 2010 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <errno.h>
#include <setjmp.h>
#include <sys/time.h>
#include <math.h>
#include <libgen.h>
#include <setjmp.h>

#include <string>
#include <complex>

#include "syserr.h"

const char* ReservedWords[] = {
	"help",
	"opcall",
	"module",
	"list",
	"bye",
	"quit",
	"exit",
	"new",
	"eval",
	"x",
	"nop",
	"print",
	"printf",
	"printlist",
	"printlistnl",
	"is",
	"eq",
	"noteq",
	"warn",
	"include",
	"load",
	"save",
	"edit",
	"cd",
	"pwd",
	"dir",
	"ls",
	"quote",
	"%",
	"\\",
	"obj",
	"unify",
	"timeout",
	"loop",
	"alt",
	"for",
	"foreach",
	"firstfor",
	"firstforeach",
	"map",
	"findall",
	"or",
	"not",
	"tron",
	"troff",
	"let",
	"letf",
	"letc",
	"rpnf",
	"rpnc",
	"rpn",
	"func",
	"f",
	"comparef",
	"compare",
	"TOKEN",
	"SKIPSPACE",
	"C",
	"N",
	"A",
	"AN",
	"^",
	"$",
	"CR",
	"CNTL",
	"EOF",
	"SPACE",
	"PUNCT",
	"STRINGS",
	"WORD",
	"NUM",
	"FNUM",
	"SNUM",
	"SFNUM",
	"ID",
	"RANGE",
	"NONRANGE",
	"GETTOKEN",
	"SKIP",
	"SKIPCR",
	"NULLLINE",
	"NEXTCHAR",
	"NEXTSTR",
	"NOTNEXTSTR",
	"NEXTSYNTAX",
	"NOTNEXTSYNTAX",
	"INDENT",
	"NEXTINDENT",
	"asserta",
	"assertz",
	"assert",
	"erase",
	"retract",
	"retractpred",
	"newObj",
	"cloneObj",
	"delObj",
	"objName",
	"self",
	"super",
	"setVar",
	"setArray",
	"delVar",
	"delArray",
	"newproc",
	"eachproc",
	"firstnewproc",
	"firsteachproc"
	"catch"
	"throw"
};

int CheckReserved(const char* s)
{
	int len = (sizeof ReservedWords)/(sizeof (char*));
	int i;
	std::string s1, s2;

	s1 = s;
	for (i = 0; i < len; i++) {
		s2 = ReservedWords[i];
		if (s1 == s2) {
			syserr("%s is reserved word. please, use other words. \n", s);
			return 1;
		}
	}
	return 0;

}

