/*
 * list to c program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <errno.h>

#include <string>
#include <complex>

#include "syserr.h"

#include "bin_node.h"
#include "gc.h"
#include "var.h"
#include "pred.h"
#include "context.h"
#include "unify.h"
#include "builtin.h"
#include "sysmodule.h"
#include "list2c.h"

Node* list2c(Node* node)
{
	Node* n = Nil;

	if (node->kind() == PRED) {
		n = Cons(mka("MkPred"), 
			MkList(
				Cons(mka("Cons"),
					Cons(list2c(node->Car()), 
					     Cons(mka(", "),
					     list2c(node->Cdr()))))));
		return n;
	} else if (node->kind() == LIST) {
		n = Cons(mka("Cons"),
			MkList(Cons(list2c(node->Car()), 
				Cons(mka(", "), list2c(node->Cdr())))));
		return n;
	} else if (node == Nil) {
		return MkList(mka("Nil"));
	}
	
	return MkList(mka("mka"), MkList(node));
}

