/*
 * ncurses lib program copyright (C) 2009 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __NCURLIB_H__
#define __NCURLIB_H__

extern int ncurlibflag;

extern int cursmodule(Context* cx, Node* goalscar, Node* goalscdr, 
				Node* goals, List* module, int& r);

extern int curs_startcurses(Context* cx, Node* goalscar, List* module);
extern int curs_COLOR_PAIR(Context* cx, Node* goalscar, List* module);
extern int curs_PAIR_NUMBER(Context* cx, Node* goalscar, List* module);
extern int curs__nc_tracebits(Context* cx, Node* goalscar, List* module);
extern int curs__traceattr(Context* cx, Node* goalscar, List* module);
extern int curs__traceattr2(Context* cx, Node* goalscar, List* module);
extern int curs__tracechar(Context* cx, Node* goalscar, List* module);
extern int curs__tracechtype(Context* cx, Node* goalscar, List* module);
extern int curs__tracechtype2(Context* cx, Node* goalscar, List* module);
extern int curs__tracedump(Context* cx, Node* goalscar, List* module);
extern int curs__tracef(Context* cx, Node* goalscar, List* module);
extern int curs__tracemouse(Context* cx, Node* goalscar, List* module);
extern int curs_add_wch(Context* cx, Node* goalscar, List* module);
extern int curs_add_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_add_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_addch(Context* cx, Node* goalscar, List* module);
extern int curs_addchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_addchstr(Context* cx, Node* goalscar, List* module);
extern int curs_addnstr(Context* cx, Node* goalscar, List* module);
extern int curs_addnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_addstr(Context* cx, Node* goalscar, List* module);
extern int curs_addwstr(Context* cx, Node* goalscar, List* module);
extern int curs_assume_default_colors(Context* cx, Node* goalscar, List* module);
extern int curs_attr_get(Context* cx, Node* goalscar, List* module);
extern int curs_attr_off(Context* cx, Node* goalscar, List* module);
extern int curs_attr_on(Context* cx, Node* goalscar, List* module);
extern int curs_attr_set(Context* cx, Node* goalscar, List* module);
extern int curs_attroff(Context* cx, Node* goalscar, List* module);
extern int curs_attron(Context* cx, Node* goalscar, List* module);
extern int curs_attrset(Context* cx, Node* goalscar, List* module);
extern int curs_baudrate(Context* cx, Node* goalscar, List* module);
extern int curs_beep(Context* cx, Node* goalscar, List* module);
extern int curs_bkgd(Context* cx, Node* goalscar, List* module);
extern int curs_bkgdset(Context* cx, Node* goalscar, List* module);
extern int curs_bkgrnd(Context* cx, Node* goalscar, List* module);
extern int curs_bkgrndset(Context* cx, Node* goalscar, List* module);
extern int curs_border(Context* cx, Node* goalscar, List* module);
extern int curs_border_set(Context* cx, Node* goalscar, List* module);
extern int curs_box(Context* cx, Node* goalscar, List* module);
extern int curs_box_set(Context* cx, Node* goalscar, List* module);
extern int curs_can_change_color(Context* cx, Node* goalscar, List* module);
extern int curs_cbreak(Context* cx, Node* goalscar, List* module);
extern int curs_chgat(Context* cx, Node* goalscar, List* module);
extern int curs_clear(Context* cx, Node* goalscar, List* module);
extern int curs_clearok(Context* cx, Node* goalscar, List* module);
extern int curs_clrtobot(Context* cx, Node* goalscar, List* module);
extern int curs_clrtoeol(Context* cx, Node* goalscar, List* module);
extern int curs_color_content(Context* cx, Node* goalscar, List* module);
extern int curs_color_set(Context* cx, Node* goalscar, List* module);
extern int curs_copywin(Context* cx, Node* goalscar, List* module);
extern int curs_curs_set(Context* cx, Node* goalscar, List* module);
extern int curs_curses_version(Context* cx, Node* goalscar, List* module);
extern int curs_def_prog_mode(Context* cx, Node* goalscar, List* module);
extern int curs_def_shell_mode(Context* cx, Node* goalscar, List* module);
extern int curs_define_key(Context* cx, Node* goalscar, List* module);
extern int curs_del_curterm(Context* cx, Node* goalscar, List* module);
extern int curs_delay_output(Context* cx, Node* goalscar, List* module);
extern int curs_delch(Context* cx, Node* goalscar, List* module);
extern int curs_deleteln(Context* cx, Node* goalscar, List* module);
extern int curs_delscreen(Context* cx, Node* goalscar, List* module);
extern int curs_delwin(Context* cx, Node* goalscar, List* module);
extern int curs_derwin(Context* cx, Node* goalscar, List* module);
extern int curs_doupdate(Context* cx, Node* goalscar, List* module);
extern int curs_dupwin(Context* cx, Node* goalscar, List* module);
extern int curs_echo(Context* cx, Node* goalscar, List* module);
extern int curs_echo_wchar(Context* cx, Node* goalscar, List* module);
extern int curs_echochar(Context* cx, Node* goalscar, List* module);
extern int curs_endwin(Context* cx, Node* goalscar, List* module);
extern int curs_erase(Context* cx, Node* goalscar, List* module);
extern int curs_erasechar(Context* cx, Node* goalscar, List* module);
extern int curs_erasewchar(Context* cx, Node* goalscar, List* module);
extern int curs_filter(Context* cx, Node* goalscar, List* module);
extern int curs_flash(Context* cx, Node* goalscar, List* module);
extern int curs_flushinp(Context* cx, Node* goalscar, List* module);
extern int curs_get_wch(Context* cx, Node* goalscar, List* module);
extern int curs_get_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_getbegyx(Context* cx, Node* goalscar, List* module);
extern int curs_getbkgd(Context* cx, Node* goalscar, List* module);
extern int curs_getbkgrnd(Context* cx, Node* goalscar, List* module);
extern int curs_getcchar(Context* cx, Node* goalscar, List* module);
extern int curs_getch(Context* cx, Node* goalscar, List* module);
extern int curs_getmaxyx(Context* cx, Node* goalscar, List* module);
extern int curs_getmouse(Context* cx, Node* goalscar, List* module);
extern int curs_getn_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_getnstr(Context* cx, Node* goalscar, List* module);
extern int curs_getparyx(Context* cx, Node* goalscar, List* module);
extern int curs_getstr(Context* cx, Node* goalscar, List* module);
extern int curs_getsyx(Context* cx, Node* goalscar, List* module);
extern int curs_getwin(Context* cx, Node* goalscar, List* module);
extern int curs_getyx(Context* cx, Node* goalscar, List* module);
extern int curs_halfdelay(Context* cx, Node* goalscar, List* module);
extern int curs_has_colors(Context* cx, Node* goalscar, List* module);
extern int curs_has_ic(Context* cx, Node* goalscar, List* module);
extern int curs_has_il(Context* cx, Node* goalscar, List* module);
extern int curs_has_key(Context* cx, Node* goalscar, List* module);
extern int curs_hline(Context* cx, Node* goalscar, List* module);
extern int curs_hline_set(Context* cx, Node* goalscar, List* module);
extern int curs_idcok(Context* cx, Node* goalscar, List* module);
extern int curs_(Context* cx, Node* goalscar, List* module);
extern int curs_idlok(Context* cx, Node* goalscar, List* module);
extern int curs_immedok(Context* cx, Node* goalscar, List* module);
extern int curs_in_wch(Context* cx, Node* goalscar, List* module);
extern int curs_in_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_in_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_inch(Context* cx, Node* goalscar, List* module);
extern int curs_inchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_inchstr(Context* cx, Node* goalscar, List* module);
extern int curs_init_color(Context* cx, Node* goalscar, List* module);
extern int curs_init_pair(Context* cx, Node* goalscar, List* module);
extern int curs_initscr(Context* cx, Node* goalscar, List* module);
extern int curs_innstr(Context* cx, Node* goalscar, List* module);
extern int curs_innwstr(Context* cx, Node* goalscar, List* module);
extern int curs_ins_nwstr(Context* cx, Node* goalscar, List* module);
extern int curs_ins_wch(Context* cx, Node* goalscar, List* module);
extern int curs_ins_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_insch(Context* cx, Node* goalscar, List* module);
extern int curs_insdelln(Context* cx, Node* goalscar, List* module);
extern int curs_insertln(Context* cx, Node* goalscar, List* module);
extern int curs_insnstr(Context* cx, Node* goalscar, List* module);
extern int curs_insstr(Context* cx, Node* goalscar, List* module);
extern int curs_instr(Context* cx, Node* goalscar, List* module);
extern int curs_intrflush(Context* cx, Node* goalscar, List* module);
extern int curs_inwstr(Context* cx, Node* goalscar, List* module);
extern int curs_is_linetouched(Context* cx, Node* goalscar, List* module);
extern int curs_is_wintouched(Context* cx, Node* goalscar, List* module);
extern int curs_isendwin(Context* cx, Node* goalscar, List* module);
extern int curs_key_defined(Context* cx, Node* goalscar, List* module);
extern int curs_key_name(Context* cx, Node* goalscar, List* module);
extern int curs_keybound(Context* cx, Node* goalscar, List* module);
extern int curs_keyname(Context* cx, Node* goalscar, List* module);
extern int curs_keyok(Context* cx, Node* goalscar, List* module);
extern int curs_keypad(Context* cx, Node* goalscar, List* module);
extern int curs_killchar(Context* cx, Node* goalscar, List* module);
extern int curs_killwchar(Context* cx, Node* goalscar, List* module);
extern int curs_leaveok(Context* cx, Node* goalscar, List* module);
extern int curs_longname(Context* cx, Node* goalscar, List* module);
extern int curs_mcprint(Context* cx, Node* goalscar, List* module);
extern int curs_meta(Context* cx, Node* goalscar, List* module);
extern int curs_mouse_trafo(Context* cx, Node* goalscar, List* module);
extern int curs_mouseinterval(Context* cx, Node* goalscar, List* module);
extern int curs_mousemask(Context* cx, Node* goalscar, List* module);
extern int curs_move(Context* cx, Node* goalscar, List* module);
extern int curs_mvadd_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvadd_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvadd_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddch(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvaddwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvchgat(Context* cx, Node* goalscar, List* module);
extern int curs_mvcur(Context* cx, Node* goalscar, List* module);
extern int curs_mvdelch(Context* cx, Node* goalscar, List* module);
extern int curs_mvderwin(Context* cx, Node* goalscar, List* module);
extern int curs_mvget_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvget_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvgetch(Context* cx, Node* goalscar, List* module);
extern int curs_mvgetn_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvgetnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvgetstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvhline(Context* cx, Node* goalscar, List* module);
extern int curs_mvhline_set(Context* cx, Node* goalscar, List* module);
extern int curs_mvin_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvin_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvin_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinch(Context* cx, Node* goalscar, List* module);
extern int curs_mvinchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvins_nwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvins_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvins_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinsch(Context* cx, Node* goalscar, List* module);
extern int curs_mvinsnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinsstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvinwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvprintw(Context* cx, Node* goalscar, List* module);
extern int curs_mvscanw(Context* cx, Node* goalscar, List* module);
extern int curs_mvvline(Context* cx, Node* goalscar, List* module);
extern int curs_mvvline_set(Context* cx, Node* goalscar, List* module);
extern int curs_mvwadd_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwadd_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwadd_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwaddwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwchgat(Context* cx, Node* goalscar, List* module);
extern int curs_mvwdelch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwget_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwget_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwgetch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwgetn_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwgetnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwgetstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwhline(Context* cx, Node* goalscar, List* module);
extern int curs_mvwhline_set(Context* cx, Node* goalscar, List* module);
extern int curs_mvwin(Context* cx, Node* goalscar, List* module);
extern int curs_mvwin_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwin_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwin_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinchstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwins_nwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwins_wch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwins_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinsch(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinsnstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinsstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwinwstr(Context* cx, Node* goalscar, List* module);
extern int curs_mvwprintw(Context* cx, Node* goalscar, List* module);
extern int curs_mvwscanw(Context* cx, Node* goalscar, List* module);
extern int curs_mvwvline(Context* cx, Node* goalscar, List* module);
extern int curs_mvwvline_set(Context* cx, Node* goalscar, List* module);
extern int curs_napms(Context* cx, Node* goalscar, List* module);
extern int curs_newpad(Context* cx, Node* goalscar, List* module);
extern int curs_newterm(Context* cx, Node* goalscar, List* module);
extern int curs_newwin(Context* cx, Node* goalscar, List* module);
extern int curs_nl(Context* cx, Node* goalscar, List* module);
extern int curs_nocbreak(Context* cx, Node* goalscar, List* module);
extern int curs_nodelay(Context* cx, Node* goalscar, List* module);
extern int curs_noecho(Context* cx, Node* goalscar, List* module);
extern int curs_nonl(Context* cx, Node* goalscar, List* module);
extern int curs_noqiflush(Context* cx, Node* goalscar, List* module);
extern int curs_noraw(Context* cx, Node* goalscar, List* module);
extern int curs_notimeout(Context* cx, Node* goalscar, List* module);
extern int curs_overlay(Context* cx, Node* goalscar, List* module);
extern int curs_overwrite(Context* cx, Node* goalscar, List* module);
extern int curs_pair_content(Context* cx, Node* goalscar, List* module);
extern int curs_pechochar(Context* cx, Node* goalscar, List* module);
extern int curs_pnoutrefresh(Context* cx, Node* goalscar, List* module);
extern int curs_prefresh(Context* cx, Node* goalscar, List* module);
extern int curs_printw(Context* cx, Node* goalscar, List* module);
extern int curs_putp(Context* cx, Node* goalscar, List* module);
extern int curs_putwin(Context* cx, Node* goalscar, List* module);
extern int curs_qiflush(Context* cx, Node* goalscar, List* module);
extern int curs_raw(Context* cx, Node* goalscar, List* module);
extern int curs_redrawwin(Context* cx, Node* goalscar, List* module);
extern int curs_refresh(Context* cx, Node* goalscar, List* module);
extern int curs_reset_prog_mode(Context* cx, Node* goalscar, List* module);
extern int curs_reset_shell_mode(Context* cx, Node* goalscar, List* module);
extern int curs_resetty(Context* cx, Node* goalscar, List* module);
extern int curs_resizeterm(Context* cx, Node* goalscar, List* module);
extern int curs_restartterm(Context* cx, Node* goalscar, List* module);
extern int curs_ripoffline(Context* cx, Node* goalscar, List* module);
extern int curs_savetty(Context* cx, Node* goalscar, List* module);
extern int curs_scanw(Context* cx, Node* goalscar, List* module);
extern int curs_scr_dump(Context* cx, Node* goalscar, List* module);
extern int curs_scr_init(Context* cx, Node* goalscar, List* module);
extern int curs_scr_restore(Context* cx, Node* goalscar, List* module);
extern int curs_scr_set(Context* cx, Node* goalscar, List* module);
extern int curs_scrl(Context* cx, Node* goalscar, List* module);
extern int curs_scroll(Context* cx, Node* goalscar, List* module);
extern int curs_scrollok(Context* cx, Node* goalscar, List* module);
extern int curs_set_curterm(Context* cx, Node* goalscar, List* module);
extern int curs_set_term(Context* cx, Node* goalscar, List* module);
extern int curs_setcchar(Context* cx, Node* goalscar, List* module);
extern int curs_setscrreg(Context* cx, Node* goalscar, List* module);
extern int curs_setsyx(Context* cx, Node* goalscar, List* module);
extern int curs_setterm(Context* cx, Node* goalscar, List* module);
extern int curs_setupterm(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attr(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attr_off(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attr_on(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attr_set(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attroff(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attron(Context* cx, Node* goalscar, List* module);
extern int curs_slk_attrset(Context* cx, Node* goalscar, List* module);
extern int curs_slk_clear(Context* cx, Node* goalscar, List* module);
extern int curs_slk_color(Context* cx, Node* goalscar, List* module);
extern int curs_slk_init(Context* cx, Node* goalscar, List* module);
extern int curs_slk_label(Context* cx, Node* goalscar, List* module);
extern int curs_slk_noutrefresh(Context* cx, Node* goalscar, List* module);
extern int curs_slk_refresh(Context* cx, Node* goalscar, List* module);
extern int curs_slk_restore(Context* cx, Node* goalscar, List* module);
extern int curs_slk_set(Context* cx, Node* goalscar, List* module);
extern int curs_slk_touch(Context* cx, Node* goalscar, List* module);
extern int curs_standend(Context* cx, Node* goalscar, List* module);
extern int curs_standout(Context* cx, Node* goalscar, List* module);
extern int curs_start_color(Context* cx, Node* goalscar, List* module);
extern int curs_subpad(Context* cx, Node* goalscar, List* module);
extern int curs_subwin(Context* cx, Node* goalscar, List* module);
extern int curs_syncok(Context* cx, Node* goalscar, List* module);
extern int curs_term_attrs(Context* cx, Node* goalscar, List* module);
extern int curs_termattrs(Context* cx, Node* goalscar, List* module);
extern int curs_termname(Context* cx, Node* goalscar, List* module);
extern int curs_tgetent(Context* cx, Node* goalscar, List* module);
extern int curs_tgetflag(Context* cx, Node* goalscar, List* module);
extern int curs_tgetnum(Context* cx, Node* goalscar, List* module);
extern int curs_tgetstr(Context* cx, Node* goalscar, List* module);
extern int curs_tgoto(Context* cx, Node* goalscar, List* module);
extern int curs_tigetflag(Context* cx, Node* goalscar, List* module);
extern int curs_tigetnum(Context* cx, Node* goalscar, List* module);
extern int curs_tigetstr(Context* cx, Node* goalscar, List* module);
extern int curs_timeout(Context* cx, Node* goalscar, List* module);
extern int curs_touchline(Context* cx, Node* goalscar, List* module);
extern int curs_touchwin(Context* cx, Node* goalscar, List* module);
extern int curs_tparm(Context* cx, Node* goalscar, List* module);
extern int curs_tputs(Context* cx, Node* goalscar, List* module);
extern int curs_tputs(Context* cx, Node* goalscar, List* module);
extern int curs_trace(Context* cx, Node* goalscar, List* module);
extern int curs_typeahead(Context* cx, Node* goalscar, List* module);
extern int curs_unctrl(Context* cx, Node* goalscar, List* module);
extern int curs_unget_wch(Context* cx, Node* goalscar, List* module);
extern int curs_ungetch(Context* cx, Node* goalscar, List* module);
extern int curs_ungetmouse(Context* cx, Node* goalscar, List* module);
extern int curs_untouchwin(Context* cx, Node* goalscar, List* module);
extern int curs_use_default_colors(Context* cx, Node* goalscar, List* module);
extern int curs_use_env(Context* cx, Node* goalscar, List* module);
extern int curs_use_extended_names(Context* cx, Node* goalscar, List* module);
extern int curs_vid_attr(Context* cx, Node* goalscar, List* module);
extern int curs_vid_puts(Context* cx, Node* goalscar, List* module);
extern int curs_vidattr(Context* cx, Node* goalscar, List* module);
extern int curs_vidputs(Context* cx, Node* goalscar, List* module);
extern int curs_vline(Context* cx, Node* goalscar, List* module);
extern int curs_vline_set(Context* cx, Node* goalscar, List* module);
extern int curs_vw_printw(Context* cx, Node* goalscar, List* module);
extern int curs_vw_scanw(Context* cx, Node* goalscar, List* module);
extern int curs_vwprintw(Context* cx, Node* goalscar, List* module);
extern int curs_vwscanw(Context* cx, Node* goalscar, List* module);
extern int curs_wadd_wch(Context* cx, Node* goalscar, List* module);
extern int curs_wadd_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_wadd_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddch(Context* cx, Node* goalscar, List* module);
extern int curs_waddchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddchstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddnstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddstr(Context* cx, Node* goalscar, List* module);
extern int curs_waddwstr(Context* cx, Node* goalscar, List* module);
extern int curs_wattr_get(Context* cx, Node* goalscar, List* module);
extern int curs_wattr_off(Context* cx, Node* goalscar, List* module);
extern int curs_wattr_on(Context* cx, Node* goalscar, List* module);
extern int curs_wattr_set(Context* cx, Node* goalscar, List* module);
extern int curs_wattroff(Context* cx, Node* goalscar, List* module);
extern int curs_wattron(Context* cx, Node* goalscar, List* module);
extern int curs_wattrset(Context* cx, Node* goalscar, List* module);
extern int curs_wbkgd(Context* cx, Node* goalscar, List* module);
extern int curs_wbkgdset(Context* cx, Node* goalscar, List* module);
extern int curs_wbkgrnd(Context* cx, Node* goalscar, List* module);
extern int curs_wbkgrndset(Context* cx, Node* goalscar, List* module);
extern int curs_wborder(Context* cx, Node* goalscar, List* module);
extern int curs_wborder_set(Context* cx, Node* goalscar, List* module);
extern int curs_wchgat(Context* cx, Node* goalscar, List* module);
extern int curs_wclear(Context* cx, Node* goalscar, List* module);
extern int curs_wclrtobot(Context* cx, Node* goalscar, List* module);
extern int curs_wclrtoeol(Context* cx, Node* goalscar, List* module);
extern int curs_wcolor_set(Context* cx, Node* goalscar, List* module);
extern int curs_wcursyncup(Context* cx, Node* goalscar, List* module);
extern int curs_wdelch(Context* cx, Node* goalscar, List* module);
extern int curs_wdeleteln(Context* cx, Node* goalscar, List* module);
extern int curs_wecho_wchar(Context* cx, Node* goalscar, List* module);
extern int curs_wechochar(Context* cx, Node* goalscar, List* module);
extern int curs_wenclose(Context* cx, Node* goalscar, List* module);
extern int curs_werase(Context* cx, Node* goalscar, List* module);
extern int curs_wget_wch(Context* cx, Node* goalscar, List* module);
extern int curs_wget_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_wgetbkgrnd(Context* cx, Node* goalscar, List* module);
extern int curs_wgetch(Context* cx, Node* goalscar, List* module);
extern int curs_wgetn_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_wgetnstr(Context* cx, Node* goalscar, List* module);
extern int curs_wgetstr(Context* cx, Node* goalscar, List* module);
extern int curs_whline(Context* cx, Node* goalscar, List* module);
extern int curs_whline_set(Context* cx, Node* goalscar, List* module);
extern int curs_win_wch(Context* cx, Node* goalscar, List* module);
extern int curs_win_wchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_win_wchstr(Context* cx, Node* goalscar, List* module);
extern int curs_winch(Context* cx, Node* goalscar, List* module);
extern int curs_winchnstr(Context* cx, Node* goalscar, List* module);
extern int curs_winchstr(Context* cx, Node* goalscar, List* module);
extern int curs_winnstr(Context* cx, Node* goalscar, List* module);
extern int curs_winnwstr(Context* cx, Node* goalscar, List* module);
extern int curs_wins_nwstr(Context* cx, Node* goalscar, List* module);
extern int curs_wins_wch(Context* cx, Node* goalscar, List* module);
extern int curs_wins_wstr(Context* cx, Node* goalscar, List* module);
extern int curs_winsch(Context* cx, Node* goalscar, List* module);
extern int curs_winsdelln(Context* cx, Node* goalscar, List* module);
extern int curs_winsertln(Context* cx, Node* goalscar, List* module);
extern int curs_winsnstr(Context* cx, Node* goalscar, List* module);
extern int curs_winsstr(Context* cx, Node* goalscar, List* module);
extern int curs_winstr(Context* cx, Node* goalscar, List* module);
extern int curs_winwstr(Context* cx, Node* goalscar, List* module);
extern int curs_wmouse_trafo(Context* cx, Node* goalscar, List* module);
extern int curs_wmove(Context* cx, Node* goalscar, List* module);
extern int curs_wnoutrefresh(Context* cx, Node* goalscar, List* module);
extern int curs_wprintw(Context* cx, Node* goalscar, List* module);
extern int curs_wredrawln(Context* cx, Node* goalscar, List* module);
extern int curs_wrefresh(Context* cx, Node* goalscar, List* module);
extern int curs_wresize(Context* cx, Node* goalscar, List* module);
extern int curs_wscanw(Context* cx, Node* goalscar, List* module);
extern int curs_wscrl(Context* cx, Node* goalscar, List* module);
extern int curs_wsetscrreg(Context* cx, Node* goalscar, List* module);
extern int curs_wstandend(Context* cx, Node* goalscar, List* module);
extern int curs_wstandout(Context* cx, Node* goalscar, List* module);
extern int curs_wsyncdown(Context* cx, Node* goalscar, List* module);
extern int curs_wsyncup(Context* cx, Node* goalscar, List* module);
extern int curs_wtimeout(Context* cx, Node* goalscar, List* module);
extern int curs_wtouchln(Context* cx, Node* goalscar, List* module);
extern int curs_wunctrl(Context* cx, Node* goalscar, List* module);
extern int curs_wvline(Context* cx, Node* goalscar, List* module);
extern int curs_wvline_set(Context* cx, Node* goalscar, List* module);

extern int curs_COLS(Context* cx, Node* goalscar, List* module);
extern int curs_LINES(Context* cx, Node* goalscar, List* module);

#endif
