/*
 * nwc lexical code operation
 *
 *			(c) H.Niwa 1993
 */

#ifndef __NWCCLEX_H
#define __NWCCLEX_H

#ifndef MAXPATHLEN
#define MAXPATHLEN  (4096)
#endif

#define	TOKEN_LEN	4096

extern const char* MESG;

extern long FilePointSave();
extern void FilePointResume(long tellpt);
extern int  NotSkipSpCOMP(const char* Pt);
extern int  COMP(const char* Pt);
extern int  LineNumber();
extern void ErrorStop(const char* fmt, ...);
extern void UNTIL(const char* s);
extern void SKIP(const char* s);
extern int  NotSkipSpNOT(const char* s);
extern int  NOT(const char* s);
extern int  C();
extern int  Eof();
extern int  NotEof();
extern int  N();
extern int  J();
extern int  A();
extern int  AN();
extern int  SPACE();
extern int  JA();
extern int  ANY();
extern int  WRD();
extern int  NUM();
extern int  ID();
extern int  CSTRINGS();
extern int  STRINGS();
extern int  CR();

void SetToken(int c);
void SkipSpace();

#endif  /* __NWCCLEX_H */
