/*
 * check reseved words program copyright (C) 2009 - 2013 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <errno.h>
#include <setjmp.h>
#include <sys/time.h>
#include <math.h>
#include <libgen.h>
#include <setjmp.h>

#include <string>
#include <complex>

#include "syserr.h"

const char* ReservedWords[] = {
	"true",
	"false",
	"unknow",
	"!",
	"break",
	"brk",
	"help",
	"opcall",
	"module",
	"list",
	"bye",
	"quit",
	"exit",
	"new",
	"eval",
	"x",
	"nop",
	"print",
	"printf",
	"printlist",
	"printlistnl",
	"is",
	"eq",
	"noteq",
	"warn",
	"include",
	"load",
	"save",
	"edit",
	"cd",
	"pwd",
	"dir",
	"ls",
	"quote",
	"*",
	"%",
	"\\",
	"obj",
	"unify",
	"timeout",
	"loop",
	"alt",
	"for",
	"foreach",
	"firstfor",
	"firstforeach",
	"map",
	"findall",
	"or",
	"not",
	"tron",
	"troff",
	"let",
	"letf",
	"letc",
	"rpnf",
	"rpnc",
	"rpn",
	"func",
	"f",
	"comparef",
	"compare",
	"TOKEN",
	"SKIPSPACE",
	"C",
	"N",
	"A",
	"AN",
	"^",
	"$",
	"CR",
	"CNTL",
	"EOF",
	"SPACE",
	"PUNCT",
	"STRINGS",
	"WORD",
	"NUM",
	"FNUM",
	"SNUM",
	"SFNUM",
	"ID",
	"RANGE",
	"NONRANGE",
	"GETTOKEN",
	"SKIP",
	"SKIPCR",
	"NULLLINE",
	"NEXTCHAR",
	"NEXTSTR",
	"NOTNEXTSTR",
	"NEXTSYNTAX",
	"NOTNEXTSYNTAX",
	"INDENT",
	"NEXTINDENT",
	"asserta",
	"assertz",
	"assert",
	"erase",
	"retract",
	"retractpred",
	"newObj",
	"cloneObj",
	"delObj",
	"objName",
	"self",
	"super",
	"setVar",
	"setArray",
	"getVar",
	"getArray",
	"delVar",
	"delArray",
	"newproc",
	"eachproc",
	"firstnewproc",
	"firsteachproc",
	"catch",
	"throw",
	"catch_sigint",
};

const char* SysWords[] = {
	"args",
	"DLIBPATH",
	"PrintResultOn",
	"PrintResultOff",
	"cutall",
	"mkpred",
	"mkpredlist",
	"writenl",
	"writeln",
	"print",
	"write",
	"isNil",
	"isAtom",
	"isList",
	"isPred",
	"isVar",
	"isUndefVar",
	"isFloat",
	"isInteger",
	"isInf",
	"isNan",
	"finte",
	"isTrue",
	"isFalse",
	"isUnknown",
	"isRegistered",
	"isUnregistered",
	"isObj",
	"max",
	"min",
	"maxf",
	"minf",
	"sum",
	"sumf",
	"avg",
	"avgf",
	"regex",
	"sub",
	"gsub",
	"split",
	"splitstr",
	"splitline",
	"toupper",
	"tolower",
	"length",
	"random",
	"real",
	"image",
	"arg",
	"norm",
	"conj",
	"polar",
	"sin",
	"cos",
	"tan",
	"asin",
	"acos",
	"atan",
	"atan2",
	"sinh",
	"cosh",
	"tanh",
	"asinh",
	"acosh",
	"atanh",
	"log",
	"log10",
	"exp",
	"exp2",
	"exp10",
	"pow",
	"sqrt",
	"abs",
	"sin",
	"cos",
	"tan",
	"asin",
	"acos",
	"atan",
	"atan2",
	"sinh",
	"cosh",
	"tanh",
	"asinh",
	"acosh",
	"atanh",
	"log",
	"log10",
	"exp",
	"exp2",
	"exp10",
	"pow",
	"sqrt",
	"abs",
	"PI",
	"e",
	"int",
	"floor",
	"ceil",
	"trunc",
	"car",
	"cdr",
	"caar",
	"cadr",
	"cdar",
	"cddr",
	"caaar",
	"caadr",
	"cadar",
	"caddr",
	"cdaar",
	"cdadr",
	"cddar",
	"cdddr",
	"caaaar",
	"caaadr",
	"caadar",
	"caaddr",
	"cadaar",
	"cadadr",
	"caddar",
	"cadddr",
	"cdaaar",
	"cdaadr",
	"cdadar",
	"cdaddr",
	"cddaar",
	"cddadr",
	"cdddar",
	"cddddr",
	"cons",
	"nth",
	"setnth",
	"code",
	"char",
	"byte",
	"asciichar",
	"utf8char",
	"eucchar",
	"sjischar",
	"concat",
	"concatcode",
	"leftstr",
	"rightstr",
	"substr",
	"insertstr",
	"replacestr",
	"bitand",
	"bitor",
	"bitxor",
	"bitnot",
	"shiftl",
	"shiftr",
	"eq",
	"noteq",
	"is",
	"EqOR",
	"switch",
	"getc",
	"putc",
	"getline",
	"syntax",
	"tmpfile",
	"line",
	"flush",
	"openr",
	"openw",
	"openwp",
	"gettime",
	"time",
	"date",
	"sleep",
	"usleep",
	"pause",
	"basename",
	"dirname",
	"suffix",
	"clear",
	"uname",
	"sort",
	"sortascend",
	"sortdescend",
	"findlist",
	"trim",
	"lefttrim",
	"righttrim",
	"chop",
	"chomp",
	"strreverse",
	"strrepeat",
	"strshiftright",
	"strshiftleft",
	"strrotateright",
	"strrotateleft",
	"strsort",
	"strsortreverse",
	"strlen",
	"strbyte",
	"strfry",
	"strdelcntl",
	"seq",
	"padding",
	"CRLF2LF",
	"LF2CRLF",
	"append",
	"reverse",
	"member",
	"checkObj",
	"getenv",
	"urlencode",
	"urldecode",
	"htmlencode",
	"htmldecode",
	"htmlsection",
	"htmltags",
	"erasealltags",
	"erasetags",
	"eraseCommenttags",
	"splittags",
	"pulloutstr",
	"erasestr",
	"fileget",
	"httpget",
	"httphead",
	"httppost",
	"strcode",
	"iconv",
	"readCSV",
	"writeCSV",
	"readFile",
	"writeFile",
	"readRecord",
	"writeRecord",
	"flatten",
	"CHECKSRC",
	"countnode",
	"gc",
};

int CheckReserved(const char* s)
{
	int len = (sizeof ReservedWords)/(sizeof (char*));
	int i;
	std::string s1, s2;

	s1 = s;
	for (i = 0; i < len; i++) {
		s2 = ReservedWords[i];
		if (s1 == s2) {
			syserr("%s is reserved word. please, use other words. \n", s);
			return 1;
		}
	}
	return 0;

}

int NumOfReserved()
{
	return (sizeof ReservedWords)/(sizeof (char*));
}

int NumOfSysmod()
{
	return (sizeof SysWords)/(sizeof (char*));
}

