/*
 * Regular Expression program copyright (C) 2009 - 2013 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>

#if HAVE_REGEX_H
#include <regex.h>
#endif /* HAVE_REGEX_H */

#include <string>
#include <complex>

#include "syserr.h"

#include "regexheader.h"


#if HAVE_REGEX_H
int Regex(std::string ptn, std::string str, 
		std::string& forestr, std::string& matchstr, 
			std::string& reststr)
{
	int	r;
	regex_t	reg;
	regmatch_t match[1];

	matchstr = "";

	if ((r = regcomp(&reg, ptn.c_str(), REG_EXTENDED)) != 0) {
/*
		char errbuf[1024];
		regerror(r, &reg, errbuf, 1024-1);
		fprintf(stderr, "regcomp %d : %s\n", r, errbuf);
*/
		return -1;
	}
	
	r =  regexec(&reg, str.c_str(), 1, match, 0);
	regfree(&reg);

	if (r != 0) {
		forestr = "";
		matchstr = "";
		reststr = str;

		char errbuf[256];
		regerror(r, &reg, errbuf, 256-1);
		
		if (r == REG_NOMATCH) {
			return 0;
		} else {
			syserr("regex: execution error. \n %s \n", errbuf);
			return 0;
		}
	}

	forestr = str.substr(0, match[0].rm_so);
	matchstr = str.substr(match[0].rm_so, match[0].rm_eo-match[0].rm_so);
	reststr = str.substr(match[0].rm_eo, str.length());
	
	return 1;
}

int RegexSub(std::string ptn, std::string str, 
		std::string& forestr, std::string& matchstr, 
			std::string& reststr)
{
	int	r;
	regex_t	reg;
	regmatch_t match[1];

	matchstr = "";

	if ((r = regcomp(&reg, ptn.c_str(), REG_EXTENDED)) != 0) {
		return 0;
	}
	
	r =  regexec(&reg, str.c_str(), 1, match, 0);
	regfree(&reg);

	if (r != 0) {
		forestr = "";
		matchstr = "";
		reststr = str;
		return 0;
	}

	forestr = str.substr(0, match[0].rm_so);
	matchstr = str.substr(match[0].rm_so, match[0].rm_eo-match[0].rm_so);
	reststr = str.substr(match[0].rm_eo, str.length());
	
	return 1;
}

int Sub(std::string ptn, std::string str, 
		std::string replacestr, std::string& outputstr)
{
	std::string fore, match, rest;
	int r;
	
	if (r = RegexSub(ptn, str, fore, match, rest)) {
//printf("Sub Regex fore %s match %s rest %s \n", fore.c_str(), match.c_str(), rest.c_str());
		outputstr = fore + replacestr + rest;
		return 1;
	} else {
		outputstr = str;
		return -1;
	}
}

int GSub(std::string ptn, std::string str, 
		std::string replacestr, std::string& outputstr)
{
	std::string fore, match, rest, output;
	int r;
	
	if (r = RegexSub(ptn, str, fore, match, rest)) {
//printf("GSub Regex fore %s match %s rest %s \n", fore.c_str(), match.c_str(), rest.c_str());

		if (str == rest) {
			outputstr = str;
			return 1;
		}
		
		GSub(ptn, rest, replacestr, output); 
		outputstr = fore + replacestr + output;
		return 1;
	} else {
		outputstr = str;
		return 1;
	}
}

int GrepStr(std::string &ptn, std::string &str)
{
	std::string forestr="",  matchstr="", reststr="";
	int r = Regex(ptn, str, forestr, matchstr, reststr);

	return r;
}

int Grep_iStr(std::string ptn, std::string str)
{
	extern void str_tolower(std::string &str);

	str_tolower(ptn);
	str_tolower(str);
	
	std::string forestr="",  matchstr="", reststr="";
	int r = Regex(ptn, str, forestr, matchstr, reststr);

	return r;
}

int Grep_vStr(std::string &ptn, std::string &str)
{
	std::string forestr="",  matchstr="", reststr="";
	int r = Regex(ptn, str, forestr, matchstr, reststr);
	if (r == 1) {
		return -1;
	} else {
		return 1;
	}
}

#endif /* HAVE_REGEX_H */
