/*
 * sleep program copyright (C) 2009 - 2013 H.Niwa
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include "sleep.h"

#ifdef __MINGW32__

#include<windows.h>

void CallSleep(long long n)
{
	Sleep(n*1000);
}

void CalluSleep(long long n)
{
	Sleep(n/1000);
}


#else 

#include <unistd.h>

void CallSleep(long long n)
{
	sleep(n);
}

void CalluSleep(long long n)
{
	usleep(n);
}

#endif

