/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.data;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.data.GraphDataCellListener;
import java.util.Vector;

public class GraphDataCell {
    private float theValue;
    private Vector graphDataListeners = new Vector();
    private boolean isSelected = false;
    private float oldValue;
    private int x;
    private int z;
    private float tempValue;

    public GraphDataCell(float value, int x, int z) {
        this.x = x;
        this.z = z;
        if ((double)value < GraphData.getMinY()) {
            value = (float)GraphData.getMinY();
        }
        if ((double)value > GraphData.getMaxY()) {
            value = (float)GraphData.getMaxY();
        }
        this.theValue = value;
        this.oldValue = value;
        this.tempValue = value;
    }

    public void updateValue(float value, int type) {
        if (this.theValue == value) {
            return;
        }
        if ((double)value < GraphData.getMinY()) {
            value = (float)GraphData.getMinY();
        }
        if ((double)value > GraphData.getMaxY()) {
            value = (float)GraphData.getMaxY();
        }
        this.oldValue = this.theValue;
        if (type == GraphData.REPLACE) {
            this.theValue = value;
        }
        if (type == GraphData.INCRIMENT) {
            this.theValue += value;
        }
        this.tempValue = value;
        this.notifyListeners(type);
    }

    private void notifyListeners(int type) {
        for (GraphDataCellListener listener : this.graphDataListeners) {
            listener.graphDataChanged(this.theValue, 1, type);
        }
    }

    public void setSelected(boolean value) {
        this.isSelected = value;
        for (GraphDataCellListener listener : this.graphDataListeners) {
            listener.selectStateChanged(value);
        }
    }

    public void flipSelected() {
        if (this.isSelected) {
            this.setSelected(false);
        } else {
            this.setSelected(true);
        }
    }

    public void applyTempValue(int type) {
        this.updateValue(this.tempValue, type);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public float getOldValue() {
        return this.oldValue;
    }

    public float getTempValue() {
        return this.tempValue;
    }

    public void setTempValue(float tempValue) {
        this.tempValue = tempValue;
    }

    public GraphDataCell(GraphDataCellListener listener) {
        this.graphDataListeners.add(listener);
    }

    public void addDataListener(GraphDataCellListener listener) {
        this.graphDataListeners.add(listener);
    }

    public Vector getListeners() {
        return this.graphDataListeners;
    }

    public boolean getSelected() {
        return this.isSelected;
    }

    public float getValue() {
        return this.theValue;
    }
}

