/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.graph3dTG;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.graph3dTG.Graph3dFrame;
import com.ecm.graphics.render.flatFaceRender.ValuePlane;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class Graph3dTransformGroup
extends TransformGroup {
    private Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    private Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
    private Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    private Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    private Color3f labelColor = new Color3f(1.0f, 0.0f, 0.0f);
    private int xWidth = 0;
    private int zDepth = 0;
    private float fudgedScaleYMax;
    private float fudgedScaleYMin;
    private float percentScale;
    private ValuePlane[][] faces;
    private String xAxes = "";
    private String yAxes = "";
    private String zAxes = "";
    private double[] xAxesVals;
    private double[] zAxesVals;
    public Vector modifiedDataListeners = new Vector();
    private LinkedHashMap tempFaceHash = new LinkedHashMap();

    public Graph3dTransformGroup() {
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
    }

    public void Init(double graphMinY, double graphMaxY, double[] xAxesVals, double[] zAxesVals, String xAxes, String yAxes, String zAxes, TransformGroup renderTG) {
        this.xAxesVals = xAxesVals;
        this.zAxesVals = zAxesVals;
        this.xAxes = xAxes;
        this.yAxes = yAxes;
        this.zAxes = zAxes;
        this.xWidth = GraphData.getXWidth();
        this.zDepth = GraphData.getZDepth();
        this.percentScale = (float)((double)((this.xWidth + this.zDepth) / 2) / GraphData.getHeight()) / 4.0f;
        this.fudgedScaleYMax = (float)GraphData.getMaxY() * this.percentScale;
        this.fudgedScaleYMin = (float)GraphData.getMinY() * this.percentScale;
        this.removeAllChildren();
        Transform3D myTransform3D = new Transform3D();
        float scale = 1.35f / (float)((GraphData.getXWidth() + GraphData.getZDepth()) / 2);
        float maxY = scale * this.getMaxCalc3dWorldHeight();
        float maxX = scale * (float)GraphData.getXWidth();
        float maxZ = scale * (float)GraphData.getZDepth();
        myTransform3D.setScale((double)scale);
        myTransform3D.setTranslation(new Vector3f(-maxX / 2.0f, -maxY / 2.0f, maxZ / 2.0f));
        TransformGroup trans3dtg = new TransformGroup(myTransform3D);
        trans3dtg.setCapability(12);
        BranchGroup totalBG = new BranchGroup();
        totalBG.setCapability(17);
        trans3dtg.addChild((Node)renderTG);
        trans3dtg.addChild((Node)new Graph3dFrame(this.fudgedScaleYMin, this.fudgedScaleYMax, xAxesVals, zAxesVals, xAxes, yAxes, zAxes));
        totalBG.addChild((Node)trans3dtg);
        this.addChild((Node)totalBG);
    }

    public int getXWidth() {
        return this.xWidth;
    }

    public int getZDepth() {
        return this.zDepth;
    }

    public float getMaxCalc3dWorldHeight() {
        return this.fudgedScaleYMax;
    }

    public String getXAxes() {
        return this.xAxes;
    }

    public void setXAxes(String axes) {
        this.xAxes = axes;
    }

    public String getYAxes() {
        return this.yAxes;
    }

    public void setYAxes(String axes) {
        this.yAxes = axes;
    }

    public String getZAxes() {
        return this.zAxes;
    }

    public void setZAxes(String axes) {
        this.zAxes = axes;
    }

    public ValuePlane getValuePlane(int xCoord, int zCoord) {
        return this.faces[xCoord][zCoord];
    }
}

