/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.tools;

import java.awt.Color;
import javax.vecmath.Color3f;

public class ColorTable {
    private static double min;
    private static double max;

    public static void initColorTable(double minA, double maxA) {
        min = minA;
        max = maxA;
    }

    public static Color3f getColor(double value) {
        float range = (float)(max - min);
        float length = (float)(value - min);
        float percent = length / range;
        Color maxColor = new Color(255, 102, 102);
        Color minColor = new Color(153, 153, 255);
        float[] minColorHSB = new float[3];
        float[] maxColorHSB = new float[3];
        Color.RGBtoHSB(minColor.getRed(), minColor.getGreen(), minColor.getBlue(), minColorHSB);
        Color.RGBtoHSB(maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue(), maxColorHSB);
        float h = minColorHSB[0] + (maxColorHSB[0] - minColorHSB[0]) * percent;
        float s = minColorHSB[1] + (maxColorHSB[1] - minColorHSB[1]) * percent;
        float b = minColorHSB[2] + (maxColorHSB[2] - minColorHSB[2]) * percent;
        Color newColor = Color.getHSBColor(h, s, b);
        return ColorTable.ColorToColor3f(newColor);
    }

    private static Color3f ColorToColor3f(Color theColor) {
        float x = ColorTable.convertToFloat(theColor.getRed());
        float y = ColorTable.convertToFloat(theColor.getGreen());
        float z = ColorTable.convertToFloat(theColor.getBlue());
        Color3f returnColor3f = new Color3f(x, y, z);
        return returnColor3f;
    }

    private static Color Color3fToColor(Color3f theColor) {
        int x = ColorTable.convertToInt(theColor.x);
        int y = ColorTable.convertToInt(theColor.y);
        int z = ColorTable.convertToInt(theColor.z);
        Color returnColor3f = new Color(x, y, z);
        return returnColor3f;
    }

    private static int convertToInt(float value) {
        int retValue = (int)(255.0f * value);
        return retValue;
    }

    private static float convertToFloat(float value) {
        float retValue = value / 255.0f;
        return retValue;
    }

    public static Color3f getSelectedColor() {
        return ColorTable.ColorToColor3f(new Color(204, 204, 204));
    }
}

