/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.j2534.op20;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import com.romraider.util.ByteUtil;
import java.io.File;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public final class J2534DllLocator {
    private static final Logger LOGGER = Logger.getLogger(J2534DllLocator.class);

    private J2534DllLocator() {
    }

    public static File locate() {
        try {
            RegistryKey registryKey = Registry.openSubkey((RegistryKey)Registry.HKEY_LOCAL_MACHINE, (String)"SOFTWARE", (int)1);
            RegistryKey registryKey2 = registryKey.openSubKey("PassThruSupport.04.04");
            Enumeration enumeration = registryKey2.keyElements();
            while (enumeration.hasMoreElements()) {
                File file;
                String string = (String)enumeration.nextElement();
                RegistryKey registryKey3 = registryKey2.openSubKey(string);
                if (!J2534DllLocator.valueExists(registryKey3, "ISO9141", 4) || J2534DllLocator.dwordValue(registryKey3, "ISO9141") != 1 || !J2534DllLocator.valueExists(registryKey3, "FunctionLibrary", 1) || !(file = new File(J2534DllLocator.stringValue(registryKey3, "FunctionLibrary"))).exists()) continue;
                return file;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.info((Object)("Error determining J2534 library location: " + exception.getMessage()));
            return null;
        }
    }

    private static String stringValue(RegistryKey registryKey, String string) throws RegistryException {
        byte[] byArray = J2534DllLocator.valueOf(registryKey, string);
        return new String(byArray);
    }

    private static int dwordValue(RegistryKey registryKey, String string) throws RegistryException {
        byte[] byArray = J2534DllLocator.valueOf(registryKey, string);
        return ByteUtil.asUnsignedInt(byArray);
    }

    private static byte[] valueOf(RegistryKey registryKey, String string) throws RegistryException {
        RegistryValue registryValue = registryKey.getValue(string);
        return registryValue.getByteData();
    }

    public static boolean valueExists(RegistryKey registryKey, String string, int n) {
        try {
            Enumeration enumeration = registryKey.valueElements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equals(string)) continue;
                RegistryValue registryValue = registryKey.getValue(string2);
                return registryValue.getType() == n;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

