/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.protocol.ssm;

import com.romraider.io.protocol.ssm.SSMChecksumCalculator;
import com.romraider.logger.ecu.exception.InvalidResponseException;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;

public final class SSMResponseProcessor {
    private SSMResponseProcessor() {
        throw new UnsupportedOperationException();
    }

    public static byte[] filterRequestFromResponse(byte[] byArray, byte[] byArray2) {
        ParamChecker.checkNotNull((Object)byArray, "request");
        ParamChecker.checkNotNullOrEmpty(byArray2, "response");
        byte[] byArray3 = new byte[byArray2.length - byArray.length];
        System.arraycopy(byArray2, byArray.length, byArray3, 0, byArray3.length);
        return byArray3;
    }

    public static void validateResponse(byte[] byArray) {
        int n = 0;
        SSMResponseProcessor.assertTrue(byArray.length > 6, "Invalid response length");
        SSMResponseProcessor.assertEquals((byte)-128, byArray[n++], "Invalid header");
        SSMResponseProcessor.assertEquals((byte)-16, byArray[n++], "Invalid diagnostic tool id");
        SSMResponseProcessor.assertEquals((byte)16, byArray[n++], "Invalid ECU id");
        SSMResponseProcessor.assertEquals(ByteUtil.asByte(byArray.length - 6 + 1), byArray[n++], "Invalid response data length");
        SSMResponseProcessor.assertOneOf(new byte[]{-1, -24, -32, -8, -16}, byArray[n], "Invalid response code");
        SSMResponseProcessor.assertEquals(SSMChecksumCalculator.calculateChecksum(byArray), byArray[byArray.length - 1], "Invalid checksum");
    }

    public static byte[] extractResponseData(byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(byArray, "response");
        SSMResponseProcessor.validateResponse(byArray);
        byte[] byArray2 = new byte[byArray.length - 6];
        System.arraycopy(byArray, 5, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new InvalidResponseException(string);
        }
    }

    private static void assertEquals(byte by, byte by2, String string) {
        if (by2 != by) {
            throw new InvalidResponseException(string + ". Expected: " + HexUtil.asHex(new byte[]{by}) + ". Actual: " + HexUtil.asHex(new byte[]{by2}) + ".");
        }
    }

    private static void assertOneOf(byte[] byArray, byte by, String string) {
        for (byte by2 : byArray) {
            if (by2 != by) continue;
            return;
        }
        Object object = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(HexUtil.asHex(new byte[]{byArray[i]}));
        }
        throw new InvalidResponseException(string + ". Expected one of [" + ((StringBuilder)object).toString() + "]. Actual: " + HexUtil.asHex(new byte[]{by}) + ".");
    }
}

