/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.serial.connection;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.serial.connection.SerialConnection;
import com.romraider.logger.ecu.exception.NotConnectedException;
import com.romraider.logger.ecu.exception.PortNotFoundException;
import com.romraider.logger.ecu.exception.SerialCommunicationException;
import com.romraider.logger.ecu.exception.UnsupportedPortTypeException;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public final class SerialConnectionImpl
implements SerialConnection {
    private static final Logger LOGGER = Logger.getLogger(SerialConnectionImpl.class);
    private final SerialPort serialPort;
    private final OutputStream os;
    private final InputStream is;

    public SerialConnectionImpl(String string, ConnectionProperties connectionProperties) {
        ParamChecker.checkNotNullOrEmpty(string, "portName");
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        this.serialPort = this.connect(string, connectionProperties);
        this.os = this.initOutputStream();
        this.is = this.initInputStream();
    }

    public void write(byte[] byArray) {
        try {
            this.os.write(byArray, 0, byArray.length);
            this.os.flush();
        }
        catch (IOException iOException) {
            this.close();
            throw new SerialCommunicationException(iOException);
        }
    }

    public int available() {
        try {
            return this.is.available();
        }
        catch (IOException iOException) {
            this.close();
            throw new SerialCommunicationException(iOException);
        }
    }

    public void read(byte[] byArray) {
        try {
            this.is.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            this.close();
            throw new SerialCommunicationException(iOException);
        }
    }

    public byte[] readAvailable() {
        byte[] byArray = new byte[this.available()];
        this.read(byArray);
        return byArray;
    }

    public void readStaleData() {
        if (this.available() <= 0) {
            return;
        }
        byte[] byArray = new byte[this.available()];
        this.read(byArray);
        LOGGER.debug((Object)("Stale data read: " + HexUtil.asHex(byArray)));
    }

    public void close() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error closing output stream", (Throwable)iOException);
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                LOGGER.error((Object)"Error closing input stream", (Throwable)iOException);
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Error closing serial port", (Throwable)exception);
            }
        }
        LOGGER.info((Object)"Connection closed.");
    }

    private OutputStream initOutputStream() {
        try {
            return this.serialPort.getOutputStream();
        }
        catch (IOException iOException) {
            this.close();
            throw new NotConnectedException(iOException);
        }
    }

    private InputStream initInputStream() {
        try {
            return this.serialPort.getInputStream();
        }
        catch (IOException iOException) {
            this.close();
            throw new NotConnectedException(iOException);
        }
    }

    private SerialPort connect(String string, ConnectionProperties connectionProperties) {
        CommPortIdentifier commPortIdentifier = this.resolvePortIdentifier(string);
        SerialPort serialPort = this.openPort(commPortIdentifier, connectionProperties.getConnectTimeout());
        this.initSerialPort(serialPort, connectionProperties.getBaudRate(), connectionProperties.getDataBits(), connectionProperties.getStopBits(), connectionProperties.getParity());
        LOGGER.info((Object)("Connected to: " + string));
        return serialPort;
    }

    private SerialPort openPort(CommPortIdentifier commPortIdentifier, int n) {
        this.checkIsSerialPort(commPortIdentifier);
        try {
            return (SerialPort)commPortIdentifier.open(this.getClass().getName(), n);
        }
        catch (PortInUseException portInUseException) {
            throw new SerialCommunicationException("Port is currently in use: " + commPortIdentifier.getName());
        }
    }

    private void checkIsSerialPort(CommPortIdentifier commPortIdentifier) {
        if (commPortIdentifier.getPortType() != 1) {
            throw new UnsupportedPortTypeException("Port type " + commPortIdentifier.getPortType() + " not supported - must be serial.");
        }
    }

    private void initSerialPort(SerialPort serialPort, int n, int n2, int n3, int n4) {
        try {
            serialPort.setFlowControlMode(0);
            serialPort.setSerialPortParams(n, n2, n3, n4);
            serialPort.disableReceiveTimeout();
            serialPort.setRTS(false);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new UnsupportedOperationException(unsupportedCommOperationException);
        }
    }

    private CommPortIdentifier resolvePortIdentifier(String string) {
        try {
            return CommPortIdentifier.getPortIdentifier((String)string);
        }
        catch (NoSuchPortException noSuchPortException) {
            throw new PortNotFoundException("Unable to resolve port: " + string);
        }
    }
}

