/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.serial.connection;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.protocol.ssm.SSMChecksumCalculator;
import com.romraider.io.serial.connection.SerialConnection;
import com.romraider.logger.ecu.exception.SerialCommunicationException;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import java.util.Random;
import org.apache.log4j.Logger;

final class TestSerialConnection
implements SerialConnection {
    private static final Logger LOGGER = Logger.getLogger(TestSerialConnection.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final String ECU_INIT_RESPONSE_01_UP = "8010F001BF4080F01039FFA21011315258400673FACB842B83FEA800000060CED4FDB060000F200000000000DC0000551E30C0F222000040FB00E1000000000000000059";
    private static final String ECU_INIT_RESPONSE_PRE_01 = "8010F001BF4080F01029FFA1100B195458050561C4EB800808000000000070CE64F8BA080000E00000000000DC0000108000007B";
    private static final String ECU_INIT_RESPONSE = "8010F001BF4080F01039FFA21011315258400673FACB842B83FEA800000060CED4FDB060000F200000000000DC0000551E30C0F222000040FB00E1000000000000000059";
    private byte[] request = new byte[0];

    public TestSerialConnection(String string, ConnectionProperties connectionProperties) {
        ParamChecker.checkNotNullOrEmpty(string, "portName");
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        LOGGER.info((Object)("*** TEST *** Opening connection: " + string));
    }

    public void write(byte[] byArray) {
        this.request = byArray;
    }

    public int available() {
        if (this.isEcuInitRequest()) {
            return HexUtil.asBytes("8010F001BF4080F01039FFA21011315258400673FACB842B83FEA800000060CED4FDB060000F200000000000DC0000551E30C0F222000040FB00E1000000000000000059").length;
        }
        if (this.isReadAddressRequest()) {
            return this.request.length + (6 + this.calculateNumResponseDataBytes());
        }
        if (this.isReadMemoryRequest()) {
            return this.request.length + (6 + ByteUtil.asInt(this.request[9]) + 1);
        }
        if (this.isWriteMemoryRequest()) {
            return this.request.length + (6 + (this.request.length - 6 - 3));
        }
        throw new SerialCommunicationException("*** TEST *** Unsupported request: " + HexUtil.asHex(this.request));
    }

    public void read(byte[] byArray) {
        if (this.isEcuInitRequest()) {
            System.arraycopy(HexUtil.asBytes("8010F001BF4080F01039FFA21011315258400673FACB842B83FEA800000060CED4FDB060000F200000000000DC0000551E30C0F222000040FB00E1000000000000000059"), 0, byArray, 0, byArray.length);
        } else if (this.isIamRequest()) {
            byte[] byArray2 = HexUtil.asBytes("0x80F01006E83F600000000D");
            System.arraycopy(byArray2, 0, byArray, this.request.length, byArray2.length);
        } else if (this.isEngineLoadRequest()) {
            byte[] byArray3 = HexUtil.asBytes("0x80F01006E83EC74A760033");
            System.arraycopy(byArray3, 0, byArray, this.request.length, byArray3.length);
        } else if (this.isReadAddressRequest()) {
            byte[] byArray4 = this.generateResponseData(this.calculateNumResponseDataBytes());
            int n = 0;
            byte[] byArray5 = new byte[6 + this.calculateNumResponseDataBytes()];
            byArray5[n++] = -128;
            byArray5[n++] = -16;
            byArray5[n++] = 16;
            byArray5[n++] = (byte)(1 + byArray4.length);
            byArray5[n++] = -24;
            System.arraycopy(byArray4, 0, byArray5, n, byArray4.length);
            byArray5[n += byArray4.length] = SSMChecksumCalculator.calculateChecksum(byArray5);
            System.arraycopy(this.request, 0, byArray, 0, this.request.length);
            System.arraycopy(byArray5, 0, byArray, this.request.length, byArray5.length);
        } else if (this.isReadMemoryRequest()) {
            byte[] byArray6 = this.generateResponseData(ByteUtil.asInt(this.request[9]) + 1);
            int n = 0;
            byte[] byArray7 = new byte[6 + byArray6.length];
            byArray7[n++] = -128;
            byArray7[n++] = -16;
            byArray7[n++] = 16;
            byArray7[n++] = (byte)(1 + byArray6.length);
            byArray7[n++] = -32;
            System.arraycopy(byArray6, 0, byArray7, n, byArray6.length);
            byArray7[n += byArray6.length] = SSMChecksumCalculator.calculateChecksum(byArray7);
            System.arraycopy(this.request, 0, byArray, 0, this.request.length);
            System.arraycopy(byArray7, 0, byArray, this.request.length, byArray7.length);
        } else if (this.isWriteMemoryRequest()) {
            int n = this.request.length - 6 - 3;
            byte[] byArray8 = new byte[6 + n];
            int n2 = 0;
            byArray8[n2++] = -128;
            byArray8[n2++] = -16;
            byArray8[n2++] = 16;
            byArray8[n2++] = (byte)(n + 1);
            byArray8[n2++] = -16;
            System.arraycopy(this.request, 8, byArray8, n2, n);
            byArray8[n2 += n] = SSMChecksumCalculator.calculateChecksum(byArray8);
            System.arraycopy(this.request, 0, byArray, 0, this.request.length);
            System.arraycopy(byArray8, 0, byArray, this.request.length, byArray8.length);
        } else {
            throw new SerialCommunicationException("*** TEST *** Unsupported request: " + HexUtil.asHex(this.request));
        }
        ThreadUtil.sleep(200L);
    }

    public byte[] readAvailable() {
        byte[] byArray = new byte[this.available()];
        this.read(byArray);
        return byArray;
    }

    public void readStaleData() {
    }

    public void close() {
        LOGGER.info((Object)"*** TEST *** Connection closed.");
    }

    private int calculateNumResponseDataBytes() {
        return (this.request.length - 7) / 3 * 1;
    }

    private boolean isIamRequest() {
        String string = HexUtil.asHex(this.request);
        return string.startsWith("8010F011A8") && string.contains("FF8228FF8229FF822AFF822B");
    }

    private boolean isEngineLoadRequest() {
        String string = HexUtil.asHex(this.request);
        return string.startsWith("8010F011A8") && string.contains("FFA6FCFFA6FDFFA6FEFFA6FF");
    }

    private byte[] generateResponseData(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)RANDOM.nextInt(255);
        }
        return byArray;
    }

    private boolean isEcuInitRequest() {
        byte by = -65;
        return this.isCommand(by);
    }

    private boolean isReadAddressRequest() {
        return this.isCommand((byte)-88);
    }

    private boolean isReadMemoryRequest() {
        return this.isCommand((byte)-96);
    }

    private boolean isWriteMemoryRequest() {
        return this.isCommand((byte)-80);
    }

    private boolean isCommand(byte by) {
        return this.request[4] == by;
    }
}

