/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.aem.io;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.serial.connection.SerialConnection;
import com.romraider.io.serial.connection.SerialConnectionImpl;
import com.romraider.logger.aem.io.AemConnection;
import com.romraider.logger.ecu.exception.SerialCommunicationException;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AemConnectionImpl
implements AemConnection {
    private static final Logger LOGGER = Logger.getLogger(AemConnectionImpl.class);
    private final SerialConnection connection;
    private final long sendTimeout;

    public AemConnectionImpl(String string, ConnectionProperties connectionProperties) {
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        ParamChecker.checkNotNullOrEmpty(string, "portName");
        this.sendTimeout = connectionProperties.getSendTimeout();
        this.connection = new SerialConnectionImpl(string, connectionProperties);
        LOGGER.info((Object)"AEM connected");
    }

    @Override
    public byte[] read() {
        try {
            this.connection.readStaleData();
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l <= this.sendTimeout) {
                if (this.connection.available() > 10) {
                    byte[] byArray = this.connection.readAvailable();
                    LOGGER.trace((Object)("AEM UEGO input: " + HexUtil.asHex(byArray)));
                    int n = this.findStart(byArray);
                    LOGGER.trace((Object)("AEM UEGO start index: " + n));
                    if (n < 0 || n >= byArray.length) continue;
                    ArrayList<Byte> arrayList = new ArrayList<Byte>();
                    for (int i = n; i < byArray.length; ++i) {
                        byte by = byArray[i];
                        if (by == 13) {
                            byte[] byArray2 = this.toArray(arrayList);
                            LOGGER.trace((Object)("AEM UEGO Response: " + HexUtil.asHex(byArray2)));
                            return byArray2;
                        }
                        arrayList.add(by);
                    }
                }
                ThreadUtil.sleep(1L);
            }
            LOGGER.warn((Object)"AEM UEGO Response [read timeout]");
            return new byte[0];
        }
        catch (Exception exception) {
            this.close();
            throw new SerialCommunicationException(exception);
        }
    }

    private int findStart(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 13) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public void close() {
        this.connection.close();
        LOGGER.info((Object)"AEM disconnected");
    }

    private byte[] toArray(List<Byte> list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i);
        }
        return byArray;
    }
}

