/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu;

import com.centerkey.utils.BareBonesBrowserLaunch;
import com.romraider.ECUEditor;
import com.romraider.Settings;
import com.romraider.io.serial.port.SerialPortRefresher;
import com.romraider.logger.ecu.comms.controller.LoggerController;
import com.romraider.logger.ecu.comms.controller.LoggerControllerImpl;
import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.logger.ecu.comms.query.EcuInitCallback;
import com.romraider.logger.ecu.comms.reset.ResetManager;
import com.romraider.logger.ecu.comms.reset.ResetManagerImpl;
import com.romraider.logger.ecu.definition.EcuDataLoaderImpl;
import com.romraider.logger.ecu.definition.EcuDefinition;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.ExternalDataImpl;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.exception.PortNotFoundException;
import com.romraider.logger.ecu.external.ExternalDataItem;
import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.logger.ecu.external.ExternalDataSourceLoaderImpl;
import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileImpl;
import com.romraider.logger.ecu.profile.UserProfileItem;
import com.romraider.logger.ecu.profile.UserProfileItemImpl;
import com.romraider.logger.ecu.profile.UserProfileLoaderImpl;
import com.romraider.logger.ecu.ui.DataRegistrationBroker;
import com.romraider.logger.ecu.ui.DataRegistrationBrokerImpl;
import com.romraider.logger.ecu.ui.EcuDataComparator;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.logger.ecu.ui.SerialPortComboBox;
import com.romraider.logger.ecu.ui.StatusIndicator;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandlerManager;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandlerManagerImpl;
import com.romraider.logger.ecu.ui.handler.dash.DashboardUpdateHandler;
import com.romraider.logger.ecu.ui.handler.file.FileLoggerControllerSwitchHandler;
import com.romraider.logger.ecu.ui.handler.file.FileLoggerControllerSwitchMonitorImpl;
import com.romraider.logger.ecu.ui.handler.file.FileUpdateHandlerImpl;
import com.romraider.logger.ecu.ui.handler.graph.GraphUpdateHandler;
import com.romraider.logger.ecu.ui.handler.injector.InjectorUpdateHandler;
import com.romraider.logger.ecu.ui.handler.livedata.LiveDataTableModel;
import com.romraider.logger.ecu.ui.handler.livedata.LiveDataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.maf.MafUpdateHandler;
import com.romraider.logger.ecu.ui.handler.table.TableUpdateHandler;
import com.romraider.logger.ecu.ui.paramlist.ParameterListTable;
import com.romraider.logger.ecu.ui.paramlist.ParameterListTableModel;
import com.romraider.logger.ecu.ui.paramlist.ParameterRow;
import com.romraider.logger.ecu.ui.playback.PlaybackManagerImpl;
import com.romraider.logger.ecu.ui.swing.layout.BetterFlowLayout;
import com.romraider.logger.ecu.ui.swing.menubar.EcuLoggerMenuBar;
import com.romraider.logger.ecu.ui.swing.menubar.action.ToggleButtonAction;
import com.romraider.logger.ecu.ui.swing.menubar.util.FileHelper;
import com.romraider.logger.ecu.ui.swing.vertical.VerticalTextIcon;
import com.romraider.logger.ecu.ui.tab.injector.InjectorTab;
import com.romraider.logger.ecu.ui.tab.injector.InjectorTabImpl;
import com.romraider.logger.ecu.ui.tab.maf.MafTab;
import com.romraider.logger.ecu.ui.tab.maf.MafTabImpl;
import com.romraider.util.ParamChecker;
import com.romraider.util.SettingsManagerImpl;
import com.romraider.util.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcuLogger
extends JFrame
implements WindowListener,
PropertyChangeListener,
MessageListener {
    private static final long serialVersionUID = 7145423251696282784L;
    private static final Logger LOGGER = Logger.getLogger(EcuLogger.class);
    private static final String ECU_LOGGER_TITLE = "RomRaider v0.5.2 Beta  | ECU Logger";
    private static final String LOGGER_FULLSCREEN_ARG = "-logger.fullscreen";
    private static final String ICON_PATH = "./graphics/romraider-ico.gif";
    private static final String HEADING_PARAMETERS = "Parameters";
    private static final String HEADING_SWITCHES = "Switches";
    private static final String HEADING_EXTERNAL = "External";
    private static final String CAL_ID_LABEL = "CAL ID";
    private static final String ECU_ID_LABEL = "ECU ID";
    private ECUEditor ecuEditor;
    private Settings settings;
    private LoggerController controller;
    private ResetManager resetManager;
    private JLabel messageLabel;
    private JLabel calIdLabel;
    private JLabel ecuIdLabel;
    private JLabel statsLabel;
    private JTabbedPane tabbedPane;
    private SerialPortComboBox portsComboBox;
    private DataUpdateHandlerManager dataHandlerManager;
    private DataRegistrationBroker dataTabBroker;
    private ParameterListTableModel dataTabParamListTableModel;
    private ParameterListTableModel dataTabSwitchListTableModel;
    private ParameterListTableModel dataTabExternalListTableModel;
    private DataUpdateHandlerManager graphHandlerManager;
    private DataRegistrationBroker graphTabBroker;
    private ParameterListTableModel graphTabParamListTableModel;
    private ParameterListTableModel graphTabSwitchListTableModel;
    private ParameterListTableModel graphTabExternalListTableModel;
    private DataUpdateHandlerManager dashboardHandlerManager;
    private DataRegistrationBroker dashboardTabBroker;
    private ParameterListTableModel dashboardTabParamListTableModel;
    private ParameterListTableModel dashboardTabSwitchListTableModel;
    private ParameterListTableModel dashboardTabExternalListTableModel;
    private FileUpdateHandlerImpl fileUpdateHandler;
    private LiveDataTableModel dataTableModel;
    private LiveDataUpdateHandler liveDataUpdateHandler;
    private JPanel graphPanel;
    private GraphUpdateHandler graphUpdateHandler;
    private JPanel dashboardPanel;
    private DashboardUpdateHandler dashboardUpdateHandler;
    private MafTab mafTab;
    private MafUpdateHandler mafUpdateHandler;
    private DataUpdateHandlerManager mafHandlerManager;
    private DataRegistrationBroker mafTabBroker;
    private InjectorTab injectorTab;
    private InjectorUpdateHandler injectorUpdateHandler;
    private DataUpdateHandlerManager injectorHandlerManager;
    private DataRegistrationBroker injectorTabBroker;
    private EcuInit ecuInit;
    private JToggleButton logToFileButton;
    private List<ExternalDataSource> externalDataSources;
    private List<EcuParameter> ecuParams;

    public EcuLogger(Settings settings) {
        super(ECU_LOGGER_TITLE);
        this.construct(settings);
    }

    public EcuLogger(ECUEditor eCUEditor) {
        super(ECU_LOGGER_TITLE);
        this.ecuEditor = eCUEditor;
        this.construct(eCUEditor.getSettings());
    }

    private void construct(Settings settings) {
        this.bootstrap(settings);
        this.loadEcuDefs();
        this.loadLoggerPlugins();
        this.loadLoggerParams();
        this.initControllerListeners();
        this.initUserInterface();
        this.initDataUpdateHandlers();
        this.startPortRefresherThread();
        if (!this.isLogging()) {
            this.startLogging();
        }
    }

    private void bootstrap(final Settings settings) {
        ParamChecker.checkNotNull(settings);
        this.settings = settings;
        EcuInitCallback ecuInitCallback = new EcuInitCallback(){

            public void callback(EcuInit ecuInit) {
                final String string = ecuInit.getEcuId();
                LOGGER.info((Object)("ECU ID = " + string));
                if (EcuLogger.this.ecuInit == null || !EcuLogger.this.ecuInit.getEcuId().equals(string)) {
                    EcuLogger.this.ecuInit = ecuInit;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string2 = this.getCalId(string);
                            LOGGER.info((Object)("CAL ID = " + string2));
                            EcuLogger.this.calIdLabel.setText(EcuLogger.this.buildEcuInfoLabelText(EcuLogger.CAL_ID_LABEL, string2));
                            EcuLogger.this.ecuIdLabel.setText(EcuLogger.this.buildEcuInfoLabelText(EcuLogger.ECU_ID_LABEL, string));
                            LOGGER.info((Object)("Loading logger config for new ECU (ecuid: " + string + ")..."));
                            EcuLogger.this.loadLoggerParams();
                            EcuLogger.this.loadUserProfile(settings.getLoggerProfileFilePath());
                        }

                        private String getCalId(String string2) {
                            Map<String, EcuDefinition> map = settings.getLoggerEcuDefinitionMap();
                            if (map == null) {
                                return null;
                            }
                            EcuDefinition ecuDefinition = map.get(string2);
                            return ecuDefinition == null ? null : ecuDefinition.getCalId();
                        }
                    });
                }
            }
        };
        this.fileUpdateHandler = new FileUpdateHandlerImpl(settings, this);
        this.dataTableModel = new LiveDataTableModel();
        this.liveDataUpdateHandler = new LiveDataUpdateHandler(this.dataTableModel);
        this.graphPanel = new JPanel(new BorderLayout(2, 2));
        this.graphUpdateHandler = new GraphUpdateHandler(this.graphPanel);
        this.dashboardPanel = new JPanel(new BetterFlowLayout(1, 3, 3));
        this.dashboardUpdateHandler = new DashboardUpdateHandler(this.dashboardPanel);
        this.mafUpdateHandler = new MafUpdateHandler();
        this.injectorUpdateHandler = new InjectorUpdateHandler();
        this.controller = new LoggerControllerImpl(settings, ecuInitCallback, this, this.liveDataUpdateHandler, this.graphUpdateHandler, this.dashboardUpdateHandler, this.mafUpdateHandler, this.injectorUpdateHandler, this.fileUpdateHandler, TableUpdateHandler.getInstance());
        this.mafHandlerManager = new DataUpdateHandlerManagerImpl();
        this.mafTabBroker = new DataRegistrationBrokerImpl(this.controller, this.mafHandlerManager);
        this.mafTab = new MafTabImpl(this.mafTabBroker, this.ecuEditor);
        this.mafUpdateHandler.setMafTab(this.mafTab);
        this.injectorHandlerManager = new DataUpdateHandlerManagerImpl();
        this.injectorTabBroker = new DataRegistrationBrokerImpl(this.controller, this.injectorHandlerManager);
        this.injectorTab = new InjectorTabImpl(this.injectorTabBroker, this.ecuEditor);
        this.injectorUpdateHandler.setInjectorTab(this.injectorTab);
        this.resetManager = new ResetManagerImpl(settings, this);
        this.messageLabel = new JLabel(ECU_LOGGER_TITLE);
        this.calIdLabel = new JLabel(this.buildEcuInfoLabelText(CAL_ID_LABEL, null));
        this.ecuIdLabel = new JLabel(this.buildEcuInfoLabelText(ECU_ID_LABEL, null));
        this.statsLabel = this.buildStatsLabel();
        this.tabbedPane = new JTabbedPane(3);
        this.portsComboBox = new SerialPortComboBox(settings);
        this.dataHandlerManager = new DataUpdateHandlerManagerImpl();
        this.dataTabBroker = new DataRegistrationBrokerImpl(this.controller, this.dataHandlerManager);
        this.dataTabParamListTableModel = new ParameterListTableModel(this.dataTabBroker, HEADING_PARAMETERS);
        this.dataTabSwitchListTableModel = new ParameterListTableModel(this.dataTabBroker, HEADING_SWITCHES);
        this.dataTabExternalListTableModel = new ParameterListTableModel(this.dataTabBroker, HEADING_EXTERNAL);
        this.graphHandlerManager = new DataUpdateHandlerManagerImpl();
        this.graphTabBroker = new DataRegistrationBrokerImpl(this.controller, this.graphHandlerManager);
        this.graphTabParamListTableModel = new ParameterListTableModel(this.graphTabBroker, HEADING_PARAMETERS);
        this.graphTabSwitchListTableModel = new ParameterListTableModel(this.graphTabBroker, HEADING_SWITCHES);
        this.graphTabExternalListTableModel = new ParameterListTableModel(this.graphTabBroker, HEADING_EXTERNAL);
        this.dashboardHandlerManager = new DataUpdateHandlerManagerImpl();
        this.dashboardTabBroker = new DataRegistrationBrokerImpl(this.controller, this.dashboardHandlerManager);
        this.dashboardTabParamListTableModel = new ParameterListTableModel(this.dashboardTabBroker, HEADING_PARAMETERS);
        this.dashboardTabSwitchListTableModel = new ParameterListTableModel(this.dashboardTabBroker, HEADING_SWITCHES);
        this.dashboardTabExternalListTableModel = new ParameterListTableModel(this.dashboardTabBroker, HEADING_EXTERNAL);
    }

    public void loadLoggerParams() {
        this.loadLoggerConfig();
        this.loadFromExternalDataSources();
    }

    private void initControllerListeners() {
        this.controller.addListener(this.dataTabBroker);
        this.controller.addListener(this.graphTabBroker);
        this.controller.addListener(this.dashboardTabBroker);
    }

    private void startPortRefresherThread() {
        SerialPortRefresher serialPortRefresher = new SerialPortRefresher(this.portsComboBox, this.settings.getLoggerPortDefault());
        ThreadUtil.runAsDaemon(serialPortRefresher);
        this.waitForSerialPortRefresher(serialPortRefresher);
    }

    private void waitForSerialPortRefresher(SerialPortRefresher serialPortRefresher) {
        try {
            this.doWait(serialPortRefresher);
        }
        catch (PortNotFoundException portNotFoundException) {
            LOGGER.warn((Object)"Timeout while waiting for serial port refresher - continuing anyway...");
        }
    }

    private void doWait(SerialPortRefresher serialPortRefresher) {
        long l = System.currentTimeMillis();
        while (!serialPortRefresher.isStarted()) {
            this.checkSerialPortRefresherTimeout(l);
            ThreadUtil.sleep(100L);
        }
    }

    private void checkSerialPortRefresherTimeout(long l) {
        if (System.currentTimeMillis() - l > 2000L) {
            throw new PortNotFoundException("Timeout while finding serial ports");
        }
    }

    private void initUserInterface() {
        this.setJMenuBar(this.buildMenubar());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildControlToolbar(), "North");
        jPanel.add((Component)this.buildTabbedPane(), "Center");
        jPanel.add((Component)this.buildStatusBar(), "South");
        this.getContentPane().add(jPanel);
    }

    private void loadEcuDefs() {
        try {
            HashMap<String, EcuDefinition> hashMap = new HashMap<String, EcuDefinition>();
            Vector<File> vector = this.settings.getEcuDefinitionFiles();
            if (!vector.isEmpty()) {
                EcuDataLoaderImpl ecuDataLoaderImpl = new EcuDataLoaderImpl();
                for (File file : vector) {
                    ecuDataLoaderImpl.loadEcuDefsFromXml(file);
                    hashMap.putAll(ecuDataLoaderImpl.getEcuDefinitionMap());
                }
            }
            this.settings.setLoggerEcuDefinitionMap(hashMap);
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    private void loadLoggerConfig() {
        String string = this.settings.getLoggerDefinitionFilePath();
        if (ParamChecker.isNullOrEmpty(string)) {
            this.showMissingConfigDialog();
        } else {
            try {
                EcuDataLoaderImpl ecuDataLoaderImpl = new EcuDataLoaderImpl();
                ecuDataLoaderImpl.loadConfigFromXml(string, this.settings.getLoggerProtocol(), this.settings.getFileLoggingControllerSwitchId(), this.ecuInit);
                List<EcuParameter> list = ecuDataLoaderImpl.getEcuParameters();
                this.addConvertorUpdateListeners(list);
                this.loadEcuParams(list);
                this.loadEcuSwitches(ecuDataLoaderImpl.getEcuSwitches());
                this.initFileLoggingController(ecuDataLoaderImpl.getFileLoggingControllerSwitch());
                this.settings.setLoggerConnectionProperties(ecuDataLoaderImpl.getConnectionProperties());
            }
            catch (Exception exception) {
                this.reportError(exception);
            }
        }
    }

    private void showMissingConfigDialog() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(this, "Logger definition not configured.\nGo online to download the latest definition file?", "Configuration", -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            BareBonesBrowserLaunch.openURL("http://www.romraider.com/forum/topic1642.html");
        } else {
            JOptionPane.showMessageDialog(this, "The Logger definition file needs to be configured before connecting to the ECU.\nMenu: Settings > Logger Definition Location...", "Configuration", 1);
            this.reportError("Logger definition file not found");
        }
    }

    private void loadLoggerPlugins() {
        try {
            ExternalDataSourceLoaderImpl externalDataSourceLoaderImpl = new ExternalDataSourceLoaderImpl();
            externalDataSourceLoaderImpl.loadExternalDataSources();
            this.externalDataSources = externalDataSourceLoaderImpl.getExternalDataSources();
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    private void loadFromExternalDataSources() {
        try {
            List<ExternalData> list = this.getExternalData(this.externalDataSources);
            this.loadExternalDatas(list);
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    public void loadUserProfile(String string) {
        try {
            UserProfileLoaderImpl userProfileLoaderImpl = new UserProfileLoaderImpl();
            String string2 = ParamChecker.isNullOrEmpty(string) ? "profile_backup.xml" : string;
            UserProfile userProfile = userProfileLoaderImpl.loadProfile(string2);
            this.applyUserProfile(userProfile);
            File file = new File(string2);
            if (file.exists()) {
                this.reportMessageInTitleBar("Profile: " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            this.reportError(exception);
        }
    }

    private void initFileLoggingController(EcuSwitch ecuSwitch) {
        this.controller.setFileLoggerSwitchMonitor(new FileLoggerControllerSwitchMonitorImpl(ecuSwitch, new FileLoggerControllerSwitchHandler(){
            boolean oldDefogStatus = false;

            public void handleSwitch(double d) {
                boolean bl;
                boolean bl2 = bl = (int)d == 1;
                if (EcuLogger.this.settings.isFileLoggingControllerSwitchActive() && bl != this.oldDefogStatus) {
                    EcuLogger.this.logToFileButton.setSelected(bl);
                    if (bl) {
                        EcuLogger.this.fileUpdateHandler.start();
                    } else {
                        EcuLogger.this.fileUpdateHandler.stop();
                    }
                }
                this.oldDefogStatus = bl;
            }
        }));
    }

    private void applyUserProfile(UserProfile userProfile) {
        if (userProfile != null) {
            this.applyUserProfileToLiveDataTabParameters(this.dataTabParamListTableModel, userProfile);
            this.applyUserProfileToLiveDataTabParameters(this.dataTabSwitchListTableModel, userProfile);
            this.applyUserProfileToLiveDataTabParameters(this.dataTabExternalListTableModel, userProfile);
            this.applyUserProfileToGraphTabParameters(this.graphTabParamListTableModel, userProfile);
            this.applyUserProfileToGraphTabParameters(this.graphTabSwitchListTableModel, userProfile);
            this.applyUserProfileToGraphTabParameters(this.graphTabExternalListTableModel, userProfile);
            this.applyUserProfileToDashTabParameters(this.dashboardTabParamListTableModel, userProfile);
            this.applyUserProfileToDashTabParameters(this.dashboardTabSwitchListTableModel, userProfile);
            this.applyUserProfileToDashTabParameters(this.dashboardTabExternalListTableModel, userProfile);
        }
    }

    private void applyUserProfileToLiveDataTabParameters(ParameterListTableModel parameterListTableModel, UserProfile userProfile) {
        List<ParameterRow> list = parameterListTableModel.getParameterRows();
        for (ParameterRow parameterRow : list) {
            LoggerData loggerData = parameterRow.getLoggerData();
            this.setDefaultUnits(userProfile, loggerData);
            parameterListTableModel.selectParam(loggerData, this.isSelectedOnLiveDataTab(userProfile, loggerData));
        }
    }

    private void applyUserProfileToGraphTabParameters(ParameterListTableModel parameterListTableModel, UserProfile userProfile) {
        List<ParameterRow> list = parameterListTableModel.getParameterRows();
        for (ParameterRow parameterRow : list) {
            LoggerData loggerData = parameterRow.getLoggerData();
            this.setDefaultUnits(userProfile, loggerData);
            parameterListTableModel.selectParam(loggerData, this.isSelectedOnGraphTab(userProfile, loggerData));
        }
    }

    private void applyUserProfileToDashTabParameters(ParameterListTableModel parameterListTableModel, UserProfile userProfile) {
        List<ParameterRow> list = parameterListTableModel.getParameterRows();
        for (ParameterRow parameterRow : list) {
            LoggerData loggerData = parameterRow.getLoggerData();
            this.setDefaultUnits(userProfile, loggerData);
            parameterListTableModel.selectParam(loggerData, this.isSelectedOnDashTab(userProfile, loggerData));
        }
    }

    private void addConvertorUpdateListeners(List<EcuParameter> list) {
        for (EcuParameter ecuParameter : list) {
            ecuParameter.addConvertorUpdateListener(this.fileUpdateHandler);
            ecuParameter.addConvertorUpdateListener(this.liveDataUpdateHandler);
            ecuParameter.addConvertorUpdateListener(this.graphUpdateHandler);
            ecuParameter.addConvertorUpdateListener(this.dashboardUpdateHandler);
        }
    }

    private void clearParamTableModels() {
        this.dataTabParamListTableModel.clear();
        this.graphTabParamListTableModel.clear();
        this.dashboardTabParamListTableModel.clear();
    }

    private void clearSwitchTableModels() {
        this.dataTabSwitchListTableModel.clear();
        this.graphTabSwitchListTableModel.clear();
        this.dashboardTabSwitchListTableModel.clear();
    }

    private void clearExternalTableModels() {
        this.dataTabExternalListTableModel.clear();
        this.graphTabExternalListTableModel.clear();
        this.dashboardTabExternalListTableModel.clear();
    }

    private void loadEcuParams(List<EcuParameter> list) {
        this.clearParamTableModels();
        Collections.sort(list, new EcuDataComparator());
        for (EcuParameter ecuParameter : list) {
            this.dataTabParamListTableModel.addParam(ecuParameter, false);
            this.graphTabParamListTableModel.addParam(ecuParameter, false);
            this.dashboardTabParamListTableModel.addParam(ecuParameter, false);
        }
        this.mafTab.setEcuParams(list);
        this.injectorTab.setEcuParams(list);
        this.ecuParams = new ArrayList<EcuParameter>(list);
    }

    private void loadEcuSwitches(List<EcuSwitch> list) {
        this.clearSwitchTableModels();
        Collections.sort(list, new EcuDataComparator());
        for (EcuSwitch ecuSwitch : list) {
            this.dataTabSwitchListTableModel.addParam(ecuSwitch, false);
            this.graphTabSwitchListTableModel.addParam(ecuSwitch, false);
            this.dashboardTabSwitchListTableModel.addParam(ecuSwitch, false);
        }
        this.mafTab.setEcuSwitches(list);
        this.injectorTab.setEcuSwitches(list);
    }

    private List<ExternalData> getExternalData(List<ExternalDataSource> list) {
        ArrayList<ExternalData> arrayList = new ArrayList<ExternalData>();
        for (ExternalDataSource externalDataSource : list) {
            try {
                List<? extends ExternalDataItem> list2 = externalDataSource.getDataItems();
                for (ExternalDataItem externalDataItem : list2) {
                    arrayList.add(new ExternalDataImpl(externalDataItem, externalDataSource));
                }
            }
            catch (Exception exception) {
                this.reportError("Error loading plugin: " + externalDataSource.getName() + " v" + externalDataSource.getVersion(), exception);
            }
        }
        return arrayList;
    }

    private void loadExternalDatas(List<ExternalData> list) {
        this.clearExternalTableModels();
        Collections.sort(list, new EcuDataComparator());
        for (ExternalData externalData : list) {
            this.dataTabExternalListTableModel.addParam(externalData, false);
            this.graphTabExternalListTableModel.addParam(externalData, false);
            this.dashboardTabExternalListTableModel.addParam(externalData, false);
        }
        this.mafTab.setExternalDatas(list);
        this.injectorTab.setExternalDatas(list);
    }

    private void setDefaultUnits(UserProfile userProfile, LoggerData loggerData) {
        if (userProfile != null) {
            try {
                loggerData.selectConvertor(userProfile.getSelectedConvertor(loggerData));
            }
            catch (Exception exception) {
                this.reportError(exception);
            }
        }
    }

    private boolean isSelectedOnLiveDataTab(UserProfile userProfile, LoggerData loggerData) {
        return userProfile != null && userProfile.isSelectedOnLiveDataTab(loggerData);
    }

    private boolean isSelectedOnGraphTab(UserProfile userProfile, LoggerData loggerData) {
        return userProfile != null && userProfile.isSelectedOnGraphTab(loggerData);
    }

    private boolean isSelectedOnDashTab(UserProfile userProfile, LoggerData loggerData) {
        return userProfile != null && userProfile.isSelectedOnDashTab(loggerData);
    }

    public UserProfile getCurrentProfile() {
        Map<String, UserProfileItem> map = this.getProfileItems(this.dataTabParamListTableModel.getParameterRows(), this.graphTabParamListTableModel.getParameterRows(), this.dashboardTabParamListTableModel.getParameterRows());
        Map<String, UserProfileItem> map2 = this.getProfileItems(this.dataTabSwitchListTableModel.getParameterRows(), this.graphTabSwitchListTableModel.getParameterRows(), this.dashboardTabSwitchListTableModel.getParameterRows());
        Map<String, UserProfileItem> map3 = this.getProfileItems(this.dataTabExternalListTableModel.getParameterRows(), this.graphTabExternalListTableModel.getParameterRows(), this.dashboardTabExternalListTableModel.getParameterRows());
        return new UserProfileImpl(map, map2, map3);
    }

    private Map<String, UserProfileItem> getProfileItems(List<ParameterRow> list, List<ParameterRow> list2, List<ParameterRow> list3) {
        HashMap<String, UserProfileItem> hashMap = new HashMap<String, UserProfileItem>();
        for (ParameterRow parameterRow : list) {
            String string = parameterRow.getLoggerData().getId();
            String string2 = parameterRow.getLoggerData().getSelectedConvertor().getUnits();
            boolean bl = parameterRow.isSelected();
            boolean bl2 = this.isEcuDataSelected(string, list2);
            boolean bl3 = this.isEcuDataSelected(string, list3);
            hashMap.put(string, new UserProfileItemImpl(string2, bl, bl2, bl3));
        }
        return hashMap;
    }

    private boolean isEcuDataSelected(String string, List<ParameterRow> list) {
        for (ParameterRow parameterRow : list) {
            if (!string.equals(parameterRow.getLoggerData().getId())) continue;
            return parameterRow.isSelected();
        }
        return false;
    }

    private void initDataUpdateHandlers() {
        this.dataHandlerManager.addHandler(this.liveDataUpdateHandler);
        this.dataHandlerManager.addHandler(this.fileUpdateHandler);
        this.dataHandlerManager.addHandler(TableUpdateHandler.getInstance());
        this.graphHandlerManager.addHandler(this.graphUpdateHandler);
        this.graphHandlerManager.addHandler(this.fileUpdateHandler);
        this.graphHandlerManager.addHandler(TableUpdateHandler.getInstance());
        this.dashboardHandlerManager.addHandler(this.dashboardUpdateHandler);
        this.dashboardHandlerManager.addHandler(this.fileUpdateHandler);
        this.dashboardHandlerManager.addHandler(TableUpdateHandler.getInstance());
    }

    private JComponent buildTabbedPane() {
        this.addSplitPaneTab("Data", this.buildSplitPane(this.buildParamListPane(this.dataTabParamListTableModel, this.dataTabSwitchListTableModel, this.dataTabExternalListTableModel), this.buildDataTab()), new JComponent[0]);
        this.addSplitPaneTab("Graph", this.buildSplitPane(this.buildParamListPane(this.graphTabParamListTableModel, this.graphTabSwitchListTableModel, this.graphTabExternalListTableModel), this.buildGraphTab()), new JComponent[0]);
        this.addSplitPaneTab("Dashboard", this.buildSplitPane(this.buildParamListPane(this.dashboardTabParamListTableModel, this.dashboardTabSwitchListTableModel, this.dashboardTabExternalListTableModel), this.buildDashboardTab()), this.buildToggleGaugeStyleButton());
        this.tabbedPane.add("MAF", this.mafTab.getPanel());
        this.tabbedPane.add("Injector", this.injectorTab.getPanel());
        return this.tabbedPane;
    }

    private JButton buildToggleGaugeStyleButton() {
        final JButton jButton = new JButton();
        VerticalTextIcon verticalTextIcon = new VerticalTextIcon(jButton, "Gauge Style", 2);
        jButton.setIcon(verticalTextIcon);
        jButton.setPreferredSize(new Dimension(25, 90));
        jButton.getInputMap(2).put(KeyStroke.getKeyStroke("F12"), "toggleGaugeStyle");
        jButton.getActionMap().put("toggleGaugeStyle", new AbstractAction(){
            private static final long serialVersionUID = 6913964758354638587L;

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick();
            }
        });
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 123232894767995264L;

            public void actionPerformed(ActionEvent actionEvent) {
                EcuLogger.this.dashboardUpdateHandler.toggleGaugeStyle();
            }
        });
        return jButton;
    }

    private void addSplitPaneTab(String string, final JSplitPane jSplitPane, JComponent ... jComponentArray) {
        final JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setSelected(true);
        VerticalTextIcon verticalTextIcon = new VerticalTextIcon(jToggleButton, "Parameter List", 2);
        jToggleButton.setIcon(verticalTextIcon);
        jToggleButton.setPreferredSize(new Dimension(25, 90));
        jToggleButton.getInputMap(2).put(KeyStroke.getKeyStroke("F11"), "toggleHideParams");
        jToggleButton.getActionMap().put("toggleHideParams", new AbstractAction(){
            private static final long serialVersionUID = -276854997788647306L;

            public void actionPerformed(ActionEvent actionEvent) {
                jToggleButton.doClick();
            }
        });
        jToggleButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1595098685575657317L;
            private final int min = 1;
            private int size = jSplitPane.getDividerLocation();

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jSplitPane.getDividerLocation();
                if (jToggleButton.isSelected()) {
                    jSplitPane.setDividerLocation(this.size);
                } else {
                    jSplitPane.setDividerLocation(1);
                    this.size = n;
                }
            }
        });
        JPanel jPanel = new JPanel(new BetterFlowLayout(1, 1, 1));
        jPanel.setPreferredSize(new Dimension(25, 25));
        jPanel.add(jToggleButton);
        for (JComponent jComponent : jComponentArray) {
            jPanel.add(jComponent);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "West");
        jPanel2.add((Component)jSplitPane, "Center");
        this.tabbedPane.add(string, jPanel2);
    }

    private JComponent buildParamListPane(ParameterListTableModel parameterListTableModel, ParameterListTableModel parameterListTableModel2, ParameterListTableModel parameterListTableModel3) {
        JScrollPane jScrollPane = new JScrollPane(this.buildParamListTable(parameterListTableModel), 20, 30);
        JScrollPane jScrollPane2 = new JScrollPane(this.buildParamListTable(parameterListTableModel3), 20, 30);
        JScrollPane jScrollPane3 = new JScrollPane(this.buildParamListTable(parameterListTableModel2), 20, 30);
        JTabbedPane jTabbedPane = new JTabbedPane(1, 1);
        jTabbedPane.addTab("ECU Parameters", jScrollPane);
        jTabbedPane.addTab("ECU Switches", jScrollPane3);
        jTabbedPane.addTab("External Sensors", jScrollPane2);
        return jTabbedPane;
    }

    private JTable buildParamListTable(ParameterListTableModel parameterListTableModel) {
        ParameterListTable parameterListTable = new ParameterListTable(parameterListTableModel);
        this.changeColumnWidth(parameterListTable, 0, 20, 55, 55);
        this.changeColumnWidth(parameterListTable, 2, 50, 250, 130);
        return parameterListTable;
    }

    private void changeColumnWidth(JTable jTable, int n, int n2, int n3, int n4) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n3);
        tableColumn.setPreferredWidth(n4);
    }

    private JComponent buildStatusBar() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.add((Component)this.messageLabel, "West");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.add(this.calIdLabel);
        jPanel3.add(this.ecuIdLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel4.add(this.statsLabel);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private String buildEcuInfoLabelText(String string, String string2) {
        return string + ": " + (ParamChecker.isNullOrEmpty(string2) ? " Unknown " : string2);
    }

    private JSplitPane buildSplitPane(JComponent jComponent, JComponent jComponent2) {
        JSplitPane jSplitPane = new JSplitPane(1, jComponent, jComponent2);
        jSplitPane.setDividerSize(2);
        jSplitPane.setDividerLocation(500);
        jSplitPane.addPropertyChangeListener(this);
        return jSplitPane;
    }

    private JMenuBar buildMenubar() {
        return new EcuLoggerMenuBar(this, this.externalDataSources);
    }

    private JPanel buildControlToolbar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildPortsComboBox(), "West");
        jPanel.add((Component)this.buildStatusIndicator(), "East");
        return jPanel;
    }

    private Component buildPlaybackControls() {
        JButton jButton = new JButton("Play");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadUtil.runAsDaemon(new Runnable(){

                    public void run() {
                        PlaybackManagerImpl playbackManagerImpl = new PlaybackManagerImpl(EcuLogger.this.ecuParams, EcuLogger.this.liveDataUpdateHandler, EcuLogger.this.graphUpdateHandler, EcuLogger.this.dashboardUpdateHandler, EcuLogger.this.mafUpdateHandler, TableUpdateHandler.getInstance());
                        playbackManagerImpl.load(new File("foo.csv"));
                        playbackManagerImpl.play();
                    }
                });
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        return jPanel;
    }

    private Component buildLogToFileButton() {
        this.logToFileButton = new JToggleButton("Log to file", new ImageIcon("./graphics/logger_log_to_file.png"));
        this.logToFileButton.setToolTipText("Start/stop file logging (F1)");
        this.logToFileButton.setPreferredSize(new Dimension(100, 25));
        this.logToFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EcuLogger.this.logToFileButton.isSelected()) {
                    EcuLogger.this.fileUpdateHandler.start();
                } else {
                    EcuLogger.this.fileUpdateHandler.stop();
                }
            }
        });
        this.logToFileButton.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "toggleFileLogging");
        this.logToFileButton.getActionMap().put("toggleFileLogging", new ToggleButtonAction(this, this.logToFileButton));
        return this.logToFileButton;
    }

    private JPanel buildPortsComboBox() {
        this.portsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EcuLogger.this.settings.setLoggerPort((String)EcuLogger.this.portsComboBox.getSelectedItem());
                if (!actionEvent.paramString().endsWith("modifiers=")) {
                    EcuLogger.this.restartLogging();
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel("COM Port:"));
        jPanel.add(this.portsComboBox);
        JButton jButton = new JButton(new ImageIcon("./graphics/logger_restart.png"));
        jButton.setPreferredSize(new Dimension(25, 25));
        jButton.setToolTipText("Reconnect to ECU");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EcuLogger.this.restartLogging();
                }
                catch (Exception exception) {
                    EcuLogger.this.reportError(exception);
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new ImageIcon("./graphics/logger_stop.png"));
        jButton2.setPreferredSize(new Dimension(25, 25));
        jButton2.setToolTipText("Disconnect from ECU");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EcuLogger.this.stopLogging();
                }
                catch (Exception exception) {
                    EcuLogger.this.reportError(exception);
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(new JSeparator(1));
        jPanel.add(this.buildLogToFileButton());
        return jPanel;
    }

    public void restartLogging() {
        this.stopLogging();
        this.startLogging();
    }

    private StatusIndicator buildStatusIndicator() {
        StatusIndicator statusIndicator = new StatusIndicator();
        this.controller.addListener(statusIndicator);
        this.fileUpdateHandler.addListener(statusIndicator);
        return statusIndicator;
    }

    private JComponent buildDataTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Reset Data");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EcuLogger.this.liveDataUpdateHandler.reset();
            }
        });
        jPanel.add((Component)jButton, "North");
        JScrollPane jScrollPane = new JScrollPane(new JTable(this.dataTableModel), 20, 31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(40);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JComponent buildGraphTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Reset Data");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EcuLogger.this.graphUpdateHandler.reset();
            }
        });
        jPanel.add((Component)jButton, "North");
        JScrollPane jScrollPane = new JScrollPane(this.graphPanel, 20, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(40);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JComponent buildDashboardTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Reset Data");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EcuLogger.this.dashboardUpdateHandler.reset();
            }
        });
        jPanel.add((Component)jButton, "North");
        JScrollPane jScrollPane = new JScrollPane(this.dashboardPanel, 20, 31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(40);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void selectTab(int n) {
        int n2 = this.tabbedPane.getComponentCount();
        if (n >= 0 && n < n2) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleExit();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public boolean isLogging() {
        return this.controller.isStarted();
    }

    public void startLogging() {
        String string = this.settings.getLoggerPort();
        if (ParamChecker.isNullOrEmpty(string)) {
            return;
        }
        this.controller.start();
    }

    public void stopLogging() {
        this.controller.stop();
        ThreadUtil.sleep(1000L);
    }

    private void stopPlugins() {
        for (ExternalDataSource externalDataSource : this.externalDataSources) {
            try {
                externalDataSource.disconnect();
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Error stopping datasource: " + externalDataSource.getName()), (Throwable)exception);
            }
        }
    }

    public boolean resetEcu() {
        return this.resetManager.resetEcu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExit() {
        try {
            try {
                try {
                    this.stopLogging();
                }
                finally {
                    this.stopPlugins();
                }
            }
            finally {
                this.cleanUpUpdateHandlers();
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Error stopping logger", (Throwable)exception);
        }
        finally {
            this.saveSettings();
            this.backupCurrentProfile();
        }
    }

    private void saveSettings() {
        this.settings.setLoggerPortDefault((String)this.portsComboBox.getSelectedItem());
        this.settings.setLoggerWindowMaximized(this.getExtendedState() == 6);
        this.settings.setLoggerWindowSize(this.getSize());
        this.settings.setLoggerWindowLocation(this.getLocation());
        this.settings.setLoggerSelectedTabIndex(this.tabbedPane.getSelectedIndex());
        new SettingsManagerImpl().save(this.settings);
    }

    private void backupCurrentProfile() {
        try {
            FileHelper.saveProfileToFile(this.getCurrentProfile(), new File("profile_backup.xml"));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Error backing up profile", (Throwable)exception);
        }
    }

    private void cleanUpUpdateHandlers() {
        this.dataHandlerManager.cleanUp();
        this.graphHandlerManager.cleanUp();
        this.dashboardHandlerManager.cleanUp();
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void reportMessage(final String string) {
        if (string != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EcuLogger.this.messageLabel.setText(string);
                    EcuLogger.this.messageLabel.setForeground(Color.BLACK);
                }
            });
        }
    }

    @Override
    public void reportMessageInTitleBar(String string) {
        if (!ParamChecker.isNullOrEmpty(string)) {
            this.setTitle(string);
        }
    }

    @Override
    public void reportStats(final String string) {
        if (!ParamChecker.isNullOrEmpty(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EcuLogger.this.statsLabel.setText(string);
                }
            });
        }
    }

    private JLabel buildStatsLabel() {
        JLabel jLabel = new JLabel(" ");
        jLabel.setForeground(Color.BLACK);
        jLabel.setHorizontalTextPosition(4);
        return jLabel;
    }

    @Override
    public void reportError(final String string) {
        if (!ParamChecker.isNullOrEmpty(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EcuLogger.this.messageLabel.setText("Error: " + string);
                    EcuLogger.this.messageLabel.setForeground(Color.RED);
                }
            });
        }
    }

    @Override
    public void reportError(Exception exception) {
        if (exception != null) {
            LOGGER.error((Object)"Error occurred", (Throwable)exception);
            String string = exception.getMessage();
            if (!ParamChecker.isNullOrEmpty(string)) {
                this.reportError(string);
            } else {
                this.reportError(exception.toString());
            }
        }
    }

    @Override
    public void reportError(String string, Exception exception) {
        if (exception != null) {
            LOGGER.error((Object)string, (Throwable)exception);
        }
        this.reportError(string);
    }

    @Override
    public void setTitle(String string) {
        if (string != null) {
            if (!string.startsWith(ECU_LOGGER_TITLE)) {
                string = ECU_LOGGER_TITLE + (string.length() == 0 ? "" : " - " + string);
            }
            super.setTitle(string);
        }
    }

    public static void startLogger(int n, ECUEditor eCUEditor) {
        EcuLogger ecuLogger = new EcuLogger(eCUEditor);
        EcuLogger.createAndShowGui(n, ecuLogger, false);
    }

    public static void startLogger(int n, Settings settings, String ... stringArray) {
        EcuLogger ecuLogger = new EcuLogger(settings);
        boolean bl = EcuLogger.containsFullScreenArg(stringArray);
        EcuLogger.createAndShowGui(n, ecuLogger, bl);
    }

    private static boolean containsFullScreenArg(String ... stringArray) {
        for (String string : stringArray) {
            if (!LOGGER_FULLSCREEN_ARG.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void createAndShowGui(final int n, final EcuLogger ecuLogger, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EcuLogger.doCreateAndShowGui(n, ecuLogger, bl);
            }
        });
    }

    private static void doCreateAndShowGui(int n, EcuLogger ecuLogger, boolean bl) {
        Settings settings = ecuLogger.getSettings();
        ecuLogger.pack();
        ecuLogger.selectTab(settings.getLoggerSelectedTabIndex());
        if (bl) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            JFrame jFrame = new JFrame(ecuLogger.getTitle());
            jFrame.setIconImage(new ImageIcon(ICON_PATH).getImage());
            jFrame.setContentPane(ecuLogger.getContentPane());
            jFrame.addWindowListener(ecuLogger);
            jFrame.setDefaultCloseOperation(n);
            jFrame.setUndecorated(true);
            jFrame.setResizable(false);
            graphicsDevice.setFullScreenWindow(jFrame);
        } else {
            ecuLogger.addWindowListener(ecuLogger);
            ecuLogger.setIconImage(new ImageIcon(ICON_PATH).getImage());
            ecuLogger.setSize(settings.getLoggerWindowSize());
            ecuLogger.setLocation(settings.getLoggerWindowLocation());
            if (settings.isLoggerWindowMaximized()) {
                ecuLogger.setExtendedState(6);
            }
            ecuLogger.setDefaultCloseOperation(n);
            ecuLogger.setVisible(true);
        }
    }
}

