/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.manager;

import com.romraider.Settings;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnection;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnectionFactory;
import com.romraider.logger.ecu.comms.manager.QueryManager;
import com.romraider.logger.ecu.comms.manager.TransmissionManager;
import com.romraider.logger.ecu.comms.manager.TransmissionManagerImpl;
import com.romraider.logger.ecu.comms.query.EcuInitCallback;
import com.romraider.logger.ecu.comms.query.EcuQuery;
import com.romraider.logger.ecu.comms.query.EcuQueryImpl;
import com.romraider.logger.ecu.comms.query.ExternalQuery;
import com.romraider.logger.ecu.comms.query.ExternalQueryImpl;
import com.romraider.logger.ecu.comms.query.Query;
import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.comms.query.ResponseImpl;
import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.EcuDataType;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.logger.ecu.ui.StatusChangeListener;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.file.FileLoggerControllerSwitchMonitor;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryManagerImpl
implements QueryManager {
    private static final Logger LOGGER = Logger.getLogger(QueryManagerImpl.class);
    private final DecimalFormat format = new DecimalFormat("0.00");
    private final List<StatusChangeListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, Query> queryMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Query> addList = new HashMap<String, Query>();
    private final List<String> removeList = new ArrayList<String>();
    private final Settings settings;
    private final EcuInitCallback ecuInitCallback;
    private final MessageListener messageListener;
    private final DataUpdateHandler[] dataUpdateHandlers;
    private FileLoggerControllerSwitchMonitor monitor;
    private EcuQuery fileLoggerQuery;
    private Thread queryManagerThread;
    private boolean started;
    private boolean stop;

    public QueryManagerImpl(Settings settings, EcuInitCallback ecuInitCallback, MessageListener messageListener, DataUpdateHandler ... dataUpdateHandlerArray) {
        ParamChecker.checkNotNull(settings, ecuInitCallback, messageListener, dataUpdateHandlerArray);
        this.settings = settings;
        this.ecuInitCallback = ecuInitCallback;
        this.messageListener = messageListener;
        this.dataUpdateHandlers = dataUpdateHandlerArray;
    }

    @Override
    public synchronized void addListener(StatusChangeListener statusChangeListener) {
        ParamChecker.checkNotNull((Object)statusChangeListener, "listener");
        this.listeners.add(statusChangeListener);
    }

    @Override
    public void setFileLoggerSwitchMonitor(FileLoggerControllerSwitchMonitor fileLoggerControllerSwitchMonitor) {
        ParamChecker.checkNotNull(fileLoggerControllerSwitchMonitor);
        this.monitor = fileLoggerControllerSwitchMonitor;
        this.fileLoggerQuery = new EcuQueryImpl(fileLoggerControllerSwitchMonitor.getEcuSwitch());
    }

    @Override
    public synchronized void addQuery(String string, LoggerData loggerData) {
        ParamChecker.checkNotNull(string, loggerData);
        String string2 = this.buildQueryId(string, loggerData);
        if (loggerData.getDataType() == EcuDataType.EXTERNAL) {
            this.addList.put(string2, new ExternalQueryImpl((ExternalData)loggerData));
        } else {
            this.addList.put(string2, new EcuQueryImpl((EcuData)loggerData));
        }
    }

    @Override
    public synchronized void removeQuery(String string, LoggerData loggerData) {
        ParamChecker.checkNotNull(string, loggerData);
        this.removeList.add(this.buildQueryId(string, loggerData));
    }

    @Override
    public boolean isRunning() {
        return this.started && !this.stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.started = true;
        this.queryManagerThread = Thread.currentThread();
        LOGGER.debug((Object)"QueryManager started.");
        try {
            this.stop = false;
            while (!this.stop) {
                this.notifyConnecting();
                if (this.doEcuInit()) {
                    this.notifyReading();
                    this.runLogger();
                    continue;
                }
                ThreadUtil.sleep(1000L);
            }
        }
        catch (Exception exception) {
            this.messageListener.reportError(exception);
        }
        finally {
            this.notifyStopped();
            this.messageListener.reportMessage("Disconnected.");
            LOGGER.debug((Object)"QueryManager stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doEcuInit() {
        LoggerConnection loggerConnection = LoggerConnectionFactory.getConnection(this.settings.getLoggerProtocol(), this.settings.getLoggerPort(), this.settings.getLoggerConnectionProperties());
        try {
            this.messageListener.reportMessage("Sending ECU Init...");
            loggerConnection.ecuInit(this.ecuInitCallback);
            this.messageListener.reportMessage("Sending ECU Init...done.");
            boolean bl = true;
            loggerConnection.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                loggerConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                this.messageListener.reportMessage("Unable to send ECU init - check cable is connected and ignition is on.");
                this.logError(exception);
                return false;
            }
        }
    }

    private void logError(Exception exception) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Error sending ecu init", (Throwable)exception);
        } else {
            LOGGER.info((Object)("Error sending ecu init: " + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLogger() {
        TransmissionManagerImpl transmissionManagerImpl = new TransmissionManagerImpl(this.settings);
        long l = System.currentTimeMillis();
        int n = 0;
        try {
            transmissionManagerImpl.start();
            while (!this.stop) {
                this.updateQueryList();
                if (this.queryMap.isEmpty()) {
                    l = System.currentTimeMillis();
                    n = 0;
                    this.messageListener.reportMessage("Select parameters to be logged...");
                    ThreadUtil.sleep(1000L);
                    continue;
                }
                this.sendEcuQueries(transmissionManagerImpl);
                this.sendExternalQueries();
                this.handleQueryResponse();
                this.messageListener.reportMessage("Querying ECU...");
                this.messageListener.reportStats(this.buildStatsMessage(l, ++n));
            }
        }
        catch (Exception exception) {
            this.messageListener.reportError(exception);
        }
        finally {
            transmissionManagerImpl.stop();
        }
    }

    private void sendEcuQueries(TransmissionManager transmissionManager) {
        List<EcuQuery> list = this.filterEcuQueries(this.queryMap.values());
        if (this.fileLoggerQuery != null) {
            list.add(this.fileLoggerQuery);
        }
        transmissionManager.sendQueries(list);
    }

    private void sendExternalQueries() {
        List<ExternalQuery> list = this.filterExternalQueries(this.queryMap.values());
        for (ExternalQuery externalQuery : list) {
            externalQuery.setResponse(externalQuery.getLoggerData().getSelectedConvertor().convert(null));
        }
    }

    private void handleQueryResponse() {
        this.monitor.monitorFileLoggerSwitch(this.fileLoggerQuery.getResponse());
        final Response response = this.buildResponse(this.queryMap.values());
        for (final DataUpdateHandler dataUpdateHandler : this.dataUpdateHandlers) {
            ThreadUtil.runAsDaemon(new Runnable(){

                public void run() {
                    dataUpdateHandler.handleDataUpdate(response);
                }
            });
        }
    }

    private Response buildResponse(Collection<Query> collection) {
        ResponseImpl responseImpl = new ResponseImpl();
        for (Query query : collection) {
            responseImpl.setDataValue(query.getLoggerData(), query.getResponse());
        }
        return responseImpl;
    }

    private List<EcuQuery> filterEcuQueries(Collection<Query> collection) {
        ArrayList<EcuQuery> arrayList = new ArrayList<EcuQuery>();
        for (Query query : collection) {
            if (!EcuQuery.class.isAssignableFrom(query.getClass())) continue;
            arrayList.add((EcuQuery)query);
        }
        return arrayList;
    }

    private List<ExternalQuery> filterExternalQueries(Collection<Query> collection) {
        ArrayList<ExternalQuery> arrayList = new ArrayList<ExternalQuery>();
        for (Query query : collection) {
            if (!ExternalQuery.class.isAssignableFrom(query.getClass())) continue;
            arrayList.add((ExternalQuery)query);
        }
        return arrayList;
    }

    @Override
    public void stop() {
        this.stop = true;
        if (this.queryManagerThread != null) {
            this.queryManagerThread.interrupt();
        }
    }

    private String buildQueryId(String string, LoggerData loggerData) {
        return string + "_" + loggerData.getName();
    }

    private synchronized void updateQueryList() {
        this.addQueries();
        this.removeQueries();
    }

    private void addQueries() {
        for (String string : this.addList.keySet()) {
            this.queryMap.put(string, this.addList.get(string));
        }
        this.addList.clear();
    }

    private void removeQueries() {
        for (String string : this.removeList) {
            this.queryMap.remove(string);
        }
        this.removeList.clear();
    }

    private String buildStatsMessage(long l, int n) {
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        return "[ " + this.format.format((double)n / d) + " queries/sec, " + this.format.format(d / (double)n) + " sec/query ]";
    }

    private void notifyConnecting() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (StatusChangeListener statusChangeListener : QueryManagerImpl.this.listeners) {
                    statusChangeListener.connecting();
                }
            }
        });
    }

    private void notifyReading() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (StatusChangeListener statusChangeListener : QueryManagerImpl.this.listeners) {
                    statusChangeListener.readingData();
                }
            }
        });
    }

    private void notifyStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (StatusChangeListener statusChangeListener : QueryManagerImpl.this.listeners) {
                    statusChangeListener.stopped();
                }
            }
        });
    }
}

