/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.manager;

import com.romraider.Settings;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnection;
import com.romraider.logger.ecu.comms.io.connection.LoggerConnectionFactory;
import com.romraider.logger.ecu.comms.manager.TransmissionManager;
import com.romraider.logger.ecu.comms.query.EcuQuery;
import com.romraider.logger.ecu.exception.NotConnectedException;
import com.romraider.util.ParamChecker;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransmissionManagerImpl
implements TransmissionManager {
    private static final Logger LOGGER = Logger.getLogger(TransmissionManagerImpl.class);
    private final Settings settings;
    private LoggerConnection connection;

    public TransmissionManagerImpl(Settings settings) {
        ParamChecker.checkNotNull((Object)settings, "settings");
        this.settings = settings;
    }

    @Override
    public void start() {
        try {
            this.connection = LoggerConnectionFactory.getConnection(this.settings.getLoggerProtocol(), this.settings.getLoggerPort(), this.settings.getLoggerConnectionProperties());
            LOGGER.info((Object)"Connected.");
        }
        catch (Throwable throwable) {
            this.stop();
        }
    }

    @Override
    public void sendQueries(Collection<EcuQuery> collection) {
        ParamChecker.checkNotNull(collection, "queries");
        if (this.connection == null) {
            throw new NotConnectedException("TransmissionManager must be started before queries can be sent!");
        }
        this.connection.sendAddressReads(collection);
    }

    @Override
    public void stop() {
        if (this.connection != null) {
            this.connection.close();
        }
        LOGGER.info((Object)"Disconnected.");
    }
}

