/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.util.ParamChecker;

public final class EcuSwitchConvertorImpl
implements EcuDataConvertor {
    private static final GaugeMinMax GAUGE_MIN_MAX = new GaugeMinMax(0.0, 1.0, 1.0);
    private static final String FORMAT = "0";
    private final int bit;

    public EcuSwitchConvertorImpl(int n) {
        ParamChecker.checkBit(n);
        this.bit = n;
    }

    public double convert(byte[] byArray) {
        return (byArray[0] & 1 << this.bit) > 0 ? 1.0 : 0.0;
    }

    public String getUnits() {
        return "On/Off";
    }

    public GaugeMinMax getGaugeMinMax() {
        return GAUGE_MIN_MAX;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String format(double d) {
        return d > 0.0 ? "1" : FORMAT;
    }

    public String toString() {
        return this.getUnits();
    }
}

