/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.connection.ConnectionPropertiesImpl;
import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.logger.ecu.definition.EcuAddressImpl;
import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDerivedParameterConvertor;
import com.romraider.logger.ecu.definition.EcuDerivedParameterConvertorImpl;
import com.romraider.logger.ecu.definition.EcuDerivedParameterImpl;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuParameterConvertorImpl;
import com.romraider.logger.ecu.definition.EcuParameterImpl;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.EcuSwitchConvertorImpl;
import com.romraider.logger.ecu.definition.EcuSwitchImpl;
import com.romraider.logger.ecu.definition.xml.ConverterMaxMinDefaults;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.util.ParamChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerDefinitionHandler
extends DefaultHandler {
    private static final String FLOAT = "float";
    private static final String TAG_PROTOCOL = "protocol";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_ADDRESS = "address";
    private static final String TAG_DEPENDS = "depends";
    private static final String TAG_CONVERSION = "conversion";
    private static final String TAG_REPLACE = "replace";
    private static final String TAG_REF = "ref";
    private static final String TAG_SWITCH = "switch";
    private static final String TAG_ECUPARAM = "ecuparam";
    private static final String TAG_ECU = "ecu";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESC = "desc";
    private static final String ATTR_ECUBYTEINDEX = "ecubyteindex";
    private static final String ATTR_LENGTH = "length";
    private static final String ATTR_ECUBIT = "ecubit";
    private static final String ATTR_UNITS = "units";
    private static final String ATTR_EXPRESSION = "expr";
    private static final String ATTR_FORMAT = "format";
    private static final String ATTR_BYTE = "byte";
    private static final String ATTR_BIT = "bit";
    private static final String ATTR_PARAMETER = "parameter";
    private static final String ATTR_STORAGETYPE = "storagetype";
    private static final String ATTR_BAUD = "baud";
    private static final String ATTR_DATABITS = "databits";
    private static final String ATTR_STOPBITS = "stopbits";
    private static final String ATTR_PARITY = "parity";
    private static final String ATTR_CONNECT_TIMEOUT = "connect_timeout";
    private static final String ATTR_SEND_TIMEOUT = "send_timeout";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_WITH = "with";
    private static final String ATTR_GAUGE_MIN = "gauge_min";
    private static final String ATTR_GAUGE_MAX = "gauge_max";
    private static final String ATTR_GAUGE_STEP = "gauge_step";
    private final String protocol;
    private final String fileLoggingControllerSwitchId;
    private final EcuInit ecuInit;
    private List<EcuParameter> params = new ArrayList<EcuParameter>();
    private List<EcuSwitch> switches = new ArrayList<EcuSwitch>();
    private EcuSwitch fileLoggingControllerSwitch;
    private ConnectionProperties connectionProperties;
    private Map<String, EcuData> ecuDataMap;
    private Map<String, String> replaceMap;
    private String id;
    private String name;
    private String desc;
    private String ecuByteIndex;
    private String ecuBit;
    private String ecuIds;
    private EcuAddress address;
    private Set<String> dependsList;
    private Map<String, EcuAddress> ecuAddressMap;
    private boolean derived;
    private int addressBit;
    private int addressLength;
    private Set<EcuDataConvertor> convertorList;
    private Set<EcuDerivedParameterConvertor> derivedConvertorList;
    private StringBuilder charBuffer;
    private boolean parseProtocol;
    private String conversionUnits;
    private String conversionExpression;
    private String conversionFormat;
    private String conversionStorageType;
    private GaugeMinMax conversionGauge;

    public LoggerDefinitionHandler(String string, String string2, EcuInit ecuInit) {
        ParamChecker.checkNotNullOrEmpty(string, TAG_PROTOCOL);
        ParamChecker.checkNotNullOrEmpty(string2, "fileLoggingControllerSwitchId");
        this.protocol = string;
        this.fileLoggingControllerSwitchId = string2;
        this.ecuInit = ecuInit;
    }

    @Override
    public void startDocument() {
        this.params = new ArrayList<EcuParameter>();
        this.switches = new ArrayList<EcuSwitch>();
        this.ecuDataMap = new HashMap<String, EcuData>();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (TAG_PROTOCOL.equals(string3)) {
            this.parseProtocol = this.protocol.equalsIgnoreCase(attributes.getValue(ATTR_ID));
            if (this.parseProtocol) {
                this.connectionProperties = new ConnectionPropertiesImpl(Integer.parseInt(attributes.getValue(ATTR_BAUD)), Integer.parseInt(attributes.getValue(ATTR_DATABITS)), Integer.parseInt(attributes.getValue(ATTR_STOPBITS)), Integer.parseInt(attributes.getValue(ATTR_PARITY)), Integer.parseInt(attributes.getValue(ATTR_CONNECT_TIMEOUT)), Integer.parseInt(attributes.getValue(ATTR_SEND_TIMEOUT)));
            }
        } else if (this.parseProtocol) {
            if ("parameter".equals(string3)) {
                this.id = attributes.getValue(ATTR_ID);
                this.name = attributes.getValue(ATTR_NAME);
                this.desc = attributes.getValue(ATTR_DESC);
                this.ecuByteIndex = attributes.getValue(ATTR_ECUBYTEINDEX);
                this.ecuBit = attributes.getValue(ATTR_ECUBIT);
                this.resetConvertorLists();
            } else if (TAG_ADDRESS.equals(string3)) {
                String string4 = attributes.getValue(ATTR_LENGTH);
                this.addressLength = string4 == null ? 1 : Integer.valueOf(string4);
                String string5 = attributes.getValue(ATTR_BIT);
                this.addressBit = string5 == null ? -1 : Integer.valueOf(string5);
                this.derived = false;
            } else if (TAG_DEPENDS.equals(string3)) {
                this.dependsList = new LinkedHashSet<String>();
                this.derived = true;
            } else if (TAG_REF.equals(string3)) {
                this.dependsList.add(attributes.getValue("parameter"));
            } else if (TAG_CONVERSION.equals(string3)) {
                this.conversionUnits = attributes.getValue(ATTR_UNITS);
                this.conversionExpression = attributes.getValue(ATTR_EXPRESSION);
                this.conversionFormat = attributes.getValue(ATTR_FORMAT);
                this.conversionStorageType = attributes.getValue(ATTR_STORAGETYPE);
                double d = this.getConversionMin(attributes, this.conversionUnits);
                double d2 = this.getConversionMax(attributes, this.conversionUnits);
                double d3 = this.getConversionStep(attributes, this.conversionUnits);
                this.conversionGauge = new GaugeMinMax(d, d2, d3);
                this.replaceMap = new HashMap<String, String>();
            } else if (TAG_REPLACE.equals(string3)) {
                this.replaceMap.put(attributes.getValue(ATTR_VALUE), attributes.getValue(ATTR_WITH));
            } else if (TAG_SWITCH.equals(string3)) {
                this.id = attributes.getValue(ATTR_ID);
                this.name = attributes.getValue(ATTR_NAME);
                this.desc = attributes.getValue(ATTR_DESC);
                this.address = new EcuAddressImpl(attributes.getValue(ATTR_BYTE), 1, Integer.valueOf(attributes.getValue(ATTR_BIT)));
                EcuDataConvertor[] ecuDataConvertorArray = new EcuDataConvertor[]{new EcuSwitchConvertorImpl(this.address.getBit())};
                EcuSwitchImpl ecuSwitchImpl = new EcuSwitchImpl(this.id, this.name, this.desc, this.address, ecuDataConvertorArray);
                this.switches.add(ecuSwitchImpl);
                this.ecuDataMap.put(ecuSwitchImpl.getId(), ecuSwitchImpl);
                if (this.id.equalsIgnoreCase(this.fileLoggingControllerSwitchId)) {
                    this.fileLoggingControllerSwitch = new EcuSwitchImpl(this.id, this.name, this.desc, this.address, ecuDataConvertorArray);
                }
            } else if (TAG_ECUPARAM.equals(string3)) {
                this.id = attributes.getValue(ATTR_ID);
                this.name = attributes.getValue(ATTR_NAME);
                this.desc = attributes.getValue(ATTR_DESC);
                this.resetConvertorLists();
                this.ecuAddressMap = new HashMap<String, EcuAddress>();
                this.derived = false;
            } else if (TAG_ECU.equals(string3)) {
                this.ecuIds = attributes.getValue(ATTR_ID);
            }
        }
        this.charBuffer = new StringBuilder();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.parseProtocol) {
            this.charBuffer.append(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        block14: {
            block16: {
                block17: {
                    block15: {
                        block13: {
                            if (!TAG_PROTOCOL.equals(string3)) break block13;
                            this.parseProtocol = false;
                            break block14;
                        }
                        if (!this.parseProtocol) break block14;
                        if (!TAG_ADDRESS.equals(string3)) break block15;
                        this.address = new EcuAddressImpl(this.charBuffer.toString(), this.addressLength, this.addressBit);
                        break block14;
                    }
                    if (!"parameter".equals(string3)) break block16;
                    if (!this.derived) break block17;
                    HashSet<EcuData> hashSet = new HashSet<EcuData>();
                    for (String string4 : this.dependsList) {
                        if (!this.ecuDataMap.containsKey(string4)) continue;
                        hashSet.add(this.ecuDataMap.get(string4));
                    }
                    if (this.dependsList.size() == hashSet.size()) {
                        EcuDerivedParameterImpl ecuDerivedParameterImpl = new EcuDerivedParameterImpl(this.id, this.name, this.desc, hashSet.toArray(new EcuData[hashSet.size()]), this.derivedConvertorList.toArray(new EcuDerivedParameterConvertor[this.derivedConvertorList.size()]));
                        this.params.add(ecuDerivedParameterImpl);
                        this.ecuDataMap.put(ecuDerivedParameterImpl.getId(), ecuDerivedParameterImpl);
                    }
                    break block14;
                }
                if (this.ecuByteIndex != null && this.ecuBit != null && this.ecuInit != null && !this.isSupportedParameter(this.ecuInit, this.ecuByteIndex, this.ecuBit)) break block14;
                if (this.convertorList.isEmpty()) {
                    this.convertorList.add(new EcuParameterConvertorImpl());
                }
                EcuParameterImpl ecuParameterImpl = new EcuParameterImpl(this.id, this.name, this.desc, this.address, this.convertorList.toArray(new EcuDataConvertor[this.convertorList.size()]));
                this.params.add(ecuParameterImpl);
                this.ecuDataMap.put(ecuParameterImpl.getId(), ecuParameterImpl);
                break block14;
            }
            if (TAG_CONVERSION.equals(string3)) {
                if (this.derived) {
                    this.derivedConvertorList.add(new EcuDerivedParameterConvertorImpl(this.conversionUnits, this.conversionExpression, this.conversionFormat, this.replaceMap, this.conversionGauge));
                } else {
                    this.convertorList.add(new EcuParameterConvertorImpl(this.conversionUnits, this.conversionExpression, this.conversionFormat, this.address.getBit(), FLOAT.equalsIgnoreCase(this.conversionStorageType), this.replaceMap, this.conversionGauge));
                }
            } else if (TAG_ECUPARAM.equals(string3)) {
                if (this.ecuInit != null && this.ecuAddressMap.containsKey(this.ecuInit.getEcuId())) {
                    if (this.convertorList.isEmpty()) {
                        this.convertorList.add(new EcuParameterConvertorImpl());
                    }
                    EcuParameterImpl ecuParameterImpl = new EcuParameterImpl(this.id, this.name, this.desc, this.ecuAddressMap.get(this.ecuInit.getEcuId()), this.convertorList.toArray(new EcuDataConvertor[this.convertorList.size()]));
                    this.params.add(ecuParameterImpl);
                    this.ecuDataMap.put(ecuParameterImpl.getId(), ecuParameterImpl);
                }
            } else if (TAG_ECU.equals(string3)) {
                for (String string5 : this.ecuIds.split(",")) {
                    this.ecuAddressMap.put(string5, this.address);
                }
            }
        }
    }

    public List<EcuParameter> getEcuParameters() {
        return this.params;
    }

    public List<EcuSwitch> getEcuSwitches() {
        return this.switches;
    }

    public EcuSwitch getFileLoggingControllerSwitch() {
        return this.fileLoggingControllerSwitch;
    }

    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    private void resetConvertorLists() {
        this.convertorList = new LinkedHashSet<EcuDataConvertor>();
        this.derivedConvertorList = new LinkedHashSet<EcuDerivedParameterConvertor>();
    }

    private boolean isSupportedParameter(EcuInit ecuInit, String string, String string2) {
        byte[] byArray = ecuInit.getEcuInitBytes();
        int n = Integer.parseInt(string);
        if (n < byArray.length) {
            byte[] byArray2 = new byte[1];
            System.arraycopy(byArray, n, byArray2, 0, 1);
            return (byArray2[0] & 1 << Integer.parseInt(string2)) > 0;
        }
        return false;
    }

    private double getConversionMin(Attributes attributes, String string) {
        String string2 = attributes.getValue(ATTR_GAUGE_MIN);
        if (!ParamChecker.isNullOrEmpty(string2)) {
            return Double.parseDouble(string2);
        }
        return ConverterMaxMinDefaults.getMin(string);
    }

    private double getConversionMax(Attributes attributes, String string) {
        String string2 = attributes.getValue(ATTR_GAUGE_MAX);
        if (!ParamChecker.isNullOrEmpty(string2)) {
            return Double.parseDouble(string2);
        }
        return ConverterMaxMinDefaults.getMax(string);
    }

    private double getConversionStep(Attributes attributes, String string) {
        String string2 = attributes.getValue(ATTR_GAUGE_STEP);
        if (!ParamChecker.isNullOrEmpty(string2)) {
            return Double.parseDouble(string2);
        }
        return ConverterMaxMinDefaults.getStep(string);
    }
}

