/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.external;

import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.util.ParamChecker;
import com.romraider.util.Stoppable;
import com.romraider.util.ThreadUtil;
import org.apache.log4j.Logger;

public final class GenericDataSourceConnector
implements Stoppable {
    private static final Logger LOGGER = Logger.getLogger(GenericDataSourceConnector.class);
    private final ExternalDataSource dataSource;
    private boolean stop;

    public GenericDataSourceConnector(ExternalDataSource externalDataSource) {
        ParamChecker.checkNotNull(externalDataSource);
        this.dataSource = externalDataSource;
    }

    public void run() {
        LOGGER.info((Object)(this.dataSource.getName() + ": connecting..."));
        while (!this.stop) {
            try {
                this.dataSource.connect();
                LOGGER.info((Object)(this.dataSource.getName() + ": connected."));
                break;
            }
            catch (Exception exception) {
                LOGGER.error((Object)(this.dataSource.getName() + ": connect error"), (Throwable)exception);
                ThreadUtil.sleep(500L);
            }
        }
    }

    public void stop() {
        this.stop = true;
    }
}

