/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.profile;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.exception.ConfigurationException;
import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileItem;
import com.romraider.util.ParamChecker;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserProfileImpl
implements UserProfile {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Map<String, UserProfileItem> params;
    private final Map<String, UserProfileItem> switches;
    private final Map<String, UserProfileItem> external;

    public UserProfileImpl(Map<String, UserProfileItem> map, Map<String, UserProfileItem> map2, Map<String, UserProfileItem> map3) {
        ParamChecker.checkNotNull(map, "params");
        ParamChecker.checkNotNull(map2, "switches");
        ParamChecker.checkNotNull(map3, "external");
        this.params = map;
        this.switches = map2;
        this.external = map3;
    }

    @Override
    public boolean contains(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.getMap(loggerData).keySet().contains(loggerData.getId());
    }

    @Override
    public boolean isSelectedOnLiveDataTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isLiveDataSelected();
    }

    @Override
    public boolean isSelectedOnGraphTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isGraphSelected();
    }

    @Override
    public boolean isSelectedOnDashTab(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        return this.contains(loggerData) && this.getUserProfileItem(loggerData).isDashSelected();
    }

    @Override
    public EcuDataConvertor getSelectedConvertor(LoggerData loggerData) {
        String string;
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        if (this.contains(loggerData) && (string = this.getUserProfileItem(loggerData).getUnits()) != null && loggerData.getConvertors().length > 1) {
            for (EcuDataConvertor ecuDataConvertor : loggerData.getConvertors()) {
                if (!string.equals(ecuDataConvertor.getUnits())) continue;
                return ecuDataConvertor;
            }
            throw new ConfigurationException("Unknown default units, '" + string + "', specified for [" + loggerData.getId() + "] " + loggerData.getName());
        }
        return loggerData.getSelectedConvertor();
    }

    @Override
    public byte[] getBytes() {
        return this.buildXml().getBytes();
    }

    private String buildXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append(NEW_LINE);
        stringBuilder.append("<!DOCTYPE profile SYSTEM \"profile.dtd\">").append(NEW_LINE).append(NEW_LINE);
        stringBuilder.append("<profile>").append(NEW_LINE);
        if (!this.params.isEmpty()) {
            stringBuilder.append("    <parameters>").append(NEW_LINE);
            this.appendLoggerDataElements(stringBuilder, "parameter", this.params, true);
            stringBuilder.append("    </parameters>").append(NEW_LINE);
        }
        if (!this.switches.isEmpty()) {
            stringBuilder.append("    <switches>").append(NEW_LINE);
            this.appendLoggerDataElements(stringBuilder, "switch", this.switches, false);
            stringBuilder.append("    </switches>").append(NEW_LINE);
        }
        if (!this.external.isEmpty()) {
            stringBuilder.append("    <externals>").append(NEW_LINE);
            this.appendLoggerDataElements(stringBuilder, "external", this.external, false);
            stringBuilder.append("    </externals>").append(NEW_LINE);
        }
        stringBuilder.append("</profile>").append(NEW_LINE);
        return stringBuilder.toString();
    }

    private void appendLoggerDataElements(StringBuilder stringBuilder, String string, Map<String, UserProfileItem> map, boolean bl) {
        for (String string2 : map.keySet()) {
            UserProfileItem userProfileItem = map.get(string2);
            stringBuilder.append("        <").append(string).append(" id=\"").append(string2).append("\"");
            if (userProfileItem.isLiveDataSelected()) {
                stringBuilder.append(" livedata=\"selected\"");
            }
            if (userProfileItem.isGraphSelected()) {
                stringBuilder.append(" graph=\"selected\"");
            }
            if (userProfileItem.isDashSelected()) {
                stringBuilder.append(" dash=\"selected\"");
            }
            if (bl && !ParamChecker.isNullOrEmpty(userProfileItem.getUnits())) {
                stringBuilder.append(" units=\"").append(userProfileItem.getUnits()).append("\"");
            }
            stringBuilder.append("/>").append(NEW_LINE);
        }
    }

    private UserProfileItem getUserProfileItem(LoggerData loggerData) {
        return this.getMap(loggerData).get(loggerData.getId());
    }

    private Map<String, UserProfileItem> getMap(LoggerData loggerData) {
        if (loggerData instanceof EcuParameter) {
            return this.params;
        }
        if (loggerData instanceof EcuSwitch) {
            return this.switches;
        }
        if (loggerData instanceof ExternalData) {
            return this.external;
        }
        throw new UnsupportedOperationException("Unknown LoggerData type: " + loggerData.getClass());
    }
}

