/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.profile;

import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.logger.ecu.profile.UserProfileLoader;
import com.romraider.logger.ecu.profile.xml.UserProfileHandler;
import com.romraider.util.ParamChecker;
import com.romraider.util.SaxParserFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public final class UserProfileLoaderImpl
implements UserProfileLoader {
    private static final Logger LOGGER = Logger.getLogger(UserProfileLoaderImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile loadProfile(String string) {
        UserProfile userProfile;
        ParamChecker.checkNotNullOrEmpty(string, "userProfileFilePath");
        LOGGER.info((Object)("Loading profile: " + string));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
        try {
            UserProfileHandler userProfileHandler = new UserProfileHandler();
            SaxParserFactory.getSaxParser().parse((InputStream)bufferedInputStream, (DefaultHandler)userProfileHandler);
            userProfile = userProfileHandler.getUserProfile();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error loading user profile file: " + string), (Throwable)exception);
                return null;
            }
        }
        ((InputStream)bufferedInputStream).close();
        return userProfile;
    }
}

